/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.integration.HardcodedBlockTypes;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.misc.DynamicHolder;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynResourceGenerator;
import net.mehvahdjukaar.moonlight.api.resources.recipe.BlockTypeSwapIngredient;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.trades.ItemListingRegistry;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.mehvahdjukaar.moonlight.core.CommonConfigs;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.VillagerAIInternal;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.mehvahdjukaar.moonlight.core.set.BlocksColorInternal;
import net.mehvahdjukaar.moonlight.core.set.DebugBlockTypes;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1928;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Moonlight {
    public static final String MOD_ID = "moonlight";
    public static final Logger LOGGER = LogManager.getLogger((String)"Moonlight");
    public static final boolean HAS_BEEN_INIT = true;
    public static final ThreadLocal<WeakReference<class_5455>> EARLY_REGISTRY_ACCESS = new ThreadLocal();

    public static class_2960 res(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void commonInit() {
        CommonConfigs.init();
        BlockSetInternal.registerBlockSetDefinition(WoodTypeRegistry.INSTANCE);
        BlockSetInternal.registerBlockSetDefinition(LeavesTypeRegistry.INSTANCE);
        HardcodedBlockTypes.init();
        MoonlightRegistry.init();
        ModMessages.init();
        BlockTypeSwapIngredient.init();
        VillagerAIInternal.init();
        MapDataInternal.init();
        SoftFluidInternal.init();
        RegHelper.addDynamicDispenserBehaviorRegistration(Moonlight::registerBuiltinFluidBehavior);
        PlatHelper.addCommonSetup(Moonlight::commonSetup);
        PlatHelper.addServerReloadListener((class_3302)new ItemListingRegistry(), Moonlight.res("villager_trades"));
        BlockSetAPI.addDynamicRegistration((reg, wood) -> AdditionalItemPlacementsAPI.afterItemReg(), WoodType.class, class_7923.field_41181);
        if (PlatHelper.getPhysicalSide().isClient()) {
            MoonlightClient.initClient();
        }
    }

    private static void commonSetup() {
        BlocksColorInternal.setup();
        if (PlatHelper.isDev()) {
            // empty if block
        }
        if (PlatHelper.getPhysicalSide().isClient()) {
            MoonlightClient.setupClient();
        }
        if (CommonConfigs.EXTRA_DEBUG.get().booleanValue()) {
            DebugBlockTypes.writeToFile();
        }
    }

    public static void onPlayerCloned(class_1657 oldPlayer, class_1657 newPlayer, boolean wasDeath) {
        if (wasDeath && !oldPlayer.method_37908().method_8450().method_8355(class_1928.field_19389)) {
            class_1661 inv = oldPlayer.method_31548();
            int i = 0;
            for (class_1799 v : inv.field_7547) {
                if (v != class_1799.field_8037) {
                    IDropItemOnDeathEvent e = IDropItemOnDeathEvent.create(v, oldPlayer, false);
                    MoonlightEventsHelper.postEvent(e, IDropItemOnDeathEvent.class);
                    if (e.isCanceled()) {
                        newPlayer.method_31548().method_5447(i, e.getReturnItemStack());
                    }
                }
                ++i;
            }
        }
    }

    public static void setServerRegistryAccess(class_5455.class_6890 registryAccess) {
        EARLY_REGISTRY_ACCESS.set(new WeakReference<class_5455.class_6890>(registryAccess));
    }

    public static void afterDataReload(class_5455 registryAccess, boolean client) {
        EARLY_REGISTRY_ACCESS.set(new WeakReference<class_5455>(registryAccess));
        RegistryAccessJsonReloadListener.runReloads(registryAccess);
        DynResourceGenerator.clearAfterReload(class_3264.field_14190);
        DynamicHolder.clearCache();
        DispenserHelper.reload(registryAccess);
    }

    public static void beforeServerStart(class_5455 ra) {
        SoftFluidInternal.doPostInitServer(ra);
    }

    public static void assertInitPhase() {
        if (!PlatHelper.isInitializing() && PlatHelper.isDev() && PlatHelper.getPlatform().isForge()) {
            throw new AssertionError((Object)"Method has to be called during main mod initialization phase. Client and Server initializer are not valid, you must call in the main one");
        }
    }

    public static class_22 getMapDataFromKnownKeys(class_3218 level, int mapId) {
        class_22 d = level.method_17891(class_1806.method_17440((int)mapId));
        if (d == null && (d = level.method_17891("magicmap_" + mapId)) == null) {
            d = level.method_17891("mazemap_" + mapId);
        }
        return d;
    }

    public static void checkDataPackRegistry() {
        try {
            SoftFluidRegistry.getEmpty();
            MapDataRegistry.getDefaultType();
        }
        catch (Exception e) {
            throw new RuntimeException("Not all required entries were found in datapack registry. How did this happen?\nThis MUST be some OTHER mod messing up datapack registries (currently Cyanide is known to cause this).\nNote that this could be caused by Paper or similar servers. Know that those are NOT meant to be used with mods", e);
        }
    }

    public static void crashIfInDev(String message) {
        if (PlatHelper.isDev()) {
            throw new AssertionError((Object)message);
        }
        LOGGER.error(message);
    }

    public static void crashIfInDev() {
        Moonlight.crashIfInDev("");
    }

    public static void logIfInDev(String s) {
        if (PlatHelper.isDev()) {
            LOGGER.error(s);
        }
    }

    public static void registerBuiltinFluidBehavior(DispenserHelper.Event event) {
        HashSet<class_1792> itemSet = new HashSet<class_1792>();
        for (SoftFluid f : SoftFluidRegistry.getRegistry(event.getRegistryAccess())) {
            Collection<FluidContainerList.Category> categories = f.getContainerList().getCategories();
            for (FluidContainerList.Category c : categories) {
                class_1792 empty = c.getEmptyContainer();
                if (empty != class_1802.field_8162 && !itemSet.contains(empty)) {
                    event.register(new DispenserHelper.FillFluidHolderBehavior(empty));
                    itemSet.add(empty);
                }
                for (class_1792 full : c.getFilledItems()) {
                    if (full == class_1802.field_8162 || itemSet.contains(full)) continue;
                    event.register(new DispenserHelper.FillFluidHolderBehavior(full));
                    itemSet.add(full);
                }
            }
        }
    }
}

