/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.satisfy.herbalbrews.core.blocks.entity.TeaKettleBlockEntity;
import net.satisfy.herbalbrews.core.registry.RecipeTypeRegistry;
import net.satisfy.herbalbrews.core.util.HerbalBrewsUtil;
import org.jetbrains.annotations.NotNull;

public class TeaKettleRecipe
implements class_1860<class_1263> {
    final class_2960 id;
    private final class_2371<class_1856> inputs;
    private final class_1799 output;
    private final class_1291 effect;
    private final int effectDuration;
    private final int requiredWater;
    private final int requiredHeat;
    private final int requiredDuration;

    public TeaKettleRecipe(class_2960 id, class_2371<class_1856> inputs, class_1799 output, class_1291 effect, int effectDuration, int requiredWater, int requiredHeat, int requiredDuration) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.effect = effect;
        this.effectDuration = effectDuration;
        this.requiredWater = requiredWater;
        this.requiredHeat = requiredHeat;
        this.requiredDuration = requiredDuration;
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return HerbalBrewsUtil.matchesRecipe(inventory, this.inputs, 0, 5) && this.waterLevelSufficient(inventory) && this.heatLevelSufficient(inventory);
    }

    private boolean waterLevelSufficient(class_1263 inventory) {
        if (inventory instanceof TeaKettleBlockEntity) {
            TeaKettleBlockEntity teaKettle = (TeaKettleBlockEntity)inventory;
            return teaKettle.getWaterLevel() >= this.requiredWater;
        }
        return false;
    }

    private boolean heatLevelSufficient(class_1263 inventory) {
        if (inventory instanceof TeaKettleBlockEntity) {
            TeaKettleBlockEntity teaKettle = (TeaKettleBlockEntity)inventory;
            return teaKettle.getHeatLevel() >= this.requiredHeat;
        }
        return false;
    }

    public class_1799 assemble() {
        return this.method_8116(null, null);
    }

    @NotNull
    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1799 getResultItem() {
        return this.method_8110(null);
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryManager) {
        return this.output;
    }

    public class_1291 getEffect() {
        return this.effect;
    }

    public int getEffectDuration() {
        return this.effectDuration;
    }

    public int getRequiredWater() {
        return this.requiredWater;
    }

    public int getRequiredHeat() {
        return this.requiredHeat;
    }

    public int getRequiredDuration() {
        return this.requiredDuration;
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)RecipeTypeRegistry.TEA_KETTLE_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return (class_3956)RecipeTypeRegistry.TEA_KETTLE_RECIPE_TYPE.get();
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.inputs;
    }

    public boolean method_8118() {
        return true;
    }

    public static class Type
    implements class_3956<TeaKettleRecipe> {
        private Type() {
        }
    }

    public static class Serializer
    implements class_1865<TeaKettleRecipe> {
        @NotNull
        public TeaKettleRecipe fromJson(class_2960 id, JsonObject json) {
            JsonArray heatArray;
            JsonArray fluidArray;
            class_2960 effectId;
            class_2371<class_1856> ingredients = HerbalBrewsUtil.deserializeIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Tea Kettle Recipe");
            }
            if (ingredients.size() > 6) {
                throw new JsonParseException("Too many ingredients for Tea Kettle Recipe");
            }
            JsonObject result = class_3518.method_15296((JsonObject)json, (String)"result");
            class_1799 output = class_1869.method_35228((JsonObject)result);
            class_1291 effect = null;
            int effectDuration = 0;
            if (result.has("effect") && (effect = (class_1291)class_7923.field_41174.method_10223(effectId = new class_2960(class_3518.method_15265((JsonObject)result, (String)"effect")))) == null) {
                throw new JsonParseException("Invalid effect ID: " + effectId);
            }
            if (result.has("effectduration")) {
                effectDuration = class_3518.method_15260((JsonObject)result, (String)"effectduration");
            }
            int requiredWater = 0;
            if (json.has("fluid") && !(fluidArray = class_3518.method_15261((JsonObject)json, (String)"fluid")).isEmpty()) {
                requiredWater = class_3518.method_15260((JsonObject)fluidArray.get(0).getAsJsonObject(), (String)"amount");
            }
            int requiredHeat = 0;
            if (json.has("heat_needed") && !(heatArray = class_3518.method_15261((JsonObject)json, (String)"heat_needed")).isEmpty()) {
                requiredHeat = class_3518.method_15260((JsonObject)heatArray.get(0).getAsJsonObject(), (String)"amount");
            }
            int requiredDuration = 0;
            if (json.has("crafting_duration")) {
                requiredDuration = class_3518.method_15260((JsonObject)json, (String)"crafting_duration") * 20;
            }
            return new TeaKettleRecipe(id, ingredients, output, effect, effectDuration, requiredWater, requiredHeat, requiredDuration);
        }

        @NotNull
        public TeaKettleRecipe fromNetwork(class_2960 id, class_2540 buf) {
            class_2371 ingredients = class_2371.method_10213((int)buf.method_10816(), (Object)class_1856.field_9017);
            ingredients.replaceAll(ignored -> class_1856.method_8086((class_2540)buf));
            class_1799 output = buf.method_10819();
            class_1291 effect = null;
            int effectDuration = 0;
            boolean hasEffect = buf.readBoolean();
            if (hasEffect) {
                class_2960 effectId = buf.method_10810();
                effect = (class_1291)class_7923.field_41174.method_10223(effectId);
                effectDuration = buf.readInt();
            }
            int requiredWater = buf.readInt();
            int requiredHeat = buf.readInt();
            int requiredDuration = buf.readInt();
            return new TeaKettleRecipe(id, (class_2371<class_1856>)ingredients, output, effect, effectDuration, requiredWater, requiredHeat, requiredDuration);
        }

        public void toNetwork(class_2540 buf, TeaKettleRecipe recipe) {
            buf.method_10804(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.method_8088(buf));
            buf.method_10793(recipe.output);
            if (recipe.effect != null) {
                buf.writeBoolean(true);
                buf.method_10812(recipe.effect.method_5567().contains(":") ? new class_2960(recipe.effect.method_5567().split(":")[1]) : new class_2960("minecraft", "unknown"));
                buf.writeInt(recipe.effectDuration);
            } else {
                buf.writeBoolean(false);
            }
            buf.writeInt(recipe.requiredWater);
            buf.writeInt(recipe.requiredHeat);
            buf.writeInt(recipe.requiredDuration);
        }
    }
}

