/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks.entity;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.satisfy.herbalbrews.client.gui.handler.TeaKettleGuiHandler;
import net.satisfy.herbalbrews.core.blocks.TeaKettleBlock;
import net.satisfy.herbalbrews.core.recipe.TeaKettleRecipe;
import net.satisfy.herbalbrews.core.registry.EntityTypeRegistry;
import net.satisfy.herbalbrews.core.registry.RecipeTypeRegistry;
import net.satisfy.herbalbrews.core.registry.TagsRegistry;
import net.satisfy.herbalbrews.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeaKettleBlockEntity
extends class_2586
implements ImplementedInventory,
class_3908 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    private static final int MAX_CAPACITY = 8;
    private static final int MAX_HEAT_LEVEL = 100;
    private static final int HEAT_CONSUMPTION_THRESHOLD = 70;
    private static final int HEAT_PER_ITEM = 35;
    private int cookingTime;
    private int requiredDuration;
    public static final int OUTPUT_SLOT = 0;
    private static final int INGREDIENTS_AREA = 5;
    private static final int WATER_SLOT = 6;
    private static final int HEATING_SLOT = 7;
    private boolean isBeingBurned = false;
    protected float experience;
    private int waterLevel;
    private int heatLevel = 0;
    private int heatDecreaseCounter = 0;
    private static final int HEAT_DECREASE_INTERVAL = 200;
    private final class_3913 delegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> TeaKettleBlockEntity.this.cookingTime;
                case 1 -> {
                    if (TeaKettleBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                case 2 -> TeaKettleBlockEntity.this.waterLevel;
                case 3 -> TeaKettleBlockEntity.this.heatLevel;
                case 4 -> TeaKettleBlockEntity.this.requiredDuration;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    TeaKettleBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    TeaKettleBlockEntity.this.isBeingBurned = value != 0;
                    TeaKettleBlockEntity.this.heatLevel = TeaKettleBlockEntity.this.isBeingBurned ? 30 : 0;
                    break;
                }
                case 2: {
                    TeaKettleBlockEntity.this.waterLevel = value;
                    break;
                }
                case 3: {
                    TeaKettleBlockEntity.this.heatLevel = value;
                    break;
                }
                case 4: {
                    TeaKettleBlockEntity.this.requiredDuration = value;
                }
            }
        }

        public int method_17389() {
            return 5;
        }
    };
    public boolean doEffect;

    public TeaKettleBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.TEA_KETTLE_BLOCK_ENTITY.get(), pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.cookingTime = nbt.method_10550("CookingTime");
        this.isBeingBurned = nbt.method_10577("IsBeingBurned");
        this.waterLevel = nbt.method_10550("WaterLevel");
        this.heatLevel = nbt.method_10550("HeatLevel");
        this.experience = nbt.method_10583("Experience");
        this.requiredDuration = nbt.method_10550("RequiredDuration");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("CookingTime", this.cookingTime);
        nbt.method_10556("IsBeingBurned", this.isBeingBurned);
        nbt.method_10569("WaterLevel", this.waterLevel);
        nbt.method_10569("HeatLevel", this.heatLevel);
        nbt.method_10548("Experience", this.experience);
        nbt.method_10569("RequiredDuration", this.requiredDuration);
    }

    public boolean isBeingBurned() {
        if (this.method_10997() == null) {
            throw new NullPointerException("Null world invoked");
        }
        class_2680 belowState = this.method_10997().method_8320(this.method_11016().method_10074());
        Optional optionalList = class_7923.field_41175.method_40266(TagsRegistry.ALLOWS_COOKING);
        class_6885.class_6888 entryList = optionalList.orElse(null);
        if (entryList == null) {
            return false;
        }
        return entryList.method_40241((class_6880)belowState.method_26204().method_40142());
    }

    private boolean canCraft(TeaKettleRecipe recipe) {
        if (recipe == null || recipe.getResultItem().method_7960()) {
            return false;
        }
        if (this.method_5438(0).method_7960()) {
            return this.waterLevel >= recipe.getRequiredWater() && this.heatLevel >= recipe.getRequiredHeat();
        }
        class_1799 recipeOutput = recipe.getResultItem();
        class_1799 outputSlotStack = this.method_5438(0);
        int outputSlotCount = outputSlotStack.method_7947();
        if (!class_1799.method_7984((class_1799)outputSlotStack, (class_1799)recipeOutput)) {
            return false;
        }
        if (outputSlotCount < this.method_5444() && outputSlotCount < outputSlotStack.method_7914()) {
            return this.waterLevel >= recipe.getRequiredWater() && this.heatLevel >= recipe.getRequiredHeat();
        }
        if (this.waterLevel < recipe.getRequiredWater() || this.heatLevel < recipe.getRequiredHeat()) {
            return false;
        }
        return outputSlotCount < recipeOutput.method_7914();
    }

    private void craft(TeaKettleRecipe recipe) {
        class_1799 outputSlotStack;
        if (!this.canCraft(recipe)) {
            return;
        }
        class_2371 ingredients = class_2371.method_10211();
        for (int i = 1; i <= 5; ++i) {
            ingredients.add((Object)this.method_5438(i));
        }
        for (class_1856 ingredient : recipe.method_8117()) {
            boolean ingredientConsumed = false;
            for (int i = 0; i < ingredients.size(); ++i) {
                class_1799 inputStack = (class_1799)ingredients.get(i);
                if (inputStack.method_7960() || !ingredient.method_8093(inputStack)) continue;
                class_1799 remainderStack = this.getRemainderItem(inputStack);
                inputStack.method_7934(1);
                if (inputStack.method_7960()) {
                    this.method_5447(i + 1, remainderStack);
                }
                ingredientConsumed = true;
                ingredients.set(i, (Object)inputStack);
                break;
            }
            if (ingredientConsumed) continue;
            return;
        }
        class_1799 recipeOutput = recipe.assemble();
        if (recipe.getEffect() != null && recipe.getEffectDuration() > 0) {
            class_2487 tag = recipeOutput.method_7948();
            tag.method_10582("Effect", Objects.requireNonNull(class_7923.field_41174.method_10221((Object)recipe.getEffect())).toString());
            tag.method_10569("EffectDuration", recipe.getEffectDuration());
            recipeOutput.method_7980(tag);
        }
        if ((outputSlotStack = this.method_5438(0)).method_7960()) {
            this.method_5447(0, recipeOutput);
        } else if (outputSlotStack.method_31574(recipeOutput.method_7909())) {
            outputSlotStack.method_7933(recipeOutput.method_7947());
        }
        this.waterLevel -= recipe.getRequiredWater();
        if (this.waterLevel < 0) {
            this.waterLevel = 0;
        }
        this.requiredDuration = recipe.getRequiredDuration();
        this.cookingTime = 0;
    }

    private class_1799 getRemainderItem(class_1799 stack) {
        if (stack.method_7909().method_7857()) {
            return new class_1799((class_1935)Objects.requireNonNull(stack.method_7909().method_7858()));
        }
        return class_1799.field_8037;
    }

    public void consumeHeatItem() {
        class_1799 heatingItem = (class_1799)this.inventory.get(7);
        if (!heatingItem.method_7960() && heatingItem.method_31573(TagsRegistry.HEAT_ITEMS)) {
            heatingItem.method_7934(1);
            this.inventory.set(7, (Object)heatingItem);
            this.doEffect = true;
            this.method_5431();
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
            }
        }
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        tag.method_10556("DoEffect", this.doEffect);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        TeaKettleRecipe recipe;
        boolean canCraft;
        int decreaseInterval;
        boolean currentBurned;
        if (world.method_8608()) {
            return;
        }
        boolean previousBurned = this.isBeingBurned;
        this.isBeingBurned = currentBurned = this.isBeingBurned();
        if (!previousBurned && currentBurned) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            this.heatLevel = Math.max(this.heatLevel, 30);
        } else if (previousBurned && !currentBurned) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            this.heatLevel = 0;
        }
        class_1799 heatingItem = this.method_5438(7);
        if (this.heatLevel < 70 && !heatingItem.method_7960() && heatingItem.method_31573(TagsRegistry.HEAT_ITEMS)) {
            this.heatLevel = Math.min(this.heatLevel + 35, 100);
            this.consumeHeatItem();
            this.method_5431();
        }
        ++this.heatDecreaseCounter;
        int n = decreaseInterval = this.isBeingBurned ? 200 : 33;
        if (this.heatDecreaseCounter >= decreaseInterval) {
            this.heatDecreaseCounter = 0;
            if (this.heatLevel > (this.isBeingBurned ? 30 : 0)) {
                this.heatLevel = Math.max(this.heatLevel - 1, this.isBeingBurned ? 30 : 0);
                this.method_5431();
            }
        }
        if (canCraft = this.canCraft(recipe = (TeaKettleRecipe)world.method_8433().method_8132((class_3956)RecipeTypeRegistry.TEA_KETTLE_RECIPE_TYPE.get(), (class_1263)this, world).orElse(null))) {
            if (this.requiredDuration <= 0) {
                this.requiredDuration = recipe.getRequiredDuration();
                this.cookingTime = 0;
            } else {
                ++this.cookingTime;
                if (this.cookingTime >= this.requiredDuration) {
                    this.cookingTime = 0;
                    this.craft(recipe);
                }
            }
            world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)TeaKettleBlock.COOKING, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(this.isBeingBurned)), 3);
        } else {
            this.cookingTime = 0;
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TeaKettleBlock.COOKING, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (!this.method_5438(6).method_7960()) {
            class_1799 waterItem = this.method_5438(6);
            if (waterItem.method_31573(TagsRegistry.SMALL_WATER_FILL)) {
                this.waterLevel = Math.min(this.waterLevel + 25, 100);
                class_1799 remainderStack = this.getRemainderItem(waterItem);
                waterItem.method_7934(1);
                this.method_5447(6, remainderStack.method_7960() ? class_1799.field_8037 : remainderStack);
                this.method_5431();
            } else if (waterItem.method_31573(TagsRegistry.LARGE_WATER_FILL)) {
                this.waterLevel = Math.min(this.waterLevel + 50, 100);
                class_1799 remainderStack = this.getRemainderItem(waterItem);
                waterItem.method_7934(1);
                this.method_5447(6, remainderStack.method_7960() ? class_1799.field_8037 : remainderStack);
                this.method_5431();
            }
        }
        this.delegate.method_17391(3, this.heatLevel);
        this.delegate.method_17391(4, this.requiredDuration);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public int getHeatLevel() {
        return this.heatLevel;
    }

    @Override
    public boolean method_5443(class_1657 player) {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void dropExperience(class_3218 world, class_243 pos) {
        class_1303.method_31493((class_3218)world, (class_243)pos, (int)((int)this.experience));
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new TeaKettleGuiHandler(syncId, inv, (class_1263)this, this.delegate);
    }

    @Override
    public int @NotNull [] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[]{0, 6};
        }
        return new int[]{1, 2, 3, 4, 5, 6, 7};
    }

    @Override
    public boolean method_5492(int index, class_1799 stack, class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return false;
        }
        if (stack.method_31573(TagsRegistry.CONTAINER_ITEMS)) {
            return index == 5;
        }
        if (stack.method_31573(TagsRegistry.HEAT_ITEMS)) {
            return index == 7;
        }
        if (stack.method_31573(TagsRegistry.SMALL_WATER_FILL) || stack.method_31573(TagsRegistry.LARGE_WATER_FILL)) {
            return index == 6;
        }
        return index >= 1 && index <= 4;
    }

    @Override
    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return index == 0 || index == 6;
    }
}

