/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.satisfy.herbalbrews.client.gui.handler.CauldronGuiHandler;
import net.satisfy.herbalbrews.core.registry.EntityTypeRegistry;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import net.satisfy.herbalbrews.core.world.ImplementedInventory;
import net.satisfy.herbalbrews.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CauldronBlockEntity
extends class_2586
implements ImplementedInventory,
class_5558<CauldronBlockEntity>,
class_3908 {
    public static final int CAPACITY = 5;
    private static final int[] SLOTS_FOR_SIDE = new int[]{0, 4};
    private static final int[] SLOTS_FOR_UP = new int[]{1, 2};
    private static final int[] SLOTS_FOR_DOWN = new int[]{3};
    private class_2371<class_1799> inventory;
    private int brewingTime = 0;
    private int totalBrewingTime;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> CauldronBlockEntity.this.brewingTime;
                case 1 -> CauldronBlockEntity.this.totalBrewingTime;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    CauldronBlockEntity.this.brewingTime = value;
                    break;
                }
                case 1: {
                    CauldronBlockEntity.this.totalBrewingTime = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public CauldronBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.CAULDRON_BLOCK_ENTITY.get(), pos, state);
        this.inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.brewingTime = nbt.method_10550("BrewingTime");
        this.totalBrewingTime = nbt.method_10550("TotalBrewingTime");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("BrewingTime", this.brewingTime);
        nbt.method_10569("TotalBrewingTime", this.totalBrewingTime);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, CauldronBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        boolean dirty = false;
        if (this.canCraft()) {
            ++this.brewingTime;
            if (this.brewingTime >= this.totalBrewingTime) {
                this.brewingTime = 0;
                this.craft(world);
                dirty = true;
            }
        } else {
            this.brewingTime = 0;
        }
        if (dirty) {
            this.method_5431();
        }
    }

    private boolean canCraft() {
        for (int i = 0; i < 3; ++i) {
            class_1799 stack = this.method_5438(i);
            if (!stack.method_7960() && stack.method_7909() instanceof class_1812) continue;
            return false;
        }
        class_1799 catalyst = this.method_5438(4);
        if (catalyst.method_7960() || catalyst.method_7909() != ObjectRegistry.HERBAL_INFUSION.get()) {
            return false;
        }
        class_1799 output = this.method_5438(3);
        return output.method_7960();
    }

    private void craft(class_1937 world) {
        ArrayList combinedEffects = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            class_1799 potionStack = this.method_5438(i);
            List potionEffects = class_1844.method_8067((class_1799)potionStack);
            combinedEffects.addAll(potionEffects);
        }
        if (combinedEffects.isEmpty()) {
            return;
        }
        HashMap<class_1291, class_1293> uniqueEffectsMap = new HashMap<class_1291, class_1293>();
        for (class_1293 effectInstance : combinedEffects) {
            class_1291 effect = effectInstance.method_5579();
            if (uniqueEffectsMap.containsKey(effect) && effectInstance.method_5578() <= ((class_1293)uniqueEffectsMap.get(effect)).method_5578()) continue;
            uniqueEffectsMap.put(effect, new class_1293(effect, effectInstance.method_5584(), effectInstance.method_5578()));
        }
        class_1799 outputPotion = new class_1799((class_1935)ObjectRegistry.FLASK.get());
        class_2487 outputTag = outputPotion.method_7948();
        class_2499 newEffectsList = new class_2499();
        class_5819 random = world != null ? world.method_8409() : class_5819.method_43047();
        int randomTexture = random.method_43048(6) + 1;
        outputTag.method_10569("CustomModelData", randomTexture);
        for (class_1293 effectInstance : uniqueEffectsMap.values()) {
            class_2487 effectTag = new class_2487();
            int effectId = class_7923.field_41174.method_10206((Object)effectInstance.method_5579());
            if (effectId == -1) continue;
            effectTag.method_10569("Id", effectId);
            effectTag.method_10567("Amplifier", (byte)effectInstance.method_5578());
            effectTag.method_10569("Duration", effectInstance.method_5584());
            newEffectsList.add((Object)effectTag);
        }
        outputTag.method_10566("CustomPotionEffects", (class_2520)newEffectsList);
        this.method_5447(3, outputPotion);
        for (int i = 0; i < 3; ++i) {
            this.method_5434(i, 1);
        }
        this.method_5434(4, 1);
    }

    @Override
    public int @NotNull [] method_5494(class_2350 side) {
        if (side.equals((Object)class_2350.field_11036)) {
            return SLOTS_FOR_UP;
        }
        if (side.equals((Object)class_2350.field_11033)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDE;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        class_1799 stackInSlot = (class_1799)this.inventory.get(slot);
        boolean dirty = !stack.method_7960() && class_1799.method_7984((class_1799)stack, (class_1799)stackInSlot) && class_1799.method_7973((class_1799)stack, (class_1799)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (slot < 3 && !dirty) {
            this.totalBrewingTime = PlatformHelper.getBrewingDuration();
            this.brewingTime = 0;
            this.method_5431();
        }
        if (slot == 4 && !dirty) {
            this.method_5431();
        }
    }

    @Override
    public boolean method_5443(class_1657 player) {
        assert (this.field_11863 != null);
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new CauldronGuiHandler(syncId, inv, (class_1263)this, this.propertyDelegate);
    }
}

