/*
 * Decompiled with CFR 0.152.
 */
package com.helliongames.snifferplus.mixin;

import com.google.common.collect.ImmutableList;
import com.helliongames.snifferplus.access.ServerPlayerAccess;
import com.helliongames.snifferplus.access.SnifferAccess;
import com.helliongames.snifferplus.registration.SnifferPlusMemoryModules;
import com.helliongames.snifferplus.world.SnifferContainer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_39;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_5134;
import net.minecraft.class_5146;
import net.minecraft.class_52;
import net.minecraft.class_5630;
import net.minecraft.class_7248;
import net.minecraft.class_8153;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_8153.class})
public abstract class MixinSniffer
extends class_1309
implements SnifferAccess,
class_1265,
class_7248,
class_5146 {
    @Shadow
    @Final
    private static class_2940<Integer> field_42663;
    protected SnifferContainer inventory;
    private static final class_2940<Boolean> HAS_CHEST;
    private static final class_2940<Boolean> HAS_SCENT_ITEM;
    private static final class_2940<Boolean> IS_SADDLED;
    private static final List<class_4149<? extends class_4148<? super class_8153>>> SENSOR_TYPES;
    private static final List<class_4140<?>> MEMORY_TYPES;

    @Shadow
    protected abstract class_243 method_49137();

    @Shadow
    protected abstract class_2338 method_51508();

    @Shadow
    protected abstract class_8153.class_8154 method_49138();

    protected MixinSniffer(class_1299<? extends class_1309> $$0, class_1937 $$1) {
        super($$0, $$1);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void snifferplus_createDataAndInventoryOnCreation(class_1299 type, class_1937 level, CallbackInfo ci) {
        this.field_6011.method_12784(HAS_CHEST, (Object)false);
        this.field_6011.method_12784(HAS_SCENT_ITEM, (Object)false);
        this.field_6011.method_12784(IS_SADDLED, (Object)false);
        this.createInventory();
    }

    @Inject(method={"mobInteract"}, at={@At(value="RETURN")}, cancellable=true)
    private void snifferplus_addInteractions(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1799 itemStack = player.method_5998(hand);
        if (player.method_21823()) {
            this.method_6722(player);
            cir.setReturnValue((Object)class_1269.method_29236((boolean)this.method_37908().field_9236));
        } else if (!itemStack.method_7960()) {
            if (!this.hasChest() && itemStack.method_31574(class_1802.field_8106)) {
                this.equipChest(player, itemStack);
                cir.setReturnValue((Object)class_1269.method_29236((boolean)this.method_37908().field_9236));
            }
        } else if (!this.method_37908().field_9236) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804((class_1297)this);
        }
    }

    @Inject(method={"dropSeed"}, at={@At(value="HEAD")}, cancellable=true)
    private void snifferplus_putSeedsInInventory(CallbackInfo ci) {
        if (this.method_37908().method_8608() || (Integer)this.field_6011.method_12789(field_42663) != this.field_6012) {
            return;
        }
        if (this.hasChest()) {
            class_3218 serverLevel = (class_3218)this.method_37908();
            class_52 lootTable = serverLevel.method_8503().method_3857().getLootTable(class_39.field_44748);
            class_8567 lootParams = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)this.method_49137()).method_51874(class_181.field_1226, (Object)this).method_51875(class_173.field_16235);
            ObjectArrayList list = lootTable.method_51878(lootParams);
            class_2338 blockPos = this.method_51508();
            for (class_1799 itemStack : list) {
                class_1799 remainingStack = this.inventory.method_5491(itemStack);
                if (remainingStack.method_7960()) continue;
                class_1542 itemEntity = new class_1542((class_1937)serverLevel, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), remainingStack);
                itemEntity.method_6988();
                serverLevel.method_8649((class_1297)itemEntity);
            }
            this.method_5783(class_3417.field_42600, 1.0f, 1.0f);
            ci.cancel();
        }
    }

    @Inject(method={"brainProvider"}, at={@At(value="HEAD")}, cancellable=true)
    private void snifferplus_replaceBrainProvider(CallbackInfoReturnable<class_4095.class_5303<class_8153>> cir) {
        cir.setReturnValue((Object)class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES));
    }

    @Inject(method={"getPassengersRidingOffset"}, at={@At(value="HEAD")}, cancellable=true)
    private void snifferplus_getRidingOffsetDigging(CallbackInfoReturnable<Double> cir) {
        if (this.method_49138().equals((Object)class_8153.class_8154.field_42670)) {
            cir.setReturnValue((Object)1.3);
        }
    }

    protected boolean method_6062() {
        return super.method_6062() || this.method_5782() && this.method_6725() && !this.hasScentItem();
    }

    @Nullable
    public class_1309 method_5642() {
        if (this.hasScentItem()) {
            return null;
        }
        class_1297 firstPassenger = this.method_31483();
        if (firstPassenger instanceof class_1308) {
            return (class_1308)firstPassenger;
        }
        if (this.method_6725() && firstPassenger instanceof class_1657) {
            return (class_1657)firstPassenger;
        }
        return null;
    }

    protected void method_49481(class_1657 $$0, class_243 $$1) {
        super.method_49481($$0, $$1);
        if (!this.hasScentItem()) {
            class_241 $$2 = this.getRiddenRotation((class_1309)$$0);
            this.method_5710($$2.field_1342, $$2.field_1343);
            this.field_6283 = this.field_6241 = this.method_36454();
            this.field_5982 = this.field_6241;
        }
    }

    protected class_241 getRiddenRotation(class_1309 rider) {
        return new class_241(rider.method_36455() * 0.5f, rider.method_36454());
    }

    protected class_243 method_49482(class_1657 player, class_243 movement) {
        if (!this.hasScentItem()) {
            float xAccel = player.field_6212 * 0.5f;
            float zAccel = player.field_6250;
            if (zAccel <= 0.0f) {
                zAccel *= 0.25f;
            }
            float yAccel = this.method_5799() ? 0.5f : 0.0f;
            return new class_243((double)xAccel, (double)yAccel, (double)zAccel);
        }
        return movement;
    }

    protected float method_49485(class_1657 player) {
        if (this.hasScentItem()) {
            return (float)this.method_26825(class_5134.field_23719);
        }
        float speedFactor = this.method_5799() ? 0.75f : 0.5f;
        return (float)this.method_26825(class_5134.field_23719) * speedFactor;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (!this.inventory.method_5438(0).method_7960()) {
            tag.method_10566("SaddleItem", (class_2520)this.inventory.method_5438(0).method_7953(new class_2487()));
        }
        if (!this.inventory.method_5438(1).method_7960()) {
            tag.method_10566("ScentItem", (class_2520)this.inventory.method_5438(1).method_7953(new class_2487()));
        }
        tag.method_10556("Chested", this.hasChest());
        if (this.hasChest()) {
            class_2499 $$1 = new class_2499();
            for (int $$2 = 2; $$2 < this.inventory.method_5439(); ++$$2) {
                class_1799 $$3 = this.inventory.method_5438($$2);
                if ($$3.method_7960()) continue;
                class_2487 $$4 = new class_2487();
                $$4.method_10567("Slot", (byte)$$2);
                $$3.method_7953($$4);
                $$1.add((Object)$$4);
            }
            tag.method_10566("Items", (class_2520)$$1);
        }
    }

    public void method_5749(class_2487 tag) {
        class_1799 $$4;
        super.method_5749(tag);
        if (tag.method_10573("SaddleItem", 10) && ($$4 = class_1799.method_7915((class_2487)tag.method_10562("SaddleItem"))).method_31574(class_1802.field_8175)) {
            this.inventory.method_5447(0, $$4);
        }
        if (tag.method_10573("ScentItem", 10)) {
            class_1799 scentItem = class_1799.method_7915((class_2487)tag.method_10562("ScentItem"));
            this.inventory.method_5447(1, scentItem);
        }
        this.setChest(tag.method_10577("Chested"));
        this.createInventory();
        if (this.hasChest()) {
            class_2499 $$1 = tag.method_10554("Items", 10);
            for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
                class_2487 $$3 = $$1.method_10602($$2);
                int $$42 = $$3.method_10571("Slot") & 0xFF;
                if ($$42 < 2 || $$42 >= this.inventory.method_5439()) continue;
                this.inventory.method_5447($$42, class_1799.method_7915((class_2487)$$3));
            }
        }
        this.updateContainerEquipment();
    }

    public void method_6722(class_1657 player) {
        if (!(this.method_37908().field_9236 || this.method_5782() && !this.method_5626((class_1297)player))) {
            ((ServerPlayerAccess)player).openSnifferInventory((class_8153)this, (class_1263)this.inventory);
        }
    }

    public class_5630 method_32318(int $$0) {
        if ($$0 == 499) {
            return new class_5630(){

                public class_1799 method_32327() {
                    return MixinSniffer.this.hasChest() ? new class_1799((class_1935)class_1802.field_8106) : class_1799.field_8037;
                }

                public boolean method_32332(class_1799 $$0) {
                    if ($$0.method_7960()) {
                        if (MixinSniffer.this.hasChest()) {
                            MixinSniffer.this.setChest(false);
                            MixinSniffer.this.createInventory();
                        }
                        return true;
                    }
                    if ($$0.method_31574(class_1802.field_8106)) {
                        if (!MixinSniffer.this.hasChest()) {
                            MixinSniffer.this.setChest(true);
                            MixinSniffer.this.createInventory();
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
        int $$1 = $$0 - 400;
        if ($$1 >= 0 && $$1 < 2 && $$1 < this.inventory.method_5439()) {
            if ($$1 == 0) {
                return this.createEquipmentSlotAccess($$1, $$0x -> $$0x.method_7960() || $$0x.method_31574(class_1802.field_8175));
            }
            return class_5630.field_27860;
        }
        int $$2 = $$0 - 500 + 2;
        return $$2 >= 2 && $$2 < this.inventory.method_5439() ? class_5630.method_32328((class_1263)this.inventory, (int)$$2) : super.method_32318($$0);
    }

    private class_5630 createEquipmentSlotAccess(final int $$0, final Predicate<class_1799> $$1) {
        return new class_5630(){

            public class_1799 method_32327() {
                return MixinSniffer.this.inventory.method_5438($$0);
            }

            public boolean method_32332(class_1799 $$0x) {
                if (!$$1.test($$0x)) {
                    return false;
                }
                MixinSniffer.this.inventory.method_5447($$0, $$0x);
                MixinSniffer.this.updateContainerEquipment();
                return true;
            }
        };
    }

    protected void method_16078() {
        super.method_16078();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_1799 stack = this.inventory.method_5438(i);
                if (stack.method_7960() || class_1890.method_8221((class_1799)stack)) continue;
                this.method_5775(stack);
            }
        }
        if (this.hasChest()) {
            if (!this.method_37908().field_9236) {
                this.method_5706((class_1935)class_2246.field_10034);
            }
            this.setChest(false);
        }
    }

    @Override
    public boolean hasChest() {
        return (Boolean)this.field_6011.method_12789(HAS_CHEST);
    }

    private void setChest(boolean hasChest) {
        this.field_6011.method_12778(HAS_CHEST, (Object)hasChest);
    }

    @Override
    public boolean hasScentItem() {
        return (Boolean)this.field_6011.method_12789(HAS_SCENT_ITEM);
    }

    private void setScentItem(boolean hasScentItem) {
        this.field_6011.method_12778(HAS_SCENT_ITEM, (Object)hasScentItem);
    }

    public boolean method_6725() {
        return (Boolean)this.field_6011.method_12789(IS_SADDLED);
    }

    public boolean method_6765() {
        return this.method_5805() && !this.method_6109();
    }

    protected void updateContainerEquipment() {
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(IS_SADDLED, (Object)(!this.inventory.method_5438(0).method_7960() ? 1 : 0));
            this.setScentItem(!this.inventory.method_5438(1).method_7960());
        }
    }

    public void method_5453(class_1263 var1) {
        boolean saddled = this.method_6725();
        this.updateContainerEquipment();
        if (this.field_6012 > 20 && !saddled && this.method_6725()) {
            this.method_5783(class_3417.field_14704, 0.5f, 1.0f);
        }
    }

    @Override
    public boolean hasInventoryChanged(class_1263 container) {
        return this.inventory != container;
    }

    private void equipChest(class_1657 player, class_1799 itemStack) {
        this.setChest(true);
        this.playChestEquipsSound();
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        this.createInventory();
    }

    public void method_6576(@Nullable class_3419 source) {
        this.inventory.method_5447(0, new class_1799((class_1935)class_1802.field_8175));
    }

    protected void playChestEquipsSound() {
        this.method_5783(class_3417.field_14598, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
    }

    protected int getInventorySize() {
        return this.hasChest() ? 38 : 2;
    }

    @Override
    public int getInventoryColumns() {
        return 9;
    }

    protected void createInventory() {
        SnifferContainer snifferContainer = this.inventory;
        this.inventory = new SnifferContainer(this.getInventorySize());
        if (snifferContainer != null) {
            snifferContainer.method_5488(this);
            int i = Math.min(snifferContainer.method_5439(), this.inventory.method_5439());
            for (int j = 0; j < i; ++j) {
                class_1799 itemStack = snifferContainer.method_5438(j);
                if (itemStack.method_7960()) continue;
                this.inventory.method_5447(j, itemStack.method_7972());
            }
        }
        this.inventory.method_5489(this);
        this.updateContainerEquipment();
    }

    static {
        HAS_CHEST = class_2945.method_12791(class_8153.class, (class_2941)class_2943.field_13323);
        HAS_SCENT_ITEM = class_2945.method_12791(class_8153.class, (class_2941)class_2943.field_13323);
        IS_SADDLED = class_2945.method_12791(class_8153.class, (class_2941)class_2943.field_13323);
        SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, (Object)class_4149.field_18467, (Object)class_4149.field_44475);
        MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18445, SnifferPlusMemoryModules.OUTPOST_LOCATION.get(), (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_39408, (Object)class_4140.field_42638, (Object)class_4140.field_42639, (Object)class_4140.field_42640, (Object)class_4140.field_38105, (Object)class_4140.field_42637, (Object)class_4140.field_18442, (Object[])new class_4140[]{class_4140.field_18448, class_4140.field_28325, class_4140.field_28326, class_4140.field_28327});
    }
}

