/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3966;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.core.GameContext;
import nx.pingwheel.common.math.Raycast;
import nx.pingwheel.common.network.PingLocationC2SPacket;
import nx.pingwheel.common.platform.IPlatformNetworkService;

public class PingController {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();
    private static boolean pingQueued = false;
    private static int pingSequence = 0;
    private static int lastPing = 0;

    private PingController() {
    }

    public static void revokePingAction() {
        pingQueued = false;
    }

    public static void queuePingAction() {
        pingQueued = true;
    }

    public static void pollPingAction(float tickDelta) {
        if (!pingQueued || CommonClient.Game.field_1687 == null) {
            return;
        }
        int time = (int)CommonClient.Game.field_1687.method_8510();
        if (CLIENT_CONFIG.getCorrectionPeriod() < 5.0f && (float)(time - lastPing) > CLIENT_CONFIG.getCorrectionPeriod() * 20.0f) {
            ++pingSequence;
        }
        lastPing = time;
        pingQueued = false;
        PingController.performPingAction(tickDelta);
    }

    private static void performPingAction(float tickDelta) {
        class_1297 cameraEntity = CommonClient.Game.field_1719;
        if (cameraEntity == null || CommonClient.Game.field_1687 == null) {
            return;
        }
        class_243 cameraDirection = cameraEntity.method_5828(tickDelta);
        class_239 hitResult = Raycast.traceDirectional(cameraDirection, tickDelta, Math.min(CLIENT_CONFIG.getRaycastDistance(), CLIENT_CONFIG.getPingDistance()), cameraEntity.method_18276());
        if (hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333) {
            if (CommonClient.DistantHorizonsLoaded) {
                Raycast.traceDistantAsync(cameraDirection, tickDelta, distantHitResult -> IPlatformNetworkService.INSTANCE.sendToServer(new PingLocationC2SPacket(CLIENT_CONFIG.getChannel(), distantHitResult.method_17784(), null, pingSequence, GameContext.getDimension())));
            }
            return;
        }
        UUID uuid = null;
        if (hitResult.method_17783() == class_239.class_240.field_1331) {
            uuid = ((class_3966)hitResult).method_17782().method_5667();
        }
        IPlatformNetworkService.INSTANCE.sendToServer(new PingLocationC2SPacket(CLIENT_CONFIG.getChannel(), hitResult.method_17784(), uuid, pingSequence, GameContext.getDimension()));
    }

    public static boolean isPingQueued() {
        return pingQueued;
    }
}

