/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.resources;

import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.Note;
import immersive_melodies.resources.Track;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_2540;

public class Melody
extends MelodyDescriptor {
    static final Melody DEFAULT = new Melody();
    private final List<Track> tracks = new LinkedList<Track>();

    public Melody() {
        super("unknown");
        this.addTrack(new Track("unknown", new LinkedList<Note>()));
    }

    public Melody(String name) {
        super(name);
    }

    public Melody(class_2540 b) {
        super(b);
        int trackCount = b.readInt();
        for (int i = 0; i < trackCount; ++i) {
            this.tracks.add(new Track(b));
        }
    }

    public List<Track> getTracks() {
        return Collections.unmodifiableList(this.tracks);
    }

    public int getLength() {
        int length = 0;
        for (Track track : this.tracks) {
            length = Math.max(length, track.getLength());
        }
        return length;
    }

    public void addTrack(Track track) {
        this.tracks.add(track);
    }

    public void encode(class_2540 b) {
        super.encodeLite(b);
        b.writeInt(this.tracks.size());
        for (Track note : this.tracks) {
            note.encode(b);
        }
    }

    public void trim() {
        int offset = this.getFirstNoteTime();
        for (Track track : this.tracks) {
            LinkedList<Note> newNotes = new LinkedList<Note>();
            for (Note note : track.getNotes()) {
                newNotes.add(new Note(note.getNote(), note.getVelocity(), note.getTime() - offset, note.getLength(), note.getSustain()));
            }
            track.setNotes(newNotes);
        }
    }

    private int getFirstNoteTime() {
        int earliestNote = Integer.MAX_VALUE;
        for (Track track : this.tracks) {
            List<Note> notes = track.getNotes();
            if (notes.isEmpty()) continue;
            earliestNote = Math.min(earliestNote, notes.get(0).getTime());
        }
        return earliestNote;
    }
}

