/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.registry.fluid;

import earth.terrarium.botarium.common.registry.fluid.FluidInformation;
import earth.terrarium.botarium.common.registry.fluid.FluidSounds;
import net.minecraft.class_1814;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7;

public record FluidProperties(class_2960 id, double motionScale, boolean canPushEntity, boolean canSwim, boolean canDrown, float fallDistanceModifier, boolean canExtinguish, boolean canConvertToSource, boolean supportsBloating, class_7 pathType, class_7 adjacentPathType, boolean canHydrate, int lightLevel, int density, int temperature, int viscosity, class_1814 rarity, FluidSounds sounds, class_2960 still, class_2960 flowing, class_2960 overlay, class_2960 screenOverlay, int tintColor, int tickDelay, int slopeFindDistance, int dropOff, float explosionResistance, boolean canPlace) implements FluidInformation
{
    @Override
    public FluidProperties toProperties() {
        return this;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private double motionScale = 0.014;
        private boolean canPushEntity = true;
        private boolean canSwim = false;
        private boolean canDrown = true;
        private float fallDistanceModifier = 0.5f;
        private boolean canExtinguish = false;
        private boolean canConvertToSource = true;
        private boolean supportsBloating = false;
        private class_7 pathType = class_7.field_18;
        private class_7 adjacentPathType = class_7.field_4;
        private boolean canHydrate = true;
        private int lightLevel = 0;
        private int density = 1000;
        private int temperature = 300;
        private int viscosity = 1000;
        private class_1814 rarity = class_1814.field_8906;
        private final FluidSounds sounds = new FluidSounds();
        private class_2960 still;
        private class_2960 flowing;
        private class_2960 overlay;
        private class_2960 screenOverlay;
        private int tintColor = -1;
        private int tickRate = 5;
        private int slopeFindDistance = 4;
        private int dropOff = 1;
        private float explosionResistance = 100.0f;
        private boolean canPlace = true;

        private Builder() {
        }

        public Builder motionScale(double motionScale) {
            this.motionScale = motionScale;
            return this;
        }

        public Builder canPushEntity(boolean canPushEntity) {
            this.canPushEntity = canPushEntity;
            return this;
        }

        public Builder canSwim(boolean canSwim) {
            this.canSwim = canSwim;
            return this;
        }

        public Builder canDrown(boolean canDrown) {
            this.canDrown = canDrown;
            return this;
        }

        public Builder fallDistanceModifier(float fallDistanceModifier) {
            this.fallDistanceModifier = fallDistanceModifier;
            return this;
        }

        public Builder canExtinguish(boolean canExtinguish) {
            this.canExtinguish = canExtinguish;
            return this;
        }

        public Builder canConvertToSource(boolean canConvertToSource) {
            this.canConvertToSource = canConvertToSource;
            return this;
        }

        public Builder supportsBloating(boolean supportsBloating) {
            this.supportsBloating = supportsBloating;
            return this;
        }

        public Builder pathType(class_7 pathType) {
            this.pathType = pathType;
            return this;
        }

        public Builder adjacentPathType(class_7 adjacentPathType) {
            this.adjacentPathType = adjacentPathType;
            return this;
        }

        public Builder canHydrate(boolean canHydrate) {
            this.canHydrate = canHydrate;
            return this;
        }

        public Builder lightLevel(int lightLevel) {
            this.lightLevel = lightLevel;
            return this;
        }

        public Builder density(int density) {
            this.density = density;
            return this;
        }

        public Builder temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder viscosity(int viscosity) {
            this.viscosity = viscosity;
            return this;
        }

        public Builder rarity(class_1814 rarity) {
            this.rarity = rarity;
            return this;
        }

        public Builder sounds(String sound, class_3414 soundEvent) {
            this.sounds.addSound(sound, soundEvent);
            return this;
        }

        public Builder still(class_2960 still) {
            this.still = still;
            return this;
        }

        public Builder flowing(class_2960 flowing) {
            this.flowing = flowing;
            return this;
        }

        public Builder overlay(class_2960 overlay) {
            this.overlay = overlay;
            return this;
        }

        public Builder screenOverlay(class_2960 screenOverlay) {
            this.screenOverlay = screenOverlay;
            return this;
        }

        public Builder tintColor(int tintColor) {
            this.tintColor = tintColor;
            return this;
        }

        public Builder tickRate(int tickRate) {
            this.tickRate = tickRate;
            return this;
        }

        public Builder slopeFindDistance(int slopeFindDistance) {
            this.slopeFindDistance = slopeFindDistance;
            return this;
        }

        public Builder dropOff(int dropOff) {
            this.dropOff = dropOff;
            return this;
        }

        public Builder explosionResistance(float explosionResistance) {
            this.explosionResistance = explosionResistance;
            return this;
        }

        public Builder disablePlacing() {
            this.canPlace = false;
            return this;
        }

        public FluidProperties build(class_2960 id) {
            return new FluidProperties(id, this.motionScale, this.canPushEntity, this.canSwim, this.canDrown, this.fallDistanceModifier, this.canExtinguish, this.canConvertToSource, this.supportsBloating, this.pathType, this.adjacentPathType, this.canHydrate, this.lightLevel, this.density, this.temperature, this.viscosity, this.rarity, this.sounds, this.still, this.flowing, this.overlay, this.screenOverlay, this.tintColor, this.tickRate, this.slopeFindDistance, this.dropOff, this.explosionResistance, this.canPlace);
        }
    }
}

