/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.sequenced;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeSerializer;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class SequencedAssemblyRecipe
implements class_1860<class_1263> {
    protected class_2960 id;
    protected SequencedAssemblyRecipeSerializer serializer;
    protected class_1856 ingredient;
    protected class_2371<class_1856> ingredientList;
    protected List<SequencedRecipe<?>> sequence;
    protected int loops;
    protected ProcessingOutput transitionalItem;
    public final List<ProcessingOutput> resultPool;

    public SequencedAssemblyRecipe(class_2960 recipeId, SequencedAssemblyRecipeSerializer serializer) {
        this.id = recipeId;
        this.serializer = serializer;
        this.sequence = new ArrayList();
        this.resultPool = new ArrayList<ProcessingOutput>();
        this.loops = 5;
    }

    public static <C extends class_1263, R extends ProcessingRecipe<C>> Optional<R> getRecipe(class_1937 world, C inv, class_3956<R> type, Class<R> recipeClass) {
        return SequencedAssemblyRecipe.getRecipe(world, inv, type, recipeClass, r -> r.method_8115(inv, world));
    }

    public static <C extends class_1263, R extends ProcessingRecipe<C>> Optional<R> getRecipe(class_1937 world, C inv, class_3956<R> type, Class<R> recipeClass, Predicate<? super R> recipeFilter) {
        return SequencedAssemblyRecipe.getRecipes(world, inv.method_5438(0), type, recipeClass).filter(recipeFilter).findFirst();
    }

    public static <R extends ProcessingRecipe<?>> Optional<R> getRecipe(class_1937 world, class_1799 item, class_3956<R> type, Class<R> recipeClass) {
        List all = world.method_8433().method_30027(AllRecipeTypes.SEQUENCED_ASSEMBLY.getType());
        for (SequencedAssemblyRecipe sequencedAssemblyRecipe : all) {
            SequencedRecipe<?> nextRecipe;
            ProcessingRecipe<?> recipe;
            if (!sequencedAssemblyRecipe.appliesTo(item) || (recipe = (nextRecipe = sequencedAssemblyRecipe.getNextRecipe(item)).getRecipe()).method_17716() != type || !recipeClass.isInstance(recipe)) continue;
            recipe.enforceNextResult(() -> sequencedAssemblyRecipe.advance(item));
            return Optional.of((ProcessingRecipe)recipeClass.cast(recipe));
        }
        return Optional.empty();
    }

    public static <R extends ProcessingRecipe<?>> Stream<R> getRecipes(class_1937 world, class_1799 item, class_3956<R> type, Class<R> recipeClass) {
        List all = world.method_8433().method_30027(AllRecipeTypes.SEQUENCED_ASSEMBLY.getType());
        return all.stream().filter(it -> it.appliesTo(item)).map(it -> Pair.of(it, it.getNextRecipe(item).getRecipe())).filter(it -> ((ProcessingRecipe)it.getSecond()).method_17716() == type && recipeClass.isInstance(it.getSecond())).map(it -> {
            ((ProcessingRecipe)it.getSecond()).enforceNextResult(() -> ((SequencedAssemblyRecipe)it.getFirst()).advance(item));
            return (ProcessingRecipe)it.getSecond();
        }).map(recipeClass::cast);
    }

    private class_1799 advance(class_1799 input) {
        int step = this.getStep(input);
        if ((step + 1) / this.sequence.size() >= this.loops) {
            return this.rollResult();
        }
        class_1799 advancedItem = ItemHandlerHelper.copyStackWithSize((class_1799)this.getTransitionalItem(), (int)1);
        class_2487 itemTag = advancedItem.method_7948();
        class_2487 tag = new class_2487();
        tag.method_10582("id", this.id.toString());
        tag.method_10569("Step", step + 1);
        tag.method_10548("Progress", ((float)step + 1.0f) / (float)(this.sequence.size() * this.loops));
        itemTag.method_10566("SequencedAssembly", (class_2520)tag);
        advancedItem.method_7980(itemTag);
        return advancedItem;
    }

    public int getLoops() {
        return this.loops;
    }

    public void addAdditionalIngredientsAndMachines(List<class_1856> list) {
        this.sequence.forEach(sr -> sr.getAsAssemblyRecipe().addAssemblyIngredients(list));
        HashSet machines = new HashSet();
        this.sequence.forEach(sr -> sr.getAsAssemblyRecipe().addRequiredMachines(machines));
        machines.stream().map(xva$0 -> class_1856.method_8091((class_1935[])new class_1935[]{xva$0})).forEach(list::add);
    }

    public void addAdditionalFluidIngredients(List<FluidIngredient> list) {
        this.sequence.forEach(sr -> sr.getAsAssemblyRecipe().addAssemblyFluidIngredients(list));
    }

    private class_1799 rollResult() {
        float totalWeight = 0.0f;
        for (ProcessingOutput entry : this.resultPool) {
            totalWeight += entry.getChance();
        }
        float number = Create.RANDOM.nextFloat() * totalWeight;
        for (ProcessingOutput entry : this.resultPool) {
            if (!((number -= entry.getChance()) < 0.0f)) continue;
            return entry.getStack().method_7972();
        }
        return class_1799.field_8037;
    }

    private boolean appliesTo(class_1799 input) {
        if (this.ingredient.method_8093(input)) {
            return true;
        }
        if (input.method_7985() && this.getTransitionalItem().method_7909() == input.method_7909() && input.method_7969().method_10545("SequencedAssembly")) {
            class_2487 tag = input.method_7969().method_10562("SequencedAssembly");
            String id = tag.method_10558("id");
            return id.equals(this.id.toString());
        }
        return false;
    }

    private SequencedRecipe<?> getNextRecipe(class_1799 input) {
        return this.sequence.get(this.getStep(input) % this.sequence.size());
    }

    private int getStep(class_1799 input) {
        if (!input.method_7985()) {
            return 0;
        }
        class_2487 tag = input.method_7969();
        if (!tag.method_10545("SequencedAssembly")) {
            return 0;
        }
        int step = tag.method_10562("SequencedAssembly").method_10550("Step");
        return step;
    }

    public boolean method_8115(class_1263 inv, class_1937 p_77569_2_) {
        return false;
    }

    public class_1799 method_8116(class_1263 inv, class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int p_194133_1_, int p_194133_2_) {
        return false;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.resultPool.get(0).getStack();
    }

    public float getOutputChance() {
        float totalWeight = 0.0f;
        for (ProcessingOutput entry : this.resultPool) {
            totalWeight += entry.getChance();
        }
        return this.resultPool.get(0).getChance() / totalWeight;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return this.serializer;
    }

    public boolean method_8118() {
        return true;
    }

    public class_3956<?> method_17716() {
        return AllRecipeTypes.SEQUENCED_ASSEMBLY.getType();
    }

    @Environment(value=EnvType.CLIENT)
    public static void addToTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (!stack.method_7985() || !stack.method_7969().method_10545("SequencedAssembly")) {
            return;
        }
        class_2487 compound = stack.method_7969().method_10562("SequencedAssembly");
        class_2960 resourceLocation = new class_2960(compound.method_10558("id"));
        Optional optionalRecipe = class_310.method_1551().field_1687.method_8433().method_8130(resourceLocation);
        if (!optionalRecipe.isPresent()) {
            return;
        }
        class_1860 recipe = (class_1860)optionalRecipe.get();
        if (!(recipe instanceof SequencedAssemblyRecipe)) {
            return;
        }
        SequencedAssemblyRecipe sequencedAssemblyRecipe = (SequencedAssemblyRecipe)recipe;
        int length = sequencedAssemblyRecipe.sequence.size();
        int step = sequencedAssemblyRecipe.getStep(stack);
        int total = length * sequencedAssemblyRecipe.loops;
        tooltip.add(Components.immutableEmpty());
        tooltip.add((class_2561)Lang.translateDirect("recipe.sequenced_assembly", new Object[0]).method_27692(class_124.field_1080));
        tooltip.add((class_2561)Lang.translateDirect("recipe.assembly.progress", step, total).method_27692(class_124.field_1063));
        int remaining = total - step;
        for (int i = 0; i < length && i < remaining; ++i) {
            SequencedRecipe<?> sequencedRecipe = sequencedAssemblyRecipe.sequence.get((i + step) % length);
            class_2561 textComponent = sequencedRecipe.getAsAssemblyRecipe().getDescriptionForAssembly();
            if (i == 0) {
                tooltip.add((class_2561)Lang.translateDirect("recipe.assembly.next", textComponent).method_27692(class_124.field_1075));
                continue;
            }
            tooltip.add((class_2561)Components.literal("-> ").method_10852(textComponent).method_27692(class_124.field_1062));
        }
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    public class_2371<class_1856> method_8117() {
        if (this.ingredientList == null) {
            this.ingredientList = class_2371.method_10211();
            this.ingredientList.add((Object)this.ingredient);
            for (SequencedRecipe<?> recipe : this.sequence) {
                this.ingredientList.addAll(recipe.getRecipe().method_8117());
            }
        }
        return this.ingredientList;
    }

    public List<SequencedRecipe<?>> getSequence() {
        return this.sequence;
    }

    public class_1799 getTransitionalItem() {
        return this.transitionalItem.getStack();
    }
}

