/*
 * Decompiled with CFR 0.152.
 */
package net.trique.mythicupgrades.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.trique.mythicupgrades.MythicUpgradesDamageTypes;
import net.trique.mythicupgrades.effect.MUEffects;
import net.trique.mythicupgrades.item.BaseMythicItem;
import net.trique.mythicupgrades.item.MythicEffectsArmorItem;
import net.trique.mythicupgrades.util.CommonFunctions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    private boolean has_damage_been_deflected = false;
    @Unique
    private float deflecting_damage = 0.0f;
    @Unique
    private BaseMythicItem lastUsed;
    @Unique
    private MythicEffectsArmorItem lastWorn = null;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract Map<class_1291, class_1293> method_6088();

    @Shadow
    @Nullable
    public abstract class_1293 method_6112(class_1291 var1);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void checkItemInHand(CallbackInfo ci) {
        class_1792 class_17922;
        if (!this.method_6118(class_1304.field_6173).method_7960() && (class_17922 = this.method_6118(class_1304.field_6173).method_7909()) instanceof BaseMythicItem) {
            BaseMythicItem item = (BaseMythicItem)class_17922;
            if (this.lastUsed != null && !item.equals(this.lastUsed)) {
                CommonFunctions.removeMythicInfiniteEffects((class_1309)this, this.lastUsed.getMainHandEffects());
            }
            if (CommonFunctions.checkStatusEffects((class_1309)this, item.getMainHandEffects())) {
                CommonFunctions.addStatusEffects((class_1309)this, item.getMainHandEffects());
            }
            this.lastUsed = item;
        } else if (this.lastUsed != null) {
            CommonFunctions.removeMythicInfiniteEffects((class_1309)this, this.lastUsed.getMainHandEffects());
            this.lastUsed = null;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void applyArmorEffectsForSelf(CallbackInfo ci) {
        class_1792 class_17922;
        class_1799 head = this.method_6118(class_1304.field_6169);
        if (!head.method_7960() && (class_17922 = head.method_7909()) instanceof MythicEffectsArmorItem) {
            MythicEffectsArmorItem item = (MythicEffectsArmorItem)class_17922;
            if (this.lastWorn != null && !CommonFunctions.hasCorrectArmorOn((class_1309)this, item.method_7686())) {
                CommonFunctions.removeMythicInfiniteEffects((class_1309)this, this.lastWorn.getEquipmentEffectsForSelf());
            }
            if (CommonFunctions.hasCorrectArmorOn((class_1309)this, item.method_7686()) && CommonFunctions.checkStatusEffects((class_1309)this, item.getEquipmentEffectsForSelf())) {
                CommonFunctions.addStatusEffects((class_1309)this, item.getEquipmentEffectsForSelf());
            }
            this.lastWorn = item;
        } else if (this.lastWorn != null) {
            CommonFunctions.removeMythicInfiniteEffects((class_1309)this, this.lastWorn.getEquipmentEffectsForSelf());
            this.lastWorn = null;
        }
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")})
    private void applyArmorEffectsForEnemy(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 attacker;
        boolean was_damaged = (Boolean)cir.getReturnValue();
        if (was_damaged && (attacker = source.method_5529()) instanceof class_1309) {
            MythicEffectsArmorItem item;
            class_1792 class_17922;
            class_1309 entity = (class_1309)attacker;
            class_1799 head = this.method_6118(class_1304.field_6169);
            if (!head.method_7960() && (class_17922 = head.method_7909()) instanceof MythicEffectsArmorItem && CommonFunctions.hasCorrectArmorOn((class_1309)this, (item = (MythicEffectsArmorItem)class_17922).method_7686())) {
                CommonFunctions.addStatusEffects(entity, item.getEquipmentEffectsForEnemies(), (class_1309)this);
            }
        }
    }

    @WrapMethod(method={"hurt"})
    private boolean reduceIncomingDamage(class_1282 source, float amount, Operation<Boolean> original) {
        class_1293 deflection;
        if (!this.method_37908().method_8608() && (deflection = this.method_6112(MUEffects.DAMAGE_DEFLECTION)) != null) {
            class_1297 attacker = source.method_5529();
            float defl_dmg_coef = (float)deflection.method_5578() / 10.0f;
            if (attacker != null) {
                this.deflecting_damage = (0.1f + defl_dmg_coef) * amount;
                amount *= 0.9f - defl_dmg_coef;
            }
        }
        return (Boolean)original.call(new Object[]{source, Float.valueOf(amount)});
    }

    @Inject(method={"hurt"}, at={@At(value="TAIL")})
    private void deflectDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 enemy;
        class_1297 attacker;
        class_1293 deflection;
        if (!this.method_37908().method_8608() && ((Boolean)cir.getReturnValue()).booleanValue() && (deflection = this.method_6112(MUEffects.DAMAGE_DEFLECTION)) != null && (attacker = source.method_5529()) instanceof class_1309 && (enemy = (class_1309)attacker).method_5858((class_1297)this) <= 9.0 && !this.has_damage_been_deflected) {
            class_1282 deflecting_source = MythicUpgradesDamageTypes.deflecting_damage(this);
            this.has_damage_been_deflected = true;
            enemy.method_5643(deflecting_source, this.deflecting_damage);
        }
        this.has_damage_been_deflected = false;
    }
}

