/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.anthonyhilyard.iceberg.events.RenderTooltipEvents;
import com.teamremastered.endrem.config.ERConfigHandler;
import com.teamremastered.endrem.registry.ERItems;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketsApi;
import dev.shadowsoffire.apotheosis.adventure.AdventureEvents;
import dev.shadowsoffire.apotheosis.compat.PatchouliCompat;
import dev.shadowsoffire.apotheosis.ench.enchantments.corrupted.LifeMendingEnchant;
import dev.shadowsoffire.apotheosis.potion.PotionModule;
import dev.shadowsoffire.apotheosis.potion.compat.PotionCharmTrinket;
import dev.shadowsoffire.apotheosis.util.events.ModifyComponents;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.spell_power.api.enchantment.EnchantmentRestriction;

public class ZenithModCompat {
    public static boolean TRINKETS_LOADED = ZenithModCompat.loaded("trinkets");
    public static boolean PATCHOULI_LOADED = ZenithModCompat.loaded("patchouli");
    public static final boolean EASY_MAGIC_LOADED = ZenithModCompat.loaded("easymagic");
    public static final boolean EASY_ANVILS_LOADED = ZenithModCompat.loaded("easyanvils");
    public static boolean SPELL_ENGINE_LOADED = ZenithModCompat.loaded("spell_engine");
    public static boolean END_REMASTERED_LOADED = ZenithModCompat.loaded("endrem");
    public static boolean ICEBERG_LOADED = ZenithModCompat.loaded("iceberg");

    public static boolean loaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static void patchouliCompat() {
        if (PATCHOULI_LOADED) {
            PatchouliCompat.registerPatchouli();
        }
    }

    public static class Ench {
        public static void easyMagicWarn(Consumer<class_2561> tooltip) {
            if (EASY_MAGIC_LOADED) {
                tooltip.accept((class_2561)class_2561.method_43471((String)"zenith.easy_magic").method_27692(class_124.field_1061));
            }
        }

        public static void easyAnvilsWarn(Consumer<class_2561> tooltip) {
            if (EASY_ANVILS_LOADED) {
                tooltip.accept((class_2561)class_2561.method_43471((String)"zenith.easy_anvils").method_27692(class_124.field_1061));
            }
        }

        public static boolean isProhibitedSpellEngine(class_1887 ench, class_1799 stack) {
            if (!SPELL_ENGINE_LOADED || stack.method_31574(class_1802.field_8529)) {
                return false;
            }
            return EnchantmentRestriction.isProhibited((class_1887)ench, (class_1799)stack);
        }

        public static boolean isPermittedSpellEngine(class_1887 ench, class_1799 stack) {
            if (!SPELL_ENGINE_LOADED) {
                return false;
            }
            if (stack.method_31574(class_1802.field_8529)) {
                return true;
            }
            return EnchantmentRestriction.isPermitted((class_1887)ench, (class_1799)stack);
        }

        public static void endRemasteredEnchHook(class_1657 player) {
            if (!END_REMASTERED_LOADED) {
                return;
            }
            int maxValue = 120;
            int randomNumber = player.method_6051().method_43048(maxValue);
            if (!player.method_37908().field_9236 && ERConfigHandler.IS_CRYPTIC_EYE_OBTAINABLE && randomNumber == maxValue - 1) {
                player.method_7270(new class_1799((class_1935)ERItems.CRYPTIC_EYE));
            }
        }

        public static float lifeMendTrinkets(class_1297 entity, float amount, LifeMendingEnchant ench) {
            if (TRINKETS_LOADED && entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                AtomicReference<Float> atomicAmount = new AtomicReference<Float>(Float.valueOf(amount));
                TrinketsApi.getTrinketComponent((class_1309)livingEntity).ifPresent(c -> c.forEach((slotReference, stack) -> atomicAmount.set(Float.valueOf(ench.lifeMend(((Float)atomicAmount.get()).floatValue(), (class_1799)stack)))));
                amount = atomicAmount.get().floatValue();
            }
            return amount;
        }
    }

    public static class Adventure {
        public static void spellEngineCast() {
            if (SPELL_ENGINE_LOADED) {
                AdventureEvents.onSpellCast();
            }
        }

        public static void icebergCompat() {
            if (ICEBERG_LOADED) {
                Iceberg.init();
            }
        }

        private static class Iceberg {
            private Iceberg() {
            }

            private static void init() {
                RenderTooltipEvents.GATHER.register((itemStack, screenWidth, screenHeight, tooltipElements, maxWidth, index) -> {
                    ModifyComponents.ModifyComponentsEvent event = new ModifyComponents.ModifyComponentsEvent(itemStack, screenWidth, screenHeight, tooltipElements, maxWidth);
                    ((ModifyComponents.ModifyComponentsCallback)ModifyComponents.MODIFY_COMPONENTS.invoker()).modifyComponents(event);
                    class_1269 result = event.isCanceled() ? class_1269.field_21466 : class_1269.field_5811;
                    return new RenderTooltipEvents.GatherResult(result, event.maxWidth, event.tooltipElements);
                });
            }
        }
    }

    public static class Potion {
        public static void registerTrinkets() {
            if (TRINKETS_LOADED) {
                Trinkets.reg();
            }
        }

        private static class Trinkets {
            private Trinkets() {
            }

            private static void reg() {
                TrinketsApi.registerTrinket((class_1792)PotionModule.POTION_CHARM, (Trinket)new PotionCharmTrinket());
            }
        }
    }
}

