/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.library;

import dev.shadowsoffire.apotheosis.ench.Ench;
import dev.shadowsoffire.apotheosis.ench.library.EnchLibraryContainer;
import dev.shadowsoffire.placebo.recipe.VanillaPacketDispatcher;
import io.github.fabricators_of_create.porting_lib.block.CustomDataPacketHandlingBlockEntity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2535;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public abstract class EnchLibraryTile
extends class_2586
implements CustomDataPacketHandlingBlockEntity {
    protected final Object2IntMap<class_1887> points = new Object2IntOpenHashMap();
    protected final Object2IntMap<class_1887> maxLevels = new Object2IntOpenHashMap();
    protected final Set<EnchLibraryContainer> activeContainers = new HashSet<EnchLibraryContainer>();
    protected final int maxLevel;
    protected final int maxPoints;
    public final SingleStackStorage storage = new SingleStackStorage(){

        protected class_1799 getStack() {
            return class_1799.field_8037;
        }

        protected void setStack(class_1799 stack) {
            EnchLibraryTile.this.depositBook(stack);
            stack.method_7939(stack.method_7947() - 1);
        }

        protected boolean canInsert(ItemVariant itemVariant) {
            return itemVariant.isOf((Object)class_1802.field_8598);
        }

        protected boolean canExtract(ItemVariant itemVariant) {
            return false;
        }

        protected void onFinalCommit() {
            EnchLibraryTile.this.method_5431();
            super.onFinalCommit();
        }
    };

    public EnchLibraryTile(class_2591<?> type, class_2338 pos, class_2680 state, int maxLevel) {
        super(type, pos, state);
        this.maxLevel = maxLevel;
        this.maxPoints = EnchLibraryTile.levelToPoints(maxLevel);
    }

    public void depositBook(class_1799 book) {
        if (book.method_7909() != class_1802.field_8598) {
            return;
        }
        Map enchs = class_1890.method_8222((class_1799)book);
        for (Map.Entry e : enchs.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            int newPoints = Math.min(this.maxPoints, this.points.getInt(e.getKey()) + EnchLibraryTile.levelToPoints((Integer)e.getValue()));
            if (newPoints < 0) {
                newPoints = this.maxPoints;
            }
            this.points.put((Object)((class_1887)e.getKey()), newPoints);
            this.maxLevels.put((Object)((class_1887)e.getKey()), Math.min(this.maxLevel, Math.max(this.maxLevels.getInt(e.getKey()), (Integer)e.getValue())));
        }
        if (enchs.size() > 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((class_2586)this);
        }
        this.method_5431();
    }

    public void extractEnchant(class_1799 stack, class_1887 ench, int level) {
        int curLvl = class_1890.method_8222((class_1799)stack).getOrDefault(ench, 0);
        if (stack.method_7960() || !this.canExtract(ench, level, curLvl) || level == curLvl) {
            return;
        }
        Map enchs = class_1890.method_8222((class_1799)stack);
        enchs.put(ench, level);
        class_1890.method_8214((Map)enchs, (class_1799)stack);
        this.points.put((Object)ench, Math.max(0, this.points.getInt((Object)ench) - EnchLibraryTile.levelToPoints(level) + EnchLibraryTile.levelToPoints(curLvl)));
        if (!this.field_11863.method_8608()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((class_2586)this);
        }
        this.method_5431();
    }

    public boolean canExtract(class_1887 ench, int level, int currentLevel) {
        return this.maxLevels.getInt((Object)ench) >= level && this.points.getInt((Object)ench) >= EnchLibraryTile.levelToPoints(level) - EnchLibraryTile.levelToPoints(currentLevel);
    }

    public static int levelToPoints(int level) {
        return (int)Math.pow(2.0, level - 1);
    }

    public void method_11007(class_2487 tag) {
        class_2487 points = new class_2487();
        for (Object2IntMap.Entry e : this.points.object2IntEntrySet()) {
            points.method_10569(class_7923.field_41176.method_10221((Object)((class_1887)e.getKey())).toString(), e.getIntValue());
        }
        tag.method_10566("Points", (class_2520)points);
        class_2487 levels = new class_2487();
        for (Object2IntMap.Entry e : this.maxLevels.object2IntEntrySet()) {
            levels.method_10569(class_7923.field_41176.method_10221((Object)((class_1887)e.getKey())).toString(), e.getIntValue());
        }
        tag.method_10566("Levels", (class_2520)levels);
        super.method_11007(tag);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_2487 points = tag.method_10562("Points");
        for (String s : points.method_10541()) {
            class_1887 ench = (class_1887)class_7923.field_41176.method_10223(new class_2960(s));
            if (ench == null) continue;
            this.points.put((Object)ench, points.method_10550(s));
        }
        class_2487 levels = tag.method_10562("Levels");
        for (String s : levels.method_10541()) {
            class_1887 ench = (class_1887)class_7923.field_41176.method_10223(new class_2960(s));
            if (ench == null) continue;
            this.maxLevels.put((Object)ench, levels.method_10550(s));
        }
    }

    public void onDataPacket(class_2535 net, class_2622 pkt) {
        class_2487 tag = pkt.method_11290();
        class_2487 points = tag.method_10562("Points");
        for (String s : points.method_10541()) {
            class_1887 ench = (class_1887)class_7923.field_41176.method_10223(new class_2960(s));
            if (ench == null) continue;
            this.points.put((Object)ench, points.method_10550(s));
        }
        class_2487 levels = tag.method_10562("Levels");
        for (String s : levels.method_10541()) {
            class_1887 ench = (class_1887)class_7923.field_41176.method_10223(new class_2960(s));
            if (ench == null) continue;
            this.maxLevels.put((Object)ench, levels.method_10550(s));
        }
        this.activeContainers.forEach(EnchLibraryContainer::onChanged);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        class_2487 points = new class_2487();
        for (Object2IntMap.Entry e : this.points.object2IntEntrySet()) {
            points.method_10569(class_7923.field_41176.method_10221((Object)((class_1887)e.getKey())).toString(), e.getIntValue());
        }
        tag.method_10566("Points", (class_2520)points);
        class_2487 levels = new class_2487();
        for (Object2IntMap.Entry e : this.maxLevels.object2IntEntrySet()) {
            levels.method_10569(class_7923.field_41176.method_10221((Object)((class_1887)e.getKey())).toString(), e.getIntValue());
        }
        tag.method_10566("Levels", (class_2520)levels);
        return tag;
    }

    public Object2IntMap<class_1887> getPointsMap() {
        return this.points;
    }

    public Object2IntMap<class_1887> getLevelsMap() {
        return this.maxLevels;
    }

    public void addListener(EnchLibraryContainer ctr) {
        this.activeContainers.add(ctr);
    }

    public void removeListener(EnchLibraryContainer ctr) {
        this.activeContainers.remove((Object)ctr);
    }

    public int getMax(class_1887 ench) {
        return Math.min(this.maxLevel, this.maxLevels.getInt((Object)ench));
    }

    public static class EnderLibraryTile
    extends EnchLibraryTile {
        public EnderLibraryTile(class_2338 pos, class_2680 state) {
            super(Ench.Tiles.ENDER_LIBRARY, pos, state, 31);
        }
    }

    public static class BasicLibraryTile
    extends EnchLibraryTile {
        public BasicLibraryTile(class_2338 pos, class_2680 state) {
            super(Ench.Tiles.LIBRARY, pos, state, 16);
        }
    }
}

