/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.library;

import com.google.common.base.Strings;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureContainerScreen;
import dev.shadowsoffire.apotheosis.ench.library.EnchLibraryContainer;
import dev.shadowsoffire.apotheosis.ench.library.EnchLibraryTile;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.placebo.packets.ButtonClickMessage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import net.spell_power.api.enchantment.EnchantmentRestriction;
import org.jetbrains.annotations.Nullable;

public class EnchLibraryScreen
extends AdventureContainerScreen<EnchLibraryContainer> {
    public static final class_2960 TEXTURES = new class_2960("zenith", "textures/gui/library.png");
    public static final int MAX_ENTRIES = 5;
    public static final int ENTRY_WIDTH = 113;
    public static final int ENTRY_HEIGHT = 20;
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    protected List<LibrarySlot> data = new ArrayList<LibrarySlot>();
    protected class_342 filter = null;
    private static DecimalFormat f = new DecimalFormat("##.#");

    public EnchLibraryScreen(EnchLibraryContainer container, class_1661 inv, class_2561 title) {
        super(container, inv, title);
        this.field_2779 = 230;
        container.setNotifier(this::containerChanged);
    }

    protected void method_25426() {
        super.method_25426();
        this.filter = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_2776 + 16, this.field_2800 + 16, 110, 11, this.filter, (class_2561)class_2561.method_43470((String)"")));
        this.filter.method_1858(false);
        this.filter.method_1868(9924943);
        this.filter.method_1863(t -> this.containerChanged());
        this.method_25395((class_364)this.filter);
        this.containerChanged();
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.field_22787.field_1690.field_1822.method_1417(pKeyCode, pScanCode) && this.method_25399() == this.filter) {
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public void method_25394(class_332 gfx, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(gfx);
        super.method_25394(gfx, mouseX, mouseY, partialTicks);
        this.method_2380(gfx, mouseX, mouseY);
    }

    protected void method_2380(class_332 gfx, int mouseX, int mouseY) {
        super.method_2380(gfx, mouseX, mouseY);
        LibrarySlot libSlot = this.getHoveredSlot(mouseX, mouseY);
        if (libSlot != null) {
            int targetLevel;
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            class_5250 name = class_2561.method_43471((String)libSlot.ench.method_8184()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFFF80)).method_30938(Boolean.valueOf(true)));
            if (AttributesLib.getTooltipFlag().method_8035()) {
                name = name.method_10852((class_2561)class_2561.method_43470((String)(" [" + class_7923.field_41176.method_10221((Object)libSlot.ench) + "]")).method_27696(class_2583.field_24360.method_10977(class_124.field_1080).method_30938(Boolean.valueOf(false))));
            }
            list.add(name);
            if (class_1074.method_4663((String)(libSlot.ench.method_8184() + ".desc")) || AttributesLib.getTooltipFlag().method_8035()) {
                class_5250 txt = class_2561.method_43471((String)(libSlot.ench.method_8184() + ".desc")).method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)));
                list.addAll(this.field_22793.method_27527().method_27495((class_5348)txt, this.field_2776 - 16, txt.method_10866()));
                list.add(class_2561.method_43470((String)""));
            }
            list.add(class_2561.method_43469((String)"tooltip.enchlib.max_lvl", (Object[])new Object[]{class_2561.method_43471((String)("enchantment.level." + libSlot.maxLvl))}).method_27692(class_124.field_1080));
            list.add(class_2561.method_43469((String)"tooltip.enchlib.points", (Object[])new Object[]{EnchLibraryScreen.format(libSlot.points), EnchLibraryScreen.format(((EnchLibraryContainer)this.field_2797).getPointCap())}).method_27692(class_124.field_1080));
            list.add(class_2561.method_43470((String)""));
            class_1799 outSlot = ((EnchLibraryContainer)this.field_2797).ioInv.method_5438(1);
            int current = class_1890.method_8222((class_1799)outSlot).getOrDefault(libSlot.ench, 0);
            boolean shift = class_437.method_25442();
            int n = targetLevel = shift ? Math.min(libSlot.maxLvl, 1 + (int)(Math.log(libSlot.points + EnchLibraryTile.levelToPoints(current)) / Math.log(2.0))) : current + 1;
            if (targetLevel == current) {
                ++targetLevel;
            }
            int cost = EnchLibraryTile.levelToPoints(targetLevel) - EnchLibraryTile.levelToPoints(current);
            if (targetLevel > libSlot.maxLvl) {
                list.add(class_2561.method_43471((String)"tooltip.enchlib.unavailable").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            } else {
                list.add(class_2561.method_43469((String)"tooltip.enchlib.extracting", (Object[])new Object[]{class_2561.method_43471((String)("enchantment.level." + targetLevel))}).method_27692(class_124.field_1078));
                list.add(class_2561.method_43469((String)"tooltip.enchlib.cost", (Object[])new Object[]{cost}).method_27692(cost > libSlot.points ? class_124.field_1061 : class_124.field_1065));
            }
            gfx.method_51434(this.field_22793, list.stream().map(formatted -> class_2561.method_43470((String)formatted.getString())).toList(), this.field_2776 - 16 - list.stream().map(arg_0 -> ((class_327)this.field_22793).method_27525(arg_0)).max(Integer::compare).get(), mouseY);
        }
    }

    protected void method_2389(class_332 gfx, float partial, int mouseX, int mouseY) {
        int left = this.field_2776;
        int top = this.field_2800;
        gfx.method_25290(TEXTURES, left, top, 0.0f, 0.0f, this.field_2792, this.field_2779, 307, 256);
        int scrollbarPos = (int)(90.0f * this.scrollOffs);
        gfx.method_25290(TEXTURES, left + 13, top + 29 + scrollbarPos, 303.0f, (float)(40 + (this.isScrollBarActive() ? 0 : 12)), 4, 12, 307, 256);
        for (int idx = this.startIndex; idx < this.startIndex + 5 && idx < this.data.size(); ++idx) {
            this.renderEntry(gfx, this.data.get(idx), this.field_2776 + 20, this.field_2800 + 30 + 20 * (idx - this.startIndex), mouseX, mouseY);
        }
    }

    private void renderEntry(class_332 gfx, LibrarySlot data, int x, int y, int mouseX, int mouseY) {
        LibrarySlot hover = this.getHoveredSlot(mouseX, mouseY);
        gfx.method_25290(TEXTURES, x, y, 194.0f, data == hover ? 20.0f : 0.0f, 113, 20, 307, 256);
        int progress = (int)Math.round(85.0 * Math.sqrt(data.points) / (double)((float)Math.sqrt(((EnchLibraryContainer)this.field_2797).getPointCap())));
        gfx.method_25290(TEXTURES, x + 3, y + 14, 197.0f, 42.0f, progress, 3, 307, 256);
        class_4587 stack = gfx.method_51448();
        stack.method_22903();
        class_5250 txt = class_2561.method_43471((String)data.ench.method_8184());
        float scale = 1.0f;
        if (this.field_22793.method_27525((class_5348)txt) > 107) {
            scale = 60.0f / (float)this.field_22793.method_27525((class_5348)txt);
        }
        stack.method_22905(scale, scale, 1.0f);
        gfx.method_51439(this.field_22793, (class_2561)txt, (int)((float)(x + 3) / scale), (int)((float)(y + 3) / scale), 9363789, false);
        stack.method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.method_2378(14, 29, 4, 103, mouseX, mouseY)) {
            this.scrolling = true;
            this.method_25403(mouseX, mouseY, button, 0.0, 0.0);
            return true;
        }
        LibrarySlot libSlot = this.getHoveredSlot((int)mouseX, (int)mouseY);
        if (libSlot != null) {
            int id = class_7923.field_41176.method_10206((Object)libSlot.ench);
            if (class_437.method_25442()) {
                id |= Integer.MIN_VALUE;
            }
            ((EnchLibraryContainer)this.field_2797).onButtonClick(id);
            ButtonClickMessage.sendToServer((int)id);
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
            return true;
        }
        if (this.filter.method_49606() && button == 1) {
            this.filter.method_1852("");
            return true;
        }
        this.method_25395(null);
        this.filter.method_25365(false);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int barTop = this.field_2800 + 14;
            int barBot = barTop + 103;
            this.scrollOffs = ((float)pMouseY - (float)barTop - 6.0f) / ((float)(barBot - barTop) - 12.0f) - 0.12f;
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)i);
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.data.size() > 5;
    }

    protected int getOffscreenRows() {
        return this.data.size() - 5;
    }

    private void containerChanged() {
        this.data.clear();
        List<Object2IntMap.Entry<class_1887>> entries = this.filter(((EnchLibraryContainer)this.field_2797).getPointsForDisplay());
        for (Object2IntMap.Entry<class_1887> e : entries) {
            this.data.add(new LibrarySlot((class_1887)e.getKey(), e.getIntValue(), ((EnchLibraryContainer)this.field_2797).getMaxLevel((class_1887)e.getKey())));
        }
        if (!this.isScrollBarActive()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        Collections.sort(this.data, (a, b) -> class_1074.method_4662((String)a.ench.method_8184(), (Object[])new Object[0]).compareTo(class_1074.method_4662((String)b.ench.method_8184(), (Object[])new Object[0])));
    }

    private List<Object2IntMap.Entry<class_1887>> filter(List<Object2IntMap.Entry<class_1887>> list) {
        return list.stream().filter(this::isAllowedByItem).filter(this::isAllowedBySearch).toList();
    }

    private boolean isAllowedByItem(Object2IntMap.Entry<class_1887> e) {
        class_1799 stack = ((EnchLibraryContainer)this.field_2797).ioInv.method_5438(2);
        if (!stack.method_7960() && FabricLoader.getInstance().isModLoaded("spell_power")) {
            if (EnchantmentRestriction.isPermitted((class_1887)((class_1887)e.getKey()), (class_1799)stack)) {
                return true;
            }
            if (EnchantmentRestriction.isProhibited((class_1887)((class_1887)e.getKey()), (class_1799)stack)) {
                return false;
            }
        }
        return stack.method_7960() || ((class_1887)e.getKey()).method_8192(stack);
    }

    private boolean isAllowedBySearch(Object2IntMap.Entry<class_1887> e) {
        String name = class_1074.method_4662((String)((class_1887)e.getKey()).method_8184(), (Object[])new Object[0]).toLowerCase(Locale.ROOT);
        String search = this.filter == null ? "" : this.filter.method_1882().trim().toLowerCase(Locale.ROOT);
        return Strings.isNullOrEmpty((String)search) || class_124.method_539((String)name).contains(search);
    }

    @Nullable
    public LibrarySlot getHoveredSlot(int mouseX, int mouseY) {
        for (int i = 0; i < 5; ++i) {
            if (this.startIndex + i >= this.data.size() || !this.method_2378(21, 31 + i * 20, 113, 18, mouseX, mouseY)) continue;
            return this.data.get(this.startIndex + i);
        }
        return null;
    }

    public static String format(int n) {
        int log = (int)StrictMath.log10(n);
        if (log <= 4) {
            return String.valueOf(n);
        }
        if (log == 5) {
            return f.format((double)n / 1000.0) + "K";
        }
        if (log <= 8) {
            return f.format((double)n / 1000000.0) + "M";
        }
        return f.format((double)n / 1.0E9) + "B";
    }

    private record LibrarySlot(class_1887 ench, int points, int maxLvl) {
    }
}

