/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.special;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_124;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_7923;

public class AllStatsBonus
extends GemBonus {
    public static Codec<AllStatsBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(AllStatsBonus.gemClass(), (App)PlaceboCodecs.enumCodec(class_1322.class_1323.class).fieldOf("operation").forGetter(a -> a.operation), (App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values), (App)class_7923.field_41190.method_39673().listOf().fieldOf("attributes").forGetter(a -> a.attributes)).apply((Applicative)inst, AllStatsBonus::new));
    protected final class_1322.class_1323 operation;
    protected final Map<LootRarity, StepFunction> values;
    protected final List<class_1320> attributes;

    public AllStatsBonus(GemClass gemClass, class_1322.class_1323 op, Map<LootRarity, StepFunction> values, List<class_1320> attributes) {
        super(Apotheosis.loc("all_stats"), gemClass);
        this.operation = op;
        this.values = values;
        this.attributes = attributes;
    }

    @Override
    public void addModifiers(class_1799 gem, LootRarity rarity, BiConsumer<class_1320, class_1322> map) {
        UUID id = GemItem.getUUIDs(gem).get(0);
        for (class_1320 attr : this.attributes) {
            class_1322 modif = new class_1322(id, "apoth.gem_modifier.all_stats_buff", (double)this.values.get(rarity).min(), this.operation);
            map.accept(attr, modif);
        }
    }

    @Override
    public class_2561 getSocketBonusTooltip(class_1799 gem, LootRarity rarity) {
        StepFunction value = this.values.get(rarity);
        return class_2561.method_43469((String)("bonus." + this.getId() + ".desc"), (Object[])new Object[]{Affix.fmt(value.get(0.0f) * 100.0f)}).method_27692(class_124.field_1054);
    }

    @Override
    public AllStatsBonus validate() {
        Preconditions.checkNotNull((Object)this.operation, (Object)"Invalid AllStatsBonus with null operation");
        Preconditions.checkNotNull(this.values, (Object)"Invalid AllStatsBonus with null values");
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 1;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

