/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class AffixLootEntry
implements CodecProvider<AffixLootEntry>,
WeightedDynamicRegistry.ILuckyWeighted,
WeightedDynamicRegistry.IDimensional,
RarityClamp,
GameStagesCompat.IStaged {
    public static final Codec<AffixLootEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedDynamicRegistry.ILuckyWeighted::getWeight), (App)PlaceboCodecs.nullableField((Codec)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE), (String)"quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedDynamicRegistry.ILuckyWeighted::getQuality), (App)ItemAdapter.CODEC.fieldOf("stack").forGetter(a -> a.stack), (App)PlaceboCodecs.setOf((Codec)class_2960.field_25139).fieldOf("dimensions").forGetter(a -> a.dimensions), (App)RarityRegistry.INSTANCE.holderCodec().fieldOf("min_rarity").forGetter(a -> a.minRarity), (App)RarityRegistry.INSTANCE.holderCodec().fieldOf("max_rarity").forGetter(a -> a.maxRarity), (App)PlaceboCodecs.nullableField((Codec)PlaceboCodecs.setOf((Codec)Codec.STRING), (String)"stages").forGetter(a -> Optional.ofNullable(a.stages))).apply((Applicative)inst, AffixLootEntry::new));
    protected final int weight;
    protected final float quality;
    protected final class_1799 stack;
    protected final Set<class_2960> dimensions;
    protected final DynamicHolder<LootRarity> minRarity;
    protected final DynamicHolder<LootRarity> maxRarity;
    @Nullable
    protected final Set<String> stages;

    public AffixLootEntry(int weight, float quality, class_1799 stack, Set<class_2960> dimensions, DynamicHolder<LootRarity> min, DynamicHolder<LootRarity> max, Optional<Set<String>> stages) {
        this.weight = weight;
        this.quality = quality;
        this.stack = Objects.requireNonNull(stack);
        this.dimensions = dimensions;
        this.minRarity = min;
        this.maxRarity = max;
        this.stages = stages.orElse(null);
    }

    public AffixLootEntry(int weight, float quality, class_1799 stack, Set<class_2960> dimensions, DynamicHolder<LootRarity> min, DynamicHolder<LootRarity> max) {
        this(weight, quality, stack, dimensions, min, max, Optional.empty());
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    public class_1799 getStack() {
        return this.stack.method_7972();
    }

    public Set<class_2960> getDimensions() {
        return this.dimensions;
    }

    @Override
    public LootRarity getMinRarity() {
        return (LootRarity)this.minRarity.get();
    }

    @Override
    public LootRarity getMaxRarity() {
        return (LootRarity)this.maxRarity.get();
    }

    public LootCategory getType() {
        return LootCategory.forItem(this.stack);
    }

    @Override
    public Set<String> getStages() {
        return this.stages;
    }

    public Codec<? extends AffixLootEntry> getCodec() {
        return CODEC;
    }
}

