/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.client;

import dev.shadowsoffire.apotheosis.adventure.socket.SocketedGems;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemInstance;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.joml.Matrix4f;

public class SocketTooltipRenderer
implements class_5684 {
    public static final class_2960 SOCKET = new class_2960("zenith", "textures/gui/socket.png");
    private final SocketComponent comp;
    private final int spacing;

    public SocketTooltipRenderer(SocketComponent comp) {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        this.spacing = 9 + 2;
        this.comp = comp;
    }

    public int method_32661() {
        return this.spacing * this.comp.gems.size();
    }

    public int method_32664(class_327 font) {
        int maxWidth = 0;
        for (GemInstance inst : this.comp.gems.gems()) {
            maxWidth = Math.max(maxWidth, font.method_27525((class_5348)SocketTooltipRenderer.getSocketDesc(inst)) + 12);
        }
        return maxWidth;
    }

    public void method_32666(class_327 font, int x, int y, class_332 gfx) {
        for (int i = 0; i < this.comp.gems.size(); ++i) {
            gfx.method_25291(SOCKET, x, y + this.spacing * i, 0, 0.0f, 0.0f, 9, 9, 9, 9);
        }
        for (GemInstance inst : this.comp.gems()) {
            if (inst.isValid()) {
                class_4587 pose = gfx.method_51448();
                pose.method_22903();
                pose.method_22905(0.5f, 0.5f, 1.0f);
                gfx.method_51445(inst.gemStack(), 2 * x + 1, 2 * y + 1);
                pose.method_22909();
            }
            y += this.spacing;
        }
    }

    public void method_32665(class_327 pFont, int pX, int pY, Matrix4f pMatrix4f, class_4597.class_4598 pBufferSource) {
        for (int i = 0; i < this.comp.gems.size(); ++i) {
            pFont.method_30882(SocketTooltipRenderer.getSocketDesc(this.comp.gems.get(i)), (float)(pX + 12), (float)(pY + 1 + this.spacing * i), 0xAABBCC, true, pMatrix4f, (class_4597)pBufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
    }

    public static class_2561 getSocketDesc(GemInstance inst) {
        if (!inst.isValid()) {
            return class_2561.method_43471((String)"socket.zenith.empty");
        }
        return inst.getSocketBonusTooltip();
    }

    public record SocketComponent(class_1799 socketed, SocketedGems gems) implements class_5632
    {
    }
}

