/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.boss;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.boss.BossStats;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.cca.BossComponent;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.apotheosis.ench.asm.EnchHooks;
import dev.shadowsoffire.apotheosis.mixin.accessors.MobAccessor;
import dev.shadowsoffire.apotheosis.mixin.accessors.NearestAttackableTargetGoalAccessor;
import dev.shadowsoffire.apotheosis.util.NameHelper;
import dev.shadowsoffire.apotheosis.util.SupportingEntity;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.ChancedEffectInstance;
import dev.shadowsoffire.placebo.json.GearSet;
import dev.shadowsoffire.placebo.json.GearSetRegistry;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import dev.shadowsoffire.placebo.json.RandomAttributeModifier;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1548;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class ApothBoss
implements CodecProvider<ApothBoss>,
WeightedDynamicRegistry.ILuckyWeighted,
WeightedDynamicRegistry.IDimensional,
RarityClamp,
GameStagesCompat.IStaged {
    public static final Codec<class_238> AABB_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.DOUBLE.fieldOf("width").forGetter(a -> Math.abs(a.field_1320 - a.field_1323)), (App)Codec.DOUBLE.fieldOf("height").forGetter(a -> Math.abs(a.field_1325 - a.field_1322))).apply((Applicative)inst, (width, height) -> new class_238(0.0, 0.0, 0.0, width.doubleValue(), height.doubleValue(), width.doubleValue())));
    public static final Codec<ApothBoss> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedDynamicRegistry.ILuckyWeighted::getWeight), (App)PlaceboCodecs.nullableField((Codec)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE), (String)"quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedDynamicRegistry.ILuckyWeighted::getQuality), (App)class_7923.field_41177.method_39673().fieldOf("entity").forGetter(a -> a.entity), (App)AABB_CODEC.fieldOf("size").forGetter(a -> a.size), (App)LootRarity.mapCodec(BossStats.CODEC).fieldOf("stats").forGetter(a -> a.stats), (App)PlaceboCodecs.setOf((Codec)Codec.STRING).optionalFieldOf("stages").forGetter(a -> Optional.ofNullable(a.stages)), (App)GearSet.SetPredicate.CODEC.listOf().fieldOf("valid_gear_sets").forGetter(a -> a.gearSets), (App)PlaceboCodecs.nullableField((Codec)NBTAdapter.EITHER_CODEC, (String)"nbt").forGetter(a -> Optional.ofNullable(a.nbt)), (App)PlaceboCodecs.setOf((Codec)class_2960.field_25139).fieldOf("dimensions").forGetter(a -> a.dimensions), (App)LootRarity.CODEC.fieldOf("min_rarity").forGetter(a -> a.minRarity), (App)LootRarity.CODEC.fieldOf("max_rarity").forGetter(a -> a.maxRarity), (App)PlaceboCodecs.nullableField(SupportingEntity.CODEC, (String)"mount").forGetter(a -> Optional.ofNullable(a.mount))).apply((Applicative)inst, ApothBoss::new));
    public static final Predicate<class_1352> IS_VILLAGER_ATTACK = a -> a instanceof class_1400 && ((NearestAttackableTargetGoalAccessor)a).getTargetType() == class_1646.class;
    protected final int weight;
    protected final float quality;
    protected final class_1299<?> entity;
    protected final class_238 size;
    protected final Map<LootRarity, BossStats> stats;
    @Nullable
    protected final Set<String> stages;
    protected final List<GearSet.SetPredicate> gearSets;
    @Nullable
    protected final class_2487 nbt;
    protected final Set<class_2960> dimensions;
    protected final LootRarity minRarity;
    protected final LootRarity maxRarity;
    @Nullable
    protected final SupportingEntity mount;

    public ApothBoss(int weight, float quality, class_1299<?> entity, class_238 size, Map<LootRarity, BossStats> stats, Optional<Set<String>> stages, List<GearSet.SetPredicate> armorSets, Optional<class_2487> nbt, Set<class_2960> dimensions, LootRarity minRarity, LootRarity maxRarity, Optional<SupportingEntity> mount) {
        this.weight = weight;
        this.quality = quality;
        this.entity = entity;
        this.size = size;
        this.stats = stats;
        this.stages = stages.orElse(null);
        this.gearSets = armorSets;
        this.nbt = nbt.orElse(null);
        this.dimensions = dimensions;
        this.minRarity = minRarity;
        this.maxRarity = maxRarity;
        this.mount = mount.orElse(null);
        Preconditions.checkArgument((minRarity.ordinal() <= maxRarity.ordinal() ? 1 : 0) != 0, (Object)"Min rarity must be less than or equal to max rarity.");
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    @Override
    public LootRarity getMinRarity() {
        return this.minRarity;
    }

    @Override
    public LootRarity getMaxRarity() {
        return this.maxRarity;
    }

    public class_238 getSize() {
        return this.size;
    }

    public class_1299<?> getEntity() {
        return this.entity;
    }

    public class_1308 createBoss(class_5425 world, class_2338 pos, class_5819 random, float luck) {
        return this.createBoss(world, pos, random, luck, null);
    }

    public class_1308 createBoss(class_5425 world, class_2338 pos, class_5819 random, float luck, @Nullable LootRarity rarity) {
        class_2487 fakeNbt = this.nbt == null ? new class_2487() : this.nbt;
        fakeNbt.method_10582("id", class_1299.method_5890(this.entity).toString());
        class_1308 entity = (class_1308)class_1299.method_17842((class_2487)fakeNbt, (class_1937)world.method_8410(), Function.identity());
        if (this.nbt != null) {
            entity.method_5651(this.nbt);
        }
        this.initBoss(random, entity, luck, rarity);
        if (this.nbt != null) {
            entity.method_5749(this.nbt);
        }
        if (this.mount != null) {
            class_1308 mountedEntity = this.mount.create((class_1937)world.method_8410(), (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
            entity.method_5873((class_1297)mountedEntity, true);
            entity = mountedEntity;
        }
        entity.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, random.method_43057() * 360.0f, 0.0f);
        return entity;
    }

    public void initBoss(class_5819 rand, class_1308 entity, float luck, @Nullable LootRarity rarity) {
        if (rarity == null) {
            rarity = LootRarity.random(rand, luck, this);
        }
        rarity = this.clamp(rarity);
        BossStats stats = this.stats.get(rarity);
        int duration = entity instanceof class_1548 ? 6000 : Integer.MAX_VALUE;
        for (ChancedEffectInstance inst : stats.effects()) {
            if (!(rand.method_43057() <= inst.chance())) continue;
            entity.method_6092(inst.create(rand, duration));
        }
        for (RandomAttributeModifier modif : stats.modifiers()) {
            modif.apply(rand, (class_1309)entity);
        }
        ((MobAccessor)entity).getGoalSelector().method_35115().removeIf(IS_VILLAGER_ATTACK);
        String name = NameHelper.setEntityName(rand, entity);
        GearSet set = GearSetRegistry.INSTANCE.getRandomSet(rand, luck, this.gearSets);
        set.apply((class_1309)entity);
        boolean anyValid = false;
        for (class_1304 t : class_1304.values()) {
            class_1799 s = entity.method_6118(t);
            if (s.method_7960() || LootCategory.forItem(s).isNone()) continue;
            anyValid = true;
            break;
        }
        if (!anyValid) {
            throw new RuntimeException("Attempted to apply boss gear set " + GearSetRegistry.INSTANCE.getKey((CodecProvider)set) + " but it had no valid affix loot items generated.");
        }
        int guaranteed = rand.method_43048(6);
        class_1799 temp = entity.method_6118(class_1304.values()[guaranteed]);
        while (temp.method_7960() || LootCategory.forItem(temp) == LootCategory.NONE) {
            guaranteed = rand.method_43048(6);
            temp = entity.method_6118(class_1304.values()[guaranteed]);
        }
        for (class_1304 s : class_1304.values()) {
            class_1799 stack = entity.method_6118(s);
            if (stack.method_7960()) continue;
            if (s.ordinal() == guaranteed) {
                entity.method_5946(s, 2.0f);
            }
            if (s.ordinal() == guaranteed) {
                entity.method_5673(s, ApothBoss.modifyBossItem(stack, rand, name, luck, rarity, stats));
                entity.method_5665((class_2561)((class_5250)entity.method_5797()).method_27696(class_2583.field_24360.method_27703(rarity.getColor())));
                continue;
            }
            if (!(rand.method_43057() < stats.enchantChance())) continue;
            ApothBoss.enchantBossItem(rand, stack, Apotheosis.enableEnch ? stats.enchLevels()[0] : stats.enchLevels()[1], true);
            entity.method_5673(s, stack);
        }
        ((BossComponent)ZenithComponents.BOSS_DATA.get((Object)entity)).setRarityAndBoss(RarityRegistry.INSTANCE.getKey(rarity).toString());
        entity.method_6033(entity.method_6063());
        if (AdventureConfig.bossGlowOnSpawn) {
            entity.method_6092(new class_1293(class_1294.field_5912, 3600));
        }
    }

    public static void enchantBossItem(class_5819 rand, class_1799 stack, int level, boolean treasure) {
        List ench = class_1890.method_8230((class_5819)rand, (class_1799)stack, (int)level, (boolean)treasure);
        Map<class_1887, Integer> map = ench.stream().filter(d -> !d.field_9093.method_8195()).collect(Collectors.toMap(d -> d.field_9093, d -> d.field_9094, Math::max));
        map.putAll(class_1890.method_8222((class_1799)stack));
        class_1890.method_8214(map, (class_1799)stack);
    }

    public static class_1799 modifyBossItem(class_1799 stack, class_5819 rand, String bossName, float luck, LootRarity rarity, BossStats stats) {
        List<class_1887> curses;
        class_7417 class_74172;
        ApothBoss.enchantBossItem(rand, stack, Apotheosis.enableEnch ? stats.enchLevels()[2] : stats.enchLevels()[3], true);
        NameHelper.setItemName(rand, stack);
        stack = LootController.createLootItem(stack, LootCategory.forItem(stack), rarity, rand);
        String bossOwnerName = String.format(NameHelper.ownershipFormat, bossName);
        class_2561 name = AffixHelper.getName(stack);
        if (!bossName.isEmpty() && (class_74172 = name.method_10851()) instanceof class_2588) {
            class_2588 tc = (class_2588)class_74172;
            String oldKey = tc.method_11022();
            String string = "misc.zenith.affix_name.two".equals(oldKey) ? "misc.zenith.affix_name.three" : "misc.zenith.affix_name.four";
            Object[] newArgs = new Object[tc.method_11023().length + 1];
            newArgs[0] = bossOwnerName;
            for (int i = 1; i < newArgs.length; ++i) {
                newArgs[i] = tc.method_11023()[i - 1];
            }
            class_5250 copy = class_2561.method_43469((String)string, (Object[])newArgs).method_27696(name.method_10866().method_10978(Boolean.valueOf(false)));
            AffixHelper.setName(stack, (class_2561)copy);
        }
        HashMap<class_1887, Integer> enchMap = new HashMap<class_1887, Integer>();
        for (Map.Entry entry : class_1890.method_8222((class_1799)stack).entrySet()) {
            if (entry.getKey() == null) continue;
            enchMap.put((class_1887)entry.getKey(), Math.min(EnchHooks.getMaxLevel((class_1887)entry.getKey()), (Integer)entry.getValue() + rand.method_43048(2)));
        }
        if (AdventureConfig.curseBossItems && !(curses = class_7923.field_41176.method_10220().filter(class_1887::method_8195).toList()).isEmpty()) {
            class_1887 class_18872 = curses.get(rand.method_43048(curses.size()));
            enchMap.put(class_18872, class_3532.method_15395((class_5819)rand, (int)1, (int)EnchHooks.getMaxLevel(class_18872)));
        }
        class_1890.method_8214(enchMap, (class_1799)stack);
        stack.method_7969().method_10556("apoth_boss", true);
        return stack;
    }

    public ApothBoss validate(class_2960 key) {
        Preconditions.checkArgument((this.weight >= 0 ? 1 : 0) != 0, (Object)("Boss Item " + key + " has a negative weight!"));
        Preconditions.checkArgument((this.quality >= 0.0f ? 1 : 0) != 0, (Object)("Boss Item " + key + " has a negative quality!"));
        Preconditions.checkNotNull(this.entity, (Object)("Boss Item " + key + " has null entity type!"));
        Preconditions.checkNotNull((Object)this.size, (Object)("Boss Item " + key + " has no size!"));
        if (this.minRarity != null) {
            Preconditions.checkArgument((this.maxRarity == null || this.maxRarity.isAtLeast(this.minRarity) ? 1 : 0) != 0);
        }
        if (this.maxRarity != null) {
            Preconditions.checkArgument((this.minRarity == null || this.maxRarity.isAtLeast(this.minRarity) ? 1 : 0) != 0);
        }
        if (this.mount != null) {
            Preconditions.checkNotNull(this.mount.entity, (Object)("Boss Item " + key + " has an invalid mount"));
        }
        for (LootRarity r = this.minRarity; r != this.maxRarity; r = r.next()) {
            Preconditions.checkNotNull((Object)this.stats.get(r));
        }
        return this;
    }

    public Set<class_2960> getDimensions() {
        return this.dimensions;
    }

    @Override
    public Set<String> getStages() {
        return this.stages;
    }

    public Codec<? extends ApothBoss> getCodec() {
        return CODEC;
    }
}

