/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.reforging;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingMenu;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingScreen;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureContainerScreen;
import dev.shadowsoffire.apotheosis.adventure.client.GhostVertexBuilder;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import java.util.ArrayList;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class ReforgingScreen
extends AdventureContainerScreen<ReforgingMenu> {
    public static final class_2960 TEXTURE = new class_2960("zenith", "textures/gui/reforge.png");
    public static final class_2960 ANIMATED_TEXTURE = new class_2960("zenith", "textures/gui/reforge_animation.png");
    public static final int MAX_ANIMATION_TIME = 8;
    protected boolean hasMainItem = false;
    protected int animationTick = 0;
    protected int maxSlot = -1;
    protected int opacityTick = 0;
    protected int availableOpacity = 170;

    public ReforgingScreen(ReforgingMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, title);
        this.field_2779 = 266;
    }

    public void method_25394(class_332 gfx, int mouseX, int mouseY, float pPartialTick) {
        this.method_25420(gfx);
        super.method_25394(gfx, mouseX, mouseY, pPartialTick);
        RenderSystem.disableBlend();
        this.method_2380(gfx, mouseX, mouseY);
        int sigils = ((ReforgingMenu)this.field_2797).getSigilCount();
        int mats = ((ReforgingMenu)this.field_2797).getMatCount();
        int levels = ((ReforgingMenu)this.field_2797).player.field_7520;
        for (int idx = 0; idx < 3; ++idx) {
            class_1799 choice;
            class_1735 slot = ((ReforgingMenu)this.method_17577()).method_7611(3 + idx);
            if (!this.method_2378(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY) || (choice = slot.method_7677()).method_7960()) continue;
            ArrayList<Object> tooltips = new ArrayList<Object>();
            int sigilCost = ((ReforgingMenu)this.field_2797).getSigilCost(idx);
            int matCost = ((ReforgingMenu)this.field_2797).getMatCost(idx);
            int levelCost = ((ReforgingMenu)this.field_2797).getLevelCost(idx);
            boolean creative = this.field_22787.field_1724.method_7337();
            tooltips.add(class_2561.method_43471((String)"text.zenith.reforge_cost").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
            tooltips.add(class_5244.field_39003);
            if (sigilCost > 0) {
                tooltips.add(class_2561.method_43469((String)"%s %s", (Object[])new Object[]{sigilCost, Adventure.Items.SIGIL_OF_REBIRTH.method_7864(class_1799.field_8037)}).method_27692(creative || sigils >= sigilCost ? class_124.field_1080 : class_124.field_1061));
            }
            if (matCost > 0) {
                tooltips.add(class_2561.method_43469((String)"%s %s", (Object[])new Object[]{matCost, ((ReforgingMenu)this.field_2797).method_7611(1).method_7677().method_7964().getString()}).method_27692(creative || mats >= matCost ? class_124.field_1080 : class_124.field_1061));
            }
            String key = idx == 0 ? "container.enchant.level.one" : "container.enchant.level.many";
            tooltips.add(class_2561.method_43469((String)key, (Object[])new Object[]{idx + 1}).method_27692(creative || levels >= levelCost ? class_124.field_1080 : class_124.field_1061));
            tooltips.add(class_2561.method_43470((String)" "));
            tooltips.add(class_2561.method_43469((String)"container.enchant.level.requirement", (Object[])new Object[]{levelCost}).method_27692(creative || levels >= levelCost ? class_124.field_1080 : class_124.field_1061));
            this.drawOnLeft(gfx, tooltips, this.field_2800 + 45);
            break;
        }
    }

    protected void method_2389(class_332 gfx, float partials, int x, int y) {
        class_1735 slot;
        int left = this.field_2776;
        int top = this.field_2800;
        int xCenter = (this.field_22789 - this.field_2792) / 2;
        int yCenter = (this.field_22790 - this.field_2779) / 2;
        gfx.method_25290(TEXTURE, xCenter, yCenter, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 384);
        LootRarity rarity = ((ReforgingMenu)this.field_2797).getRarity();
        for (int idx = 0; idx < 3; ++idx) {
            if (this.maxSlot < idx || this.animationTick != 0) continue;
            gfx.method_25290(TEXTURE, left + 20 + 46 * idx, top + 129, (float)(20 + 46 * idx), 273.0f, 46, 35, 256, 384);
        }
        boolean hadItem = this.hasMainItem;
        this.hasMainItem = ((ReforgingMenu)this.field_2797).method_7611(0).method_7681();
        if (!hadItem && this.hasMainItem) {
            this.animationTick = 8;
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)Adventure.Sounds.REFORGE, (float)1.0f, (float)2.0f));
        }
        if (this.hasMainItem) {
            float delta = class_3532.method_15363((float)(((float)(8 - this.animationTick) - partials) / 8.0f), (float)0.0f, (float)1.0f);
            int frame = class_3532.method_48781((float)delta, (int)0, (int)20);
            gfx.method_25293(ANIMATED_TEXTURE, left + 26, top + 15, 127, 112, 0.0f, (float)(frame * 112), 127, 112, 127, 2240);
        }
        int sigils = ((ReforgingMenu)this.field_2797).getSigilCount();
        int mats = ((ReforgingMenu)this.field_2797).getMatCount();
        int levels = ((ReforgingMenu)this.field_2797).player.field_7520;
        this.maxSlot = -1;
        for (int idx = 0; idx < 3 && (slot = ((ReforgingMenu)this.method_17577()).method_7611(3 + idx)).method_7681(); ++idx) {
            int sigilCost = ((ReforgingMenu)this.field_2797).getSigilCost(idx);
            int matCost = ((ReforgingMenu)this.field_2797).getMatCost(idx);
            int levelCost = ((ReforgingMenu)this.field_2797).getLevelCost(idx);
            if ((sigils < sigilCost || levels < levelCost || mats < matCost) && !this.field_22787.field_1724.method_31549().field_7477) continue;
            ++this.maxSlot;
        }
    }

    protected int darken(int rColor, int factor) {
        int r = rColor >> 16 & 0xFF;
        int g = rColor >> 8 & 0xFF;
        int b = rColor & 0xFF;
        return (r /= factor) << 16 | (g /= factor) << 8 | (b /= factor);
    }

    protected void drawBorderedString(class_332 gfx, String str, int x, int y, int color, int shadowColor) {
        class_5250 comp = class_2561.method_43470((String)str);
        gfx.method_51439(this.field_22793, (class_2561)comp, x, y - 1, shadowColor, false);
        gfx.method_51439(this.field_22793, (class_2561)comp, x - 1, y, shadowColor, false);
        gfx.method_51439(this.field_22793, (class_2561)comp, x, y + 1, shadowColor, false);
        gfx.method_51439(this.field_22793, (class_2561)comp, x + 1, y, shadowColor, false);
        gfx.method_51439(this.field_22793, (class_2561)comp, x, y, color, false);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        for (int k = 0; k < 3; ++k) {
            double d0 = pMouseX - (double)(i + 60);
            double d1 = pMouseY - (double)(j + 14 + 19 * k);
            if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 108.0) || !(d1 < 19.0) || !((ReforgingMenu)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, k)) continue;
            this.field_22787.field_1761.method_2900(((ReforgingMenu)this.field_2797).field_7763, k);
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    protected void method_37432() {
        ++this.opacityTick;
        if (this.animationTick > 0) {
            --this.animationTick;
            if (this.animationTick == 0) {
                this.opacityTick = 0;
            }
        }
        float sin = class_3532.method_15374((float)((float)this.opacityTick / 60.0f * (float)Math.PI));
        float delta = sin * sin;
        this.availableOpacity = class_3532.method_48781((float)delta, (int)136, (int)221);
    }

    public void method_2385(class_332 gfx, class_1735 slot) {
        if (slot instanceof ReforgingMenu.ReforgingResultSlot) {
            if (this.animationTick == 0) {
                int opacity = this.maxSlot >= slot.method_34266() ? this.availableOpacity : 64;
                class_4587 pose = gfx.method_51448();
                pose.method_22903();
                pose.method_46416(0.0f, 0.0f, 100.0f);
                SalvagingScreen.renderGuiItem(gfx, slot.method_7677(), slot.field_7873, slot.field_7872, GhostVertexBuilder.makeGhostBuffer(opacity));
                pose.method_22909();
            }
        } else {
            super.method_2385(gfx, slot);
        }
    }
}

