/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3544;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.spell_engine.api.spell.SpellEvents;

public class PotionAffix
extends Affix {
    public static final Codec<PotionAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_7923.field_41174.method_39673().fieldOf("mob_effect").forGetter(a -> a.effect), (App)Target.CODEC.fieldOf("target").forGetter(a -> a.target), (App)LootRarity.mapCodec(EffectData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)0).forGetter(a -> a.cooldown), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"stack_on_reapply", (Object)false).forGetter(a -> a.stackOnReapply)).apply((Applicative)inst, PotionAffix::new));
    protected final class_1291 effect;
    protected final Target target;
    protected final Map<LootRarity, EffectData> values;
    @Deprecated(forRemoval=true, since="apoth 6.3.0")
    protected final int cooldown;
    protected final Set<LootCategory> types;
    protected final boolean stackOnReapply;

    public PotionAffix(class_1291 effect, Target target, Map<LootRarity, EffectData> values, int cooldown, Set<LootCategory> types, boolean stackOnReapply) {
        super(AffixType.ABILITY);
        this.effect = effect;
        this.target = target;
        this.values = values;
        this.cooldown = cooldown;
        this.types = types;
        this.stackOnReapply = stackOnReapply;
    }

    @Override
    public class_5250 getDescription(class_1799 stack, LootRarity rarity, float level) {
        class_1293 inst = this.values.get(rarity).build(this.effect, level);
        class_5250 comp = this.target.toComponent(PotionAffix.toComponent(inst));
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0) {
            class_5250 cd = class_2561.method_43469((String)"affix.zenith.cooldown", (Object[])new Object[]{class_3544.method_15439((int)cooldown)});
            comp = comp.method_27693(" ").method_10852((class_2561)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"affix.zenith.stacking"));
        }
        return comp;
    }

    @Override
    public class_2561 getAugmentingText(class_1799 stack, LootRarity rarity, float level) {
        int cooldown;
        class_5250 maxComp;
        class_5250 minComp;
        class_1293 inst = this.values.get(rarity).build(this.effect, level);
        class_5250 comp = this.target.toComponent(PotionAffix.toComponent(inst));
        class_1293 min = this.values.get(rarity).build(this.effect, 0.0f);
        class_1293 max = this.values.get(rarity).build(this.effect, 1.0f);
        if (min.method_5578() != max.method_5578()) {
            minComp = min.method_5578() == 0 ? class_2561.method_43470((String)"I") : class_2561.method_43471((String)("potion.potency." + min.method_5578()));
            maxComp = class_2561.method_43471((String)("potion.potency." + max.method_5578()));
            comp.method_10852((class_2561)PotionAffix.valueBounds((class_2561)minComp, (class_2561)maxComp));
        }
        if (!this.effect.method_5561() && min.method_5584() != max.method_5584()) {
            minComp = class_1292.method_5577((class_1293)min, (float)1.0f);
            maxComp = class_1292.method_5577((class_1293)max, (float)1.0f);
            comp.method_10852((class_2561)PotionAffix.valueBounds((class_2561)minComp, (class_2561)maxComp));
        }
        if ((cooldown = this.getCooldown(rarity)) != 0) {
            class_5250 cd = class_2561.method_43469((String)"affix.zenith.cooldown", (Object[])new Object[]{class_3544.method_15439((int)cooldown)});
            comp = comp.method_27693(" ").method_10852((class_2561)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"affix.zenith.stacking"));
        }
        return comp;
    }

    @Override
    public boolean canApplyTo(class_1799 stack, LootCategory cat, LootRarity rarity) {
        return (this.types.isEmpty() || this.types.contains(cat)) && this.values.containsKey(rarity);
    }

    @Override
    public void doPostHurt(class_1799 stack, LootRarity rarity, float level, class_1309 user, class_1297 attacker) {
        if (this.target == Target.HURT_SELF) {
            this.applyEffect(user, rarity, level);
        } else if (this.target == Target.HURT_ATTACKER && attacker instanceof class_1309) {
            class_1309 tLiving = (class_1309)attacker;
            this.applyEffect(tLiving, rarity, level);
        }
    }

    @Override
    public void doPostAttack(class_1799 stack, LootRarity rarity, float level, class_1309 user, class_1297 target) {
        if (this.target == Target.ATTACK_SELF) {
            this.applyEffect(user, rarity, level);
        } else if (this.target == Target.ATTACK_TARGET && target instanceof class_1309) {
            class_1309 tLiving = (class_1309)target;
            this.applyEffect(tLiving, rarity, level);
        }
    }

    @Override
    public void onBlockBreak(class_1799 stack, LootRarity rarity, float level, class_1657 player, class_1936 world, class_2338 pos, class_2680 state) {
        if (this.target == Target.BREAK_SELF) {
            this.applyEffect((class_1309)player, rarity, level);
        }
    }

    @Override
    public void onArrowImpact(class_1665 arrow, LootRarity rarity, float level, class_239 res, class_239.class_240 type) {
        class_1297 class_12972;
        if (this.target == Target.ARROW_SELF) {
            class_1297 class_12973 = arrow.method_24921();
            if (class_12973 instanceof class_1309) {
                class_1309 owner = (class_1309)class_12973;
                this.applyEffect(owner, rarity, level);
            }
        } else if (this.target == Target.ARROW_TARGET && type == class_239.class_240.field_1331 && (class_12972 = ((class_3966)res).method_17782()) instanceof class_1309) {
            class_1309 target = (class_1309)class_12972;
            this.applyEffect(target, rarity, level);
        }
    }

    @Override
    public float onShieldBlock(class_1799 stack, LootRarity rarity, float level, class_1309 entity, class_1282 source, float amount) {
        class_1297 class_12972;
        if (this.target == Target.BLOCK_SELF) {
            this.applyEffect(entity, rarity, level);
        } else if (this.target == Target.BLOCK_ATTACKER && (class_12972 = source.method_5526()) instanceof class_1309) {
            class_1309 target = (class_1309)class_12972;
            this.applyEffect(target, rarity, level);
        }
        return amount;
    }

    @Override
    public void onCast(class_1799 stack, LootRarity rarity, float level, SpellEvents.ProjectileLaunchEvent event) {
        class_1297 class_12972;
        if (this.target == Target.SPELL_CAST_SELF) {
            this.applyEffect(event.caster(), rarity, level);
        } else if (this.target == Target.SPELL_CAST_TARGET && (class_12972 = event.target()) instanceof class_1309) {
            class_1309 target = (class_1309)class_12972;
            this.applyEffect(target, rarity, level);
        }
    }

    protected int getCooldown(LootRarity rarity) {
        EffectData data = this.values.get(rarity);
        if (data.cooldown != -1) {
            return data.cooldown;
        }
        return this.cooldown;
    }

    private void applyEffect(class_1309 target, LootRarity rarity, float level) {
        if (target.method_37908().method_8608()) {
            return;
        }
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0 && PotionAffix.isOnCooldown(this.getId(), cooldown, target)) {
            return;
        }
        EffectData data = this.values.get(rarity);
        class_1293 inst = target.method_6112(this.effect);
        if (this.stackOnReapply && inst != null) {
            if (inst != null) {
                class_1293 newInst = new class_1293(this.effect, (int)Math.max((float)inst.method_5584(), data.duration.get(level)), (int)((float)(inst.method_5578() + 1) + data.amplifier.get(level)));
                target.method_6092(newInst);
            }
        } else {
            target.method_6092(data.build(this.effect, level));
        }
        PotionAffix.startCooldown(this.getId(), target);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static class_2561 toComponent(class_1293 inst) {
        class_5250 mutablecomponent = class_2561.method_43471((String)inst.method_5586());
        class_1291 mobeffect = inst.method_5579();
        if (inst.method_5578() > 0) {
            mutablecomponent = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, class_2561.method_43471((String)("potion.potency." + inst.method_5578()))});
        }
        if (inst.method_5584() > 20) {
            mutablecomponent = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, class_1292.method_5577((class_1293)inst, (float)1.0f)});
        }
        return mutablecomponent.method_27692(mobeffect.method_18792().method_18793());
    }

    public static enum Target {
        ATTACK_SELF("attack_self"),
        ATTACK_TARGET("attack_target"),
        HURT_SELF("hurt_self"),
        HURT_ATTACKER("hurt_attacker"),
        BREAK_SELF("break_self"),
        ARROW_SELF("arrow_self"),
        ARROW_TARGET("arrow_target"),
        BLOCK_SELF("block_self"),
        BLOCK_ATTACKER("block_attacker"),
        SPELL_CAST_SELF("spell_cast_self"),
        SPELL_CAST_TARGET("spell_cast_target");

        public static final Codec<Target> CODEC;
        private final String id;

        private Target(String id) {
            this.id = id;
        }

        public class_5250 toComponent(Object ... args) {
            return class_2561.method_43469((String)("affix.zenith.target." + this.id), (Object[])args);
        }

        static {
            CODEC = PlaceboCodecs.enumCodec(Target.class);
        }
    }

    public record EffectData(StepFunction duration, StepFunction amplifier, int cooldown) {
        private static Codec<EffectData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.fieldOf("duration").forGetter(EffectData::duration), (App)StepFunction.CODEC.fieldOf("amplifier").forGetter(EffectData::amplifier), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)-1).forGetter(EffectData::cooldown)).apply((Applicative)inst, EffectData::new));

        public class_1293 build(class_1291 effect, float level) {
            return new class_1293(effect, this.duration.getInt(level), this.amplifier.getInt(level));
        }
    }
}

