/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.attributeslib.util.AttributesUtil;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_8103;

public class DamageReductionAffix
extends Affix {
    public static final Codec<DamageReductionAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DamageType.CODEC.fieldOf("damage_type").forGetter(a -> a.type), (App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types)).apply((Applicative)inst, DamageReductionAffix::new));
    protected final DamageType type;
    protected final Map<LootRarity, StepFunction> values;
    protected final Set<LootCategory> types;

    public DamageReductionAffix(DamageType type, Map<LootRarity, StepFunction> levelFuncs, Set<LootCategory> types) {
        super(AffixType.ABILITY);
        this.type = type;
        this.values = levelFuncs;
        this.types = types;
    }

    @Override
    public boolean canApplyTo(class_1799 stack, LootCategory cat, LootRarity rarity) {
        return !cat.isNone() && (this.types.isEmpty() || this.types.contains(cat)) && this.values.containsKey(rarity);
    }

    @Override
    public class_5250 getDescription(class_1799 stack, LootRarity rarity, float level) {
        return class_2561.method_43469((String)"affix.zenith:damage_reduction.desc", (Object[])new Object[]{class_2561.method_43471((String)("misc.zenith." + this.type.id)), DamageReductionAffix.fmt(100.0f * this.getTrueLevel(rarity, level))});
    }

    @Override
    public class_2561 getAugmentingText(class_1799 stack, LootRarity rarity, float level) {
        class_5250 comp = this.getDescription(stack, rarity, level);
        class_5250 minComp = class_2561.method_43469((String)"%s%%", (Object[])new Object[]{DamageReductionAffix.fmt(100.0f * this.getTrueLevel(rarity, 0.0f))});
        class_5250 maxComp = class_2561.method_43469((String)"%s%%", (Object[])new Object[]{DamageReductionAffix.fmt(100.0f * this.getTrueLevel(rarity, 1.0f))});
        return comp.method_10852((class_2561)DamageReductionAffix.valueBounds((class_2561)minComp, (class_2561)maxComp));
    }

    @Override
    public float onHurt(class_1799 stack, LootRarity rarity, float level, class_1282 src, class_1309 ent, float amount) {
        if (src.method_48789(class_8103.field_42242) || src.method_48789(class_8103.field_42245)) {
            return amount;
        }
        if (this.type.test(src)) {
            return amount * (1.0f - this.getTrueLevel(rarity, level));
        }
        return super.onHurt(stack, rarity, level, src, ent, amount);
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static enum DamageType implements Predicate<class_1282>
    {
        PHYSICAL("physical", AttributesUtil::isPhysicalDamage),
        MAGIC("magic", d -> d.method_48789(class_8103.field_42241)),
        FIRE("fire", d -> d.method_48789(class_8103.field_42246)),
        FALL("fall", d -> d.method_48789(class_8103.field_42250)),
        EXPLOSION("explosion", d -> d.method_48789(class_8103.field_42249));

        public static Codec<DamageType> CODEC;
        private final String id;
        private final Predicate<class_1282> predicate;

        private DamageType(String id, Predicate<class_1282> predicate) {
            this.id = id;
            this.predicate = predicate;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public boolean test(class_1282 t) {
            return this.predicate.test(t);
        }

        static {
            CODEC = PlaceboCodecs.enumCodec(DamageType.class);
        }
    }
}

