/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.augmenting;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.AugmentingMenu;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureContainerScreen;
import dev.shadowsoffire.apotheosis.adventure.client.DropDownList;
import dev.shadowsoffire.apotheosis.adventure.client.SimpleTexButton;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.mixin.AbstractContainerScreenAccessor;
import dev.shadowsoffire.apotheosis.mixin.GuiGraphicsAccessor;
import dev.shadowsoffire.apotheosis.mixin.accessors.ScreenAccessor;
import dev.shadowsoffire.apotheosis.util.TooltipUtil;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5225;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8001;

public class AugmentingScreen
extends AdventureContainerScreen<AugmentingMenu> {
    public static final class_2960 TEXTURE = new class_2960("zenith", "textures/gui/augmenting.png");
    public static final int ALTERNATIVE_TEXT_WIDTH = 150;
    public static final int ALTERNATIVE_MAX_LINES = 15;
    protected class_1799 lastMainItem = class_1799.field_8037;
    protected int lastSelection = -1;
    protected List<AffixInstance> currentItemAffixes = Collections.emptyList();
    protected int alternativePage = -1;
    protected List<List<class_5348>> alternativePages = Collections.emptyList();
    protected int alternativeXPos = 0;
    protected int alternativeWidth = 0;
    protected AffixDropList list;
    protected SimpleTexButton upgradeBtn;
    protected SimpleTexButton rerollBtn;

    public AugmentingScreen(AugmentingMenu pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.field_2779 = 222;
    }

    protected void method_25426() {
        super.method_25426();
        int left = this.field_2776;
        int top = this.field_2800;
        int selected = this.getSelectedAffix();
        this.list = (AffixDropList)this.method_37063((class_364)new AffixDropList(left + 39, top + 17, 123, 14, (class_2561)class_2561.method_43473(), this.currentItemAffixes, 6));
        this.list.setSelected(selected);
        class_5250 sigilName = class_2561.method_43471((String)"item.zenith.sigil_of_enhancement").method_27692(class_124.field_1054);
        this.upgradeBtn = (SimpleTexButton)this.method_37063((class_364)new FatTexButton(left + 60, top + 111, 29, 13, 186, 135, btn -> {
            if (this.getSelectedAffix() != -1) {
                this.field_22787.field_1761.method_2900(((AugmentingMenu)this.field_2797).field_7763, 0 | this.getSelectedAffix() << 1);
            }
        }, (class_2561)class_2561.method_43471((String)"button.zenith.augmenting.upgrade"), (class_2561)class_2561.method_43469((String)"button.zenith.augmenting.upgrade.cost", (Object[])new Object[]{2, sigilName})));
        this.rerollBtn = (SimpleTexButton)this.method_37063((class_364)new FatTexButton(left + 112, top + 111, 29, 13, 223, 135, btn -> {
            if (this.getSelectedAffix() != -1) {
                this.field_22787.field_1761.method_2900(((AugmentingMenu)this.field_2797).field_7763, 1 | this.getSelectedAffix() << 1);
            }
        }, (class_2561)class_2561.method_43471((String)"button.zenith.augmenting.reroll"), (class_2561)class_2561.method_43469((String)"button.zenith.augmenting.upgrade.cost", (Object[])new Object[]{1, sigilName})));
    }

    protected void method_2389(class_332 gfx, float partialTick, int mouseX, int mouseY) {
        AffixInstance inst;
        this.updateCachedState();
        int left = this.field_2776;
        int top = this.field_2800;
        int xCenter = (this.field_22789 - this.field_2792) / 2;
        int yCenter = (this.field_22790 - this.field_2779) / 2;
        gfx.method_25290(TEXTURE, xCenter, yCenter, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 307);
        int selected = this.getSelectedAffix();
        if (selected != -1 && !this.list.isOpen()) {
            inst = this.currentItemAffixes.get(selected);
            class_2561 comp = inst.getAugmentingText();
            List split = this.field_22793.method_1728((class_5348)comp, 117);
            for (int i = 0; i < split.size(); ++i) {
                gfx.method_51430(this.field_22793, (class_5481)split.get(i), left + 43, top + 40 + i * 11, class_124.field_1054.method_532().intValue(), true);
            }
            int bgColor = -267386864;
            int borderColor = -13220529;
            TooltipUtil.renderTooltipBackground(gfx, left + 42, top + 39, 117, 65, 0, bgColor, bgColor, borderColor, borderColor);
        } else {
            int bgColor = -1441787888;
            int borderColor = -1439283889;
            TooltipUtil.renderTooltipBackground(gfx, left + 42, top + 39, 117, 65, 0, bgColor, bgColor, borderColor, borderColor);
        }
        if (selected != -1 && this.rerollBtn.method_49606() && this.rerollBtn.method_37303() && this.alternativePage != -1) {
            List<class_5348> page = this.alternativePages.get(this.alternativePage);
            List list = page.stream().map(arg_0 -> ((class_2477)class_2477.method_10517()).method_30934(arg_0)).map(class_5684::method_32662).collect(Collectors.toCollection(Lists::newArrayList));
            if (this.alternativePages.size() > 1) {
                list.set(list.size() - 2, new FakeWidthComponent(this.alternativeWidth));
            }
            ((GuiGraphicsAccessor)gfx).callRenderTooltipInternal(this.field_22793, list, this.alternativeXPos, this.field_2800 + 33, class_8001.field_41687);
        }
        if (selected != -1 && this.upgradeBtn.method_37303() && this.upgradeBtn.method_49606()) {
            inst = this.currentItemAffixes.get(selected);
            AffixInstance upgraded = new AffixInstance(inst.affix(), inst.stack(), inst.rarity(), Math.min(1.0f, inst.level() + 0.25f));
            ArrayList<class_5250> altText = new ArrayList<class_5250>();
            altText.add(class_2561.method_43471((String)"text.zenith.upgraded_form").method_27695(new class_124[]{class_124.field_1065, class_124.field_1073}));
            altText.add(class_2561.method_43469((String)"%s", (Object[])new Object[]{upgraded.getAugmentingText()}).method_27692(class_124.field_1054));
            this.drawOnLeft(gfx, altText, top + 33, 150);
        }
    }

    protected void updateCachedState() {
        int selected;
        class_1799 mainItem = ((AugmentingMenu)this.field_2797).getMainItem();
        if (!class_1799.method_31577((class_1799)mainItem, (class_1799)this.lastMainItem)) {
            List<AffixInstance> newAffixes = AugmentingMenu.computeItemAffixes(mainItem);
            if (class_1799.method_7984((class_1799)mainItem, (class_1799)this.lastMainItem) && this.currentItemAffixes.size() == newAffixes.size()) {
                this.list.setEntries(newAffixes);
                this.list.setSelected(this.lastSelection);
            } else {
                this.list.setEntries(newAffixes);
            }
            this.currentItemAffixes = newAffixes;
            this.lastMainItem = mainItem.method_7972();
            this.computeAlternatives(this.list.getSelected());
        }
        if (this.lastSelection != this.list.getSelected()) {
            this.lastSelection = this.list.getSelected();
            this.computeAlternatives(this.lastSelection);
        }
        if ((selected = this.getSelectedAffix()) == -1) {
            class_5250 comp = class_2561.method_43471((String)"button.zenith.augmenting.no_selection").method_27692(class_124.field_1061);
            this.upgradeBtn.field_22763 = false;
            this.upgradeBtn.setInactiveMessage((class_2561)comp);
            this.rerollBtn.field_22763 = false;
            this.rerollBtn.setInactiveMessage((class_2561)comp);
        } else {
            this.upgradeBtn.field_22763 = true;
            this.rerollBtn.field_22763 = true;
            AffixInstance current = this.currentItemAffixes.get(selected);
            if (current.level() >= 1.0f) {
                this.upgradeBtn.field_22763 = false;
                this.upgradeBtn.setInactiveMessage((class_2561)class_2561.method_43471((String)"button.zenith.augmenting.max_level").method_27692(class_124.field_1061));
            }
            if (this.alternativePages.isEmpty()) {
                this.rerollBtn.field_22763 = false;
                this.rerollBtn.setInactiveMessage((class_2561)class_2561.method_43471((String)"button.zenith.augmenting.no_alternatives").method_27692(class_124.field_1061));
            }
            if (this.upgradeBtn.method_37303() && ((AugmentingMenu)this.field_2797).getSigils().method_7947() < 2 && !((AugmentingMenu)this.field_2797).player.method_7337()) {
                this.upgradeBtn.field_22763 = false;
                this.upgradeBtn.setInactiveMessage((class_2561)class_2561.method_43471((String)"Not Enough Sigils").method_27692(class_124.field_1061));
            }
            if (this.rerollBtn.method_37303() && ((AugmentingMenu)this.field_2797).getSigils().method_7947() < 1 && !((AugmentingMenu)this.field_2797).player.method_7337()) {
                this.rerollBtn.field_22763 = false;
                this.rerollBtn.setInactiveMessage((class_2561)class_2561.method_43471((String)"Not Enough Sigils").method_27692(class_124.field_1061));
            }
        }
    }

    protected void computeAlternatives(int selected) {
        if (selected == -1) {
            this.alternativePages = Collections.emptyList();
            this.alternativePage = -1;
            return;
        }
        AffixInstance current = this.currentItemAffixes.get(selected);
        List<DynamicHolder<? extends Affix>> alternatives = LootController.getAvailableAffixes(this.lastMainItem, (LootRarity)current.rarity().get(), this.currentItemAffixes.stream().map(AffixInstance::affix).collect(Collectors.toSet()), ((Affix)current.affix().get()).getType());
        if (alternatives.isEmpty()) {
            this.alternativePages = Collections.emptyList();
            this.alternativePage = -1;
        } else {
            class_5225 splitter = this.field_22793.method_27527();
            int maxWidth = 0;
            class_5250 heading = class_2561.method_43471((String)"text.zenith.potential_rerolls").method_27695(new class_124[]{class_124.field_1065, class_124.field_1073});
            ArrayList<List<class_5348>> pages = new ArrayList<List<class_5348>>();
            ArrayList<Object> page = new ArrayList<Object>();
            page.add(heading);
            boolean first = true;
            for (DynamicHolder<? extends Affix> afx : alternatives) {
                class_2561 augTxt = ((Affix)afx.get()).getAugmentingText(current.stack(), (LootRarity)current.rarity().get(), current.level());
                List split = splitter.method_27495((class_5348)class_2561.method_43469((String)"%s", (Object[])new Object[]{augTxt}).method_27692(class_124.field_1054), 150, augTxt.method_10866());
                maxWidth = Math.max(maxWidth, split.stream().map(arg_0 -> ((class_327)((ScreenAccessor)this.ths()).getFont()).method_27525(arg_0)).max(Integer::compare).get());
                if (page.size() + split.size() + 1 > 15) {
                    pages.add(page);
                    page = new ArrayList();
                    page.add(heading);
                    page.addAll(split);
                } else {
                    if (!first) {
                        page.add(class_5244.field_41874);
                    }
                    page.addAll(split);
                    first = false;
                }
                if (afx != alternatives.get(alternatives.size() - 1)) continue;
                pages.add(page);
            }
            this.alternativePage = 0;
            this.alternativePages = pages;
            this.alternativeXPos = ((AbstractContainerScreenAccessor)this.ths()).getLeftPos() - 16 - maxWidth;
            this.alternativeWidth = maxWidth;
            int pages2 = this.alternativePages.size();
            if (pages2 > 1) {
                for (int i = 0; i < pages2; ++i) {
                    List<class_5348> page2 = this.alternativePages.get(i);
                    page2.add((class_5348)class_5244.field_41874);
                    page2.add((class_5348)class_2561.method_43469((String)"text.zenith.alternative_page", (Object[])new Object[]{i + 1, pages2}).method_27692(class_124.field_1063));
                }
            }
        }
    }

    protected int getSelectedAffix() {
        return this.list == null ? -1 : this.list.getSelected();
    }

    public static void handleRerollResult(DynamicHolder<? extends Affix> newAffix) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof AugmentingScreen) {
            AugmentingScreen scn = (AugmentingScreen)class_4372;
            scn.updateCachedState();
            for (int i = 0; i < scn.currentItemAffixes.size(); ++i) {
                AffixInstance inst = scn.currentItemAffixes.get(i);
                if (!inst.affix().equals(newAffix)) continue;
                scn.list.setSelected(i);
                return;
            }
        }
    }

    public class AffixDropList
    extends DropDownList<AffixInstance> {
        public AffixDropList(int x, int y, int width, int height, class_2561 narrationMsg, List<AffixInstance> entries, int maxDisplayedEntries) {
            super(x, y, width, height, narrationMsg, entries, maxDisplayedEntries);
        }

        @Override
        protected void method_48579(class_332 gfx, int mouseX, int mouseY, float partialTick) {
            gfx.method_51448().method_22903();
            gfx.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            if (this.entries.isEmpty()) {
                gfx.method_25290(TEXTURE, this.method_46426(), this.method_46427(), 0.0f, 267.0f, this.field_22758, this.baseHeight, 256, 307);
            }
            super.method_48579(gfx, mouseX, mouseY, partialTick);
            int hovered = this.getHoveredSlot(mouseX, mouseY);
            if (this.isOpen && hovered != -1) {
                AffixInstance inst = (AffixInstance)this.entries.get(hovered);
                ArrayList<class_5250> list = new ArrayList<class_5250>();
                list.add(inst.getName(true).method_27661().method_27696(class_2583.field_24360.method_36139(0xFFFF80).method_30938(Boolean.valueOf(true))));
                list.add(class_2561.method_43469((String)"%s", (Object[])new Object[]{inst.getAugmentingText()}).method_27692(class_124.field_1054));
                AugmentingScreen.this.drawOnLeft(gfx, list, AugmentingScreen.this.field_2800 + 33, 150);
            }
            gfx.method_25290(TEXTURE, this.method_46426() + this.field_22758 - 15, this.method_46427(), (float)(123 + (this.isOpen ? 15 : 0)), 239.0f, 15, 14, 256, 307);
            gfx.method_51448().method_22909();
        }

        @Override
        protected void renderEntry(class_332 gfx, int x, int y, int mouseX, int mouseY, AffixInstance entry) {
            int idx;
            int hovered = this.getHoveredSlot(mouseX, mouseY);
            gfx.method_25290(TEXTURE, x, y, 0.0f, (float)(239 + (hovered == (idx = this.entries.indexOf(entry)) ? this.baseHeight : 0)), this.field_22758, this.baseHeight, 256, 307);
            gfx.method_27535(AugmentingScreen.this.field_22793, entry.getName(true), x + 2, y + 3, 0xFFFF80);
        }
    }

    public class FatTexButton
    extends SimpleTexButton {
        protected final class_2561 costMsg;

        public FatTexButton(int x, int y, int width, int height, int u, int v, class_4185.class_4241 press, class_2561 message, class_2561 costMsg) {
            super(x, y, width, height, u, v, TEXTURE, 256, 307, press, message);
            this.costMsg = costMsg;
        }

        @Override
        public void method_48579(class_332 gfx, int pMouseX, int pMouseY, float pPartialTick) {
            int yTex = this.yTexStart - 2;
            if (!this.method_37303()) {
                yTex += this.field_22759 + 4;
            } else if (this.method_49606()) {
                yTex += (this.field_22759 + 4) * 2;
            }
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            gfx.method_25290(this.texture, this.method_46426() - 2, this.method_46427() - 2, (float)(this.xTexStart - 2), (float)yTex, this.field_22758 + 4, this.field_22759 + 4, this.textureWidth, this.textureHeight);
            if (this.method_49606()) {
                this.renderToolTip(gfx, pMouseX, pMouseY);
            }
        }

        @Override
        public void renderToolTip(class_332 gfx, int pMouseX, int pMouseY) {
            if (this.method_25369() != class_5244.field_39003 && this.method_49606()) {
                class_2561 primary = this.method_25369();
                if (!this.field_22763) {
                    primary = primary.method_27661().method_27692(class_124.field_1080);
                }
                ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
                tooltips.add(primary);
                if (this.method_37303()) {
                    tooltips.add(this.costMsg);
                } else if (this.inactiveMessage != class_5244.field_39003) {
                    tooltips.add(this.inactiveMessage);
                }
                gfx.method_51434(class_310.method_1551().field_1772, tooltips, pMouseX, pMouseY);
            }
        }

        public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
            if (this == AugmentingScreen.this.rerollBtn && this.method_37303() && this.method_49606()) {
                int change = pDelta < 0.0 ? 1 : -1;
                int page = AugmentingScreen.this.alternativePage;
                AugmentingScreen.this.alternativePage = page = Math.floorMod(page + change, AugmentingScreen.this.alternativePages.size());
                return true;
            }
            return super.method_25401(pMouseX, pMouseY, pDelta);
        }
    }

    public record FakeWidthComponent(int width) implements class_5684
    {
        public int method_32661() {
            return 9;
        }

        public int method_32664(class_327 pFont) {
            return this.width;
        }
    }
}

