/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.shadowsoffire.apotheosis.mixin.accessors.BaseSpawnerAccessor;
import dev.shadowsoffire.apotheosis.spawn.modifiers.SpawnerModifier;
import dev.shadowsoffire.apotheosis.spawn.modifiers.SpawnerStats;
import dev.shadowsoffire.apotheosis.spawn.spawner.IBaseSpawner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_179;
import net.minecraft.class_1917;
import net.minecraft.class_195;
import net.minecraft.class_2096;
import net.minecraft.class_2636;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;

public class ModifierTrigger
implements class_179<Instance> {
    private static final class_2960 ID = new class_2960("zenith", "spawner_modifier");
    private final Map<class_2985, Listeners> listeners = Maps.newHashMap();

    public class_2960 method_794() {
        return ID;
    }

    public void method_792(class_2985 playerAdvancementsIn, class_179.class_180<Instance> listener) {
        Listeners ModifierTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (ModifierTrigger$listeners == null) {
            ModifierTrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, ModifierTrigger$listeners);
        }
        ModifierTrigger$listeners.add(listener);
    }

    public void method_793(class_2985 playerAdvancementsIn, class_179.class_180<Instance> listener) {
        Listeners ModifierTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (ModifierTrigger$listeners != null) {
            ModifierTrigger$listeners.remove(listener);
            if (ModifierTrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void method_791(class_2985 playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance createInstance(JsonObject json, class_5257 conditionsParser) {
        class_2096.class_2100 minDelay = class_2096.class_2100.method_9056((JsonElement)json.get(SpawnerStats.MIN_DELAY.getId()));
        class_2096.class_2100 maxDelay = class_2096.class_2100.method_9056((JsonElement)json.get(SpawnerStats.MAX_DELAY.getId()));
        class_2096.class_2100 spawnCount = class_2096.class_2100.method_9056((JsonElement)json.get(SpawnerStats.SPAWN_COUNT.getId()));
        class_2096.class_2100 nearbyEnts = class_2096.class_2100.method_9056((JsonElement)json.get(SpawnerStats.MAX_NEARBY_ENTITIES.getId()));
        class_2096.class_2100 playerRange = class_2096.class_2100.method_9056((JsonElement)json.get(SpawnerStats.REQ_PLAYER_RANGE.getId()));
        class_2096.class_2100 spawnRange = class_2096.class_2100.method_9056((JsonElement)json.get(SpawnerStats.SPAWN_RANGE.getId()));
        Boolean ignorePlayers = json.has(SpawnerStats.IGNORE_PLAYERS.getId()) ? Boolean.valueOf(json.get(SpawnerStats.IGNORE_PLAYERS.getId()).getAsBoolean()) : null;
        Boolean ignoreConditions = json.has(SpawnerStats.IGNORE_CONDITIONS.getId()) ? Boolean.valueOf(json.get(SpawnerStats.IGNORE_CONDITIONS.getId()).getAsBoolean()) : null;
        Boolean redstone = json.has(SpawnerStats.REDSTONE_CONTROL.getId()) ? Boolean.valueOf(json.get(SpawnerStats.REDSTONE_CONTROL.getId()).getAsBoolean()) : null;
        Boolean ignoreLight = json.has(SpawnerStats.IGNORE_LIGHT.getId()) ? Boolean.valueOf(json.get(SpawnerStats.IGNORE_LIGHT.getId()).getAsBoolean()) : null;
        Boolean noAI = json.has(SpawnerStats.NO_AI.getId()) ? Boolean.valueOf(json.get(SpawnerStats.NO_AI.getId()).getAsBoolean()) : null;
        return new Instance(minDelay, maxDelay, spawnCount, nearbyEnts, playerRange, spawnRange, ignorePlayers, ignoreConditions, redstone, ignoreLight, noAI);
    }

    public void trigger(class_3222 player, class_2636 tile, SpawnerModifier modif) {
        Listeners ModifierTrigger$listeners = this.listeners.get(player.method_14236());
        if (ModifierTrigger$listeners != null) {
            ModifierTrigger$listeners.trigger(tile, modif);
        }
    }

    static class Listeners {
        private final class_2985 playerAdvancements;
        private final Set<class_179.class_180<Instance>> listeners = Sets.newHashSet();

        public Listeners(class_2985 playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(class_179.class_180<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(class_179.class_180<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(class_2636 tile, SpawnerModifier modif) {
            List list = null;
            for (class_179.class_180<Instance> listener : this.listeners) {
                if (!((Instance)listener.method_797()).test(tile, modif)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (class_179.class_180 listener1 : list) {
                    listener1.method_796(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends class_195 {
        private final class_2096.class_2100 minDelay;
        private final class_2096.class_2100 maxDelay;
        private final class_2096.class_2100 spawnCount;
        private final class_2096.class_2100 nearbyEnts;
        private final class_2096.class_2100 playerRange;
        private final class_2096.class_2100 spawnRange;
        private final Boolean ignorePlayers;
        private final Boolean ignoreConditions;
        private final Boolean redstone;
        private final Boolean ignoreLight;
        private final Boolean noAI;

        public Instance(class_2096.class_2100 minDelay, class_2096.class_2100 maxDelay, class_2096.class_2100 spawnCount, class_2096.class_2100 nearbyEnts, class_2096.class_2100 playerRange, class_2096.class_2100 spawnRange, Boolean ignorePlayers, Boolean ignoreConditions, Boolean redstone, Boolean ignoreLight, Boolean noAI) {
            super(ID, class_5258.field_24388);
            this.minDelay = minDelay;
            this.maxDelay = maxDelay;
            this.spawnCount = spawnCount;
            this.nearbyEnts = nearbyEnts;
            this.playerRange = playerRange;
            this.spawnRange = spawnRange;
            this.ignorePlayers = ignorePlayers;
            this.ignoreConditions = ignoreConditions;
            this.redstone = redstone;
            this.ignoreLight = ignoreLight;
            this.noAI = noAI;
        }

        public JsonObject method_807(class_5267 serializer) {
            return new JsonObject();
        }

        public boolean test(class_2636 tile, SpawnerModifier modif) {
            class_1917 logic = tile.method_11390();
            IBaseSpawner spwn = (IBaseSpawner)tile;
            if (!(this.minDelay.method_9054(((BaseSpawnerAccessor)logic).getMinSpawnDelay()) && this.maxDelay.method_9054(((BaseSpawnerAccessor)logic).getMaxSpawnDelay()) && this.spawnCount.method_9054(((BaseSpawnerAccessor)logic).getSpawnCount()) && this.nearbyEnts.method_9054(((BaseSpawnerAccessor)logic).getMaxNearbyEntities()))) {
                return false;
            }
            if (!this.playerRange.method_9054(((BaseSpawnerAccessor)logic).getRequiredPlayerRange())) {
                return false;
            }
            if (!this.spawnRange.method_9054(((BaseSpawnerAccessor)logic).getSpawnRange())) {
                return false;
            }
            if (this.ignorePlayers != null && spwn.zenith$getIgnorePlayers() != this.ignorePlayers.booleanValue()) {
                return false;
            }
            if (this.ignoreConditions != null && spwn.zenith$getIgnoresConditions() != this.ignoreConditions.booleanValue()) {
                return false;
            }
            if (this.redstone != null && spwn.zenith$getRedstoneControl() != this.redstone.booleanValue()) {
                return false;
            }
            if (this.ignoreLight != null && spwn.zenith$getIgnoreLight() != this.ignoreLight.booleanValue()) {
                return false;
            }
            return this.noAI == null || spwn.zenith$getNoAi() == this.noAI.booleanValue();
        }
    }
}

