/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class SelectQuestObjectScreen<T extends QuestObjectBase>
extends AbstractButtonListScreen {
    private final ConfigQuestObject<T> config;
    private final ConfigCallback callback;
    private Function<T, class_2561> formatter = ConfigQuestObject::formatEntry;

    public SelectQuestObjectScreen(ConfigQuestObject<T> config, ConfigCallback callback) {
        this.setTitle((class_2561)class_2561.method_43471((String)"ftbquests.gui.select_quest_object"));
        this.setHasSearchBox(true);
        this.showBottomPanel(false);
        this.showCloseButton(true);
        this.focus();
        this.setBorder(1, 1, 1);
        this.config = config;
        this.callback = callback;
    }

    public SelectQuestObjectScreen<T> withFormatter(@Nullable Function<T, class_2561> formatter) {
        this.formatter = Objects.requireNonNullElse(formatter, ConfigQuestObject::formatEntry);
        return this;
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return true;
        }
        return false;
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(graphics, theme, x, y, w, h);
        GuiHelper.drawHollowRect((class_332)graphics, (int)(((AbstractButtonListScreen.ButtonPanel)this.mainPanel).getX() - 1), (int)(((AbstractButtonListScreen.ButtonPanel)this.mainPanel).getY() - 1), (int)(((AbstractButtonListScreen.ButtonPanel)this.mainPanel).width + 2), (int)(((AbstractButtonListScreen.ButtonPanel)this.mainPanel).height + 2), (Color4I)Color4I.DARK_GRAY.withAlpha(40), (boolean)false);
    }

    public void addButtons(Panel panel) {
        ArrayList<QuestObjectBase> list = new ArrayList<QuestObjectBase>();
        ClientQuestFile file = ClientQuestFile.INSTANCE;
        for (QuestObjectBase objectBase : file.getAllObjects()) {
            QuestObject qo;
            if (!this.config.predicate.test(objectBase) || !file.canEdit() && objectBase instanceof QuestObject && !(qo = (QuestObject)objectBase).isSearchable(file.selfTeamData)) continue;
            list.add(objectBase);
        }
        list.sort((o1, o2) -> {
            int i = Integer.compare(o1.getObjectType().ordinal(), o2.getObjectType().ordinal());
            return i == 0 ? o1.getTitle().getString().compareToIgnoreCase(o2.getTitle().getString()) : i;
        });
        if (this.config.predicate.test(null)) {
            panel.add((Widget)new QuestObjectButton(this, panel, null));
        }
        for (QuestObjectBase objectBase : list) {
            panel.add((Widget)new QuestObjectButton(this, panel, objectBase));
        }
    }

    protected void doCancel() {
        this.callback.save(false);
    }

    protected void doAccept() {
        this.callback.save(true);
    }

    private static class QuestObjectButton
    extends SimpleTextButton {
        public final T object;
        final /* synthetic */ SelectQuestObjectScreen this$0;

        public QuestObjectButton(@Nullable Panel panel, T o) {
            this.this$0 = var1_1;
            super(panel, (class_2561)(o == null ? class_2561.method_43471((String)"ftbquests.null") : ((QuestObjectBase)o).getMutableTitle().method_27692(((QuestObjectBase)o).getObjectType().getColor())), (Icon)(o == null ? Color4I.empty() : ((QuestObjectBase)o).getIcon()));
            this.object = o;
            this.setSize(200, 14);
        }

        private void addObject(TooltipList list, QuestObjectBase o) {
            list.add((class_2561)QuestObjectType.NAME_MAP.getDisplayName((Object)o.getObjectType()).method_27661().method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)o.getMutableTitle().method_27692(o.getObjectType().getColor())));
        }

        public void addMouseOverText(TooltipList list) {
            if (this.object == null) {
                return;
            }
            list.add(((QuestObjectBase)this.object).getTitle());
            list.add((class_2561)class_2561.method_43470((String)"ID: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)((QuestObjectBase)this.object).toString()).method_27692(class_124.field_1063)));
            list.add((class_2561)class_2561.method_43470((String)"Type: ").method_27692(class_124.field_1080).method_10852((class_2561)QuestObjectType.NAME_MAP.getDisplayName((Object)((QuestObjectBase)this.object).getObjectType()).method_27661().method_27692(((QuestObjectBase)this.object).getObjectType().getColor())));
            Object t = this.object;
            if (t instanceof Quest) {
                Quest quest2 = (Quest)t;
                this.addObject(list, quest2.getChapter());
                this.addRewardTooltip(list, quest2);
            } else {
                t = this.object;
                if (t instanceof QuestLink) {
                    QuestLink link = (QuestLink)t;
                    link.getQuest().ifPresent(quest -> {
                        this.addObject(list, link.getChapter());
                        list.add((class_2561)class_2561.method_43469((String)"ftbquests.gui.linked_quest_id", (Object[])new Object[]{class_2561.method_43470((String)quest.getCodeString()).method_27692(class_124.field_1063)}).method_27692(class_124.field_1080));
                        this.addObject(list, quest.getChapter());
                    });
                } else {
                    t = this.object;
                    if (t instanceof Task) {
                        Task task = (Task)t;
                        quest = task.getQuest();
                        this.addObject(list, ((Quest)quest).getChapter());
                        this.addObject(list, (QuestObjectBase)quest);
                        this.addRewardTooltip(list, (Quest)quest);
                    } else {
                        quest = this.object;
                        if (quest instanceof Reward) {
                            Reward reward = (Reward)quest;
                            quest = reward.getQuest();
                            this.addObject(list, ((Quest)quest).getChapter());
                            this.addObject(list, (QuestObjectBase)quest);
                        } else {
                            t = this.object;
                            if (t instanceof RewardTable) {
                                RewardTable rewardTable = (RewardTable)t;
                                rewardTable.addMouseOverText(list, true, true);
                            }
                        }
                    }
                }
            }
        }

        private void addRewardTooltip(TooltipList list, Quest quest) {
            if (quest.getRewards().size() == 1) {
                this.addObject(list, quest.getRewards().stream().findFirst().orElseThrow());
            } else if (!quest.getRewards().isEmpty()) {
                list.add((class_2561)class_2561.method_43471((String)"ftbquests.rewards").method_27692(class_124.field_1080));
                for (Reward reward : quest.getRewards()) {
                    list.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)reward.getMutableTitle().method_27692(QuestObjectType.REWARD.getColor())));
                }
            }
        }

        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver) {
                Color4I.WHITE.withAlpha(30).draw(graphics, x, y, w, h);
            }
            Color4I.GRAY.withAlpha(40).draw(graphics, x, y + h, w, 1);
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            this.this$0.config.setCurrentValue(this.object);
            this.this$0.callback.save(true);
        }
    }
}

