/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1041;
import net.minecraft.class_1934;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import org.joml.Matrix4f;
import org.joml.Vector3i;
import toni.immersivemessages.ImmersiveFont;
import toni.immersivemessages.ImmersiveMessagesManager;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.util.ImmersiveColor;
import toni.lib.animation.Binding;
import toni.lib.animation.easing.EasingType;
import toni.lib.utils.PlatformUtils;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.LayoutCache;
import xyz.flirora.caxton.render.CaxtonTextRenderer;

public class OverlayRenderer {
    private static final float NANOSECONDS_PER_TICK = 5.0E7f;
    private static long lastTime = System.nanoTime();
    private static final ImmersiveColor theme = new ImmersiveColor(-267386864, true);
    public static float ticksSinceNoResult = 0.0f;
    private static ImmersiveMessage currentTooltip;
    private static class_2248 lastBlockHitResult;

    public static void renderOverlay(class_332 graphics, float delta, class_1041 window) {
        if (class_310.method_1551().method_1493()) {
            return;
        }
        long currentTime = System.nanoTime();
        float partialTicks = (float)(currentTime - lastTime) / 5.0E7f;
        lastTime = currentTime;
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842 || mc.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }
        if (mc.field_1724 == null || !mc.field_1724.method_18276()) {
            return;
        }
        Optional<class_304> sprint = Arrays.stream(class_310.method_1551().field_1690.field_1839).filter(key -> key.method_1431().equals("key.sprint")).findFirst();
        if (sprint.isEmpty() || !sprint.get().method_1434()) {
            return;
        }
        class_239 class_2392 = mc.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2392;
            class_2248 blockstate = class_310.method_1551().field_1687.method_8320(blockHitResult.method_17777()).method_26204();
            if (blockstate != lastBlockHitResult) {
                lastBlockHitResult = blockstate;
                currentTooltip = null;
            }
        } else {
            return;
        }
        if (lastBlockHitResult == null || lastBlockHitResult == class_2246.field_10124) {
            currentTooltip = null;
            return;
        }
        if (ImmersiveMessagesManager.hasTooltip()) {
            return;
        }
        if (currentTooltip == null) {
            currentTooltip = ImmersiveMessage.builder(900.0f, lastBlockHitResult.method_9518().getString()).subtext(0.5f, PlatformUtils.getModName((String)class_7923.field_41175.method_10221((Object)lastBlockHitResult).method_12836()), 10.0f, subtext -> subtext.font(ImmersiveFont.ROBOTO).italic().fadeIn(0.5f)).font(ImmersiveFont.NORSE).bold().size(1.5f).animation(builder -> builder.transition(Binding.yPos, 0.0f, 0.25f, 65.0f, 55.0f, EasingType.EaseOutCubic)).fadeIn(0.25f);
        }
        ticksSinceNoResult = 0.0f;
        OverlayRenderer.currentTooltip.animation.advancePlayhead(partialTicks / 20.0f);
        OverlayRenderer.currentTooltip.subtext.animation.advancePlayhead(partialTicks / 20.0f);
        ImmersiveMessagesManager.getRenderer().render(currentTooltip, graphics);
        ImmersiveMessagesManager.getRenderer().render(OverlayRenderer.currentTooltip.subtext, graphics);
    }

    public static void drawHoveringText(class_332 graphics, List<class_2561> textLines, float fade, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd) {
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        if (textLines.isEmpty()) {
            return;
        }
        RenderSystem.disableDepthTest();
        Vector3i size = OverlayRenderer.wrapText(textLines, maxTextWidth, line -> {
            CaxtonTextRenderer renderer = CaxtonTextRenderer.getInstance();
            CaxtonText text = CaxtonText.fromFormatted((class_5348)line, arg_0 -> ((CaxtonTextRenderer)renderer).getFontStorage(arg_0), (class_2583)line.method_10866(), (boolean)false, (boolean)renderer.rtl, (LayoutCache)renderer.getHandler().getCache());
            return (int)renderer.getHandler().getWidth(text);
        });
        graphics.method_51448().method_22903();
        Matrix4f mat = graphics.method_51448().method_23760().method_23761();
        int width = size.x;
        int height = size.y;
        int titleLinesCount = size.z;
        int xMaxL = 1;
        int xMinL = 0;
        int xMinR = width + 7;
        int xMaxR = width + 8;
        int yMaxT = 1;
        int yMinT = 0;
        int yMaxB = height + 8;
        int yMinB = height + 7;
        graphics.method_25296(xMaxL, yMinT, xMinR, yMaxT, backgroundColor, backgroundColor);
        graphics.method_25296(xMaxL, yMinB, xMinR, yMaxB, backgroundColor, backgroundColor);
        graphics.method_25296(xMaxL, yMaxT, xMinR, yMinB, backgroundColor, backgroundColor);
        graphics.method_25296(xMinL, yMaxT, xMaxL, yMinB, backgroundColor, backgroundColor);
        graphics.method_25296(xMinR, yMaxT, xMaxR, yMinB, backgroundColor, backgroundColor);
        graphics.method_25296(xMaxL, yMaxT + 1, xMaxL + 1, yMinB - 1, borderColorStart, borderColorEnd);
        graphics.method_25296(xMinR - 1, yMaxT + 1, xMinR, yMinB - 1, borderColorStart, borderColorEnd);
        graphics.method_25296(xMaxL, yMaxT, xMinR, yMaxT + 1, borderColorStart, borderColorStart);
        graphics.method_25296(xMaxL, height + 6, xMinR, yMinB, borderColorEnd, borderColorEnd);
        class_4597.class_4598 renderType = class_4597.method_22991((class_287)new class_287(512));
        graphics.method_51448().method_22904(0.0, 0.0, 1.0);
        int yOffset = 0;
        for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
            class_2561 line2 = textLines.get(lineNumber);
            if (line2 != null) {
                CaxtonTextRenderer renderer = CaxtonTextRenderer.getInstance();
                CaxtonText caxtonText = CaxtonText.fromFormatted((class_5348)line2, arg_0 -> ((CaxtonTextRenderer)renderer).getFontStorage(arg_0), (class_2583)line2.method_10866(), (boolean)false, (boolean)renderer.rtl, (LayoutCache)renderer.getHandler().getCache());
            }
            if (lineNumber + 1 == titleLinesCount) {
                yOffset += 2;
            }
            yOffset += 10;
        }
        renderType.method_22993();
        graphics.method_51448().method_22909();
        RenderSystem.enableDepthTest();
    }

    public static Vector3i wrapText(List<class_2561> textLines, int maxTextWidth, Function<class_2561, Integer> widthLookup) {
        class_310 mc = class_310.method_1551();
        int screenWidth = mc.method_22683().method_4486();
        class_327 font = mc.field_1772;
        int tooltipTextWidth = 0;
        for (class_2561 textLine : textLines) {
            int textLineWidth = widthLookup.apply(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        int titleLinesCount = 1;
        if (tooltipTextWidth + 4 > screenWidth / 2) {
            tooltipTextWidth = screenWidth / 2;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<class_5250> wrappedTextLines = new ArrayList<class_5250>();
            for (int i = 0; i < textLines.size(); ++i) {
                class_2561 textLine = textLines.get(i);
                List wrappedLine = font.method_27527().method_27495((class_5348)textLine, tooltipTextWidth, class_2583.field_24360);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (class_5348 line : wrappedLine) {
                    class_5250 component = class_2561.method_43470((String)line.getString()).method_27696(textLine.method_10866());
                    int lineWidth = widthLookup.apply((class_2561)component);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(component);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines.clear();
            textLines.addAll(wrappedTextLines);
        }
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        return new Vector3i(tooltipTextWidth, tooltipHeight, titleLinesCount);
    }
}

