/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs.hexcasting.hexal;

import at.petrak.hexcasting.api.casting.iota.GarbageIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.lib.HexItems;
import com.samsthenerd.duckyperiphs.hexcasting.hexal.DuckyHexal;
import com.samsthenerd.duckyperiphs.hexcasting.hexal.FocalLinkBlockEntity;
import com.samsthenerd.duckyperiphs.hexcasting.hexal.ItemRGBColorizer;
import com.samsthenerd.duckyperiphs.hexcasting.utils.IotaLuaUtils;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import ram.talia.hexal.api.linkable.ILinkable;

public class FocalLinkPeripheral
implements IPeripheral {
    private final FocalLinkBlockEntity flTile;
    public List<IComputerAccess> computers = new ArrayList<IComputerAccess>();

    FocalLinkPeripheral(FocalLinkBlockEntity _flTile) {
        this.flTile = _flTile;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Nonnull
    public String getType() {
        return "focal_link";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult receiveIota() {
        Iota iota = this.flTile.nextReceivedIota();
        return MethodResult.of((Object)IotaLuaUtils.getLuaObject(iota, (class_3218)this.flTile.method_10997()));
    }

    @LuaFunction
    public final void clearReceivedIotas() {
        this.flTile.clearReceivedIotas();
    }

    @LuaFunction
    public final MethodResult remainingIotaCount() {
        return MethodResult.of((Object)this.flTile.numRemainingIota());
    }

    @LuaFunction
    public final MethodResult numLinked() {
        return MethodResult.of((Object)this.flTile.numLinked());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getLinked() {
        ArrayList<Object> ourLinks = new ArrayList<Object>();
        for (int i = 0; i < this.flTile.numLinked(); ++i) {
            ILinkable link = this.flTile.getLinked(i);
            if (link == null) {
                ourLinks.add("null");
                continue;
            }
            List linkText = link.transmittingTargetReturnDisplay();
            for (class_2561 t : linkText) {
                ourLinks.add(t.getString() + " ");
            }
        }
        return MethodResult.of(ourLinks);
    }

    @LuaFunction(mainThread=true)
    public final void unlink(int index) {
        this.flTile.unlink(index);
    }

    @LuaFunction(mainThread=true)
    public final void sendIota(int index, Object luaObject) {
        Iota iota = IotaLuaUtils.getIota(luaObject, (class_3218)this.flTile.method_10997());
        if (iota == null) {
            iota = new GarbageIota();
        }
        this.flTile.sendIota(index, iota);
    }

    public void receivedIota() {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("received_iota", new Object[]{computer.getAttachmentName()});
        }
    }

    public void receivedIota(Iota iota) {
        Object luaObject = IotaLuaUtils.getLuaObject(iota, (class_3218)this.flTile.method_10997());
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("received_iota", new Object[]{luaObject, computer.getAttachmentName()});
        }
    }

    @LuaFunction(mainThread=true)
    public final void setPigmentRGB(int argb) {
        this.flTile.setRGBColorizer(argb);
    }

    @LuaFunction
    public final MethodResult getPigment() {
        FrozenPigment col = this.flTile.pigment();
        class_2960 id = class_7923.field_41178.method_10221((Object)col.item().method_7909());
        Object idString = id.toString();
        if (col.item().method_7909() == DuckyHexal.ITEM_RGB_COLORIZER) {
            idString = "rgb:" + this.getPigmentRGB();
        }
        if (col.item().method_7909() == HexItems.UUID_PIGMENT) {
            idString = "soulglimmer:" + col.owner().toString();
        }
        return MethodResult.of((Object)idString);
    }

    @LuaFunction
    public final MethodResult getPigmentRGB() {
        FrozenPigment col = this.flTile.pigment();
        int rgb = ItemRGBColorizer.getRGB(col.item());
        return MethodResult.of((Object)rgb);
    }

    public void newColorizer() {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("new_pigment", new Object[]{computer.getAttachmentName()});
        }
    }
}

