/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.duckyperiphs;

import com.google.common.base.Suppliers;
import com.samsthenerd.duckyperiphs.DPRecipeSerializer;
import com.samsthenerd.duckyperiphs.ducks.DuckBlock;
import com.samsthenerd.duckyperiphs.ducks.DuckBlockEntity;
import com.samsthenerd.duckyperiphs.ducks.DuckItem;
import com.samsthenerd.duckyperiphs.hexcasting.DuckyCasting;
import com.samsthenerd.duckyperiphs.hexcasting.DummyNoHex;
import com.samsthenerd.duckyperiphs.misc.DuckyBanners;
import com.samsthenerd.duckyperiphs.peripherals.EntityDetector.EntityDetectorBlock;
import com.samsthenerd.duckyperiphs.peripherals.EntityDetector.EntityDetectorTile;
import com.samsthenerd.duckyperiphs.peripherals.WeatherMachine.WeatherMachineBlock;
import com.samsthenerd.duckyperiphs.peripherals.WeatherMachine.WeatherMachineTile;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardBlock;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardItem;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardScreenHandler;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardTile;
import com.samsthenerd.duckyperiphs.peripherals.keyboards.KeyboardUtils;
import com.samsthenerd.duckyperiphs.peripherals.sculkophone.SculkophoneBlock;
import com.samsthenerd.duckyperiphs.peripherals.sculkophone.SculkophoneBlockEntity;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1745;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_39;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuckyPeriphs {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ducky-periphs");
    public static final String MOD_ID = "ducky-periphs";
    public static final Supplier<RegistrarManager> REGISTRIES = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static DeferredRegister<class_1792> items = DeferredRegister.create((String)"ducky-periphs", (class_5321)class_7924.field_41197);
    public static DeferredRegister<class_2248> blocks = DeferredRegister.create((String)"ducky-periphs", (class_5321)class_7924.field_41254);
    public static Map<RegistrySupplier<? extends class_2248>, class_1792.class_1793> blockItems = new HashMap<RegistrySupplier<? extends class_2248>, class_1792.class_1793>();
    public static DeferredRegister<class_2591<?>> blockEntities = DeferredRegister.create((String)"ducky-periphs", (class_5321)class_7924.field_41255);
    public static DeferredRegister<class_1299<?>> entities = DeferredRegister.create((String)"ducky-periphs", (class_5321)class_7924.field_41266);
    public static final DeferredRegister<class_3414> sounds = DeferredRegister.create((String)"ducky-periphs", (class_5321)class_7924.field_41225);
    public static final DeferredRegister<class_5712> gameEvents = DeferredRegister.create((String)"ducky-periphs", (class_5321)class_7924.field_41273);
    public static final DeferredRegister<class_3917<?>> screenHandlers = DeferredRegister.create((String)"ducky-periphs", (class_5321)class_7924.field_41207);
    public static final DeferredRegister<class_1761> TABS = DeferredRegister.create((String)"ducky-periphs", (class_5321)class_7924.field_44688);
    public static final RegistrySupplier<class_1761> CC_PERIPHS_GROUP = TABS.register("test_tab", () -> CreativeTabRegistry.create((class_2561)class_2561.method_43471((String)"itemGroup.ducky-periphs.general"), () -> new class_1799((class_1935)DUCK_ITEM.get())));
    public static RegistrySupplier<WeatherMachineBlock> WEATHER_MACHINE_BLOCK = DuckyPeriphs.blockItem("weather_machine_block", () -> new WeatherMachineBlock(DuckyPeriphs.peripheralBlockSettings()));
    public static RegistrySupplier<class_2591<WeatherMachineTile>> WEATHER_MACHINE_TILE = blockEntities.register(new class_2960("ducky-periphs", "weather_machine_tile"), () -> class_2591.class_2592.method_20528(WeatherMachineTile::new, (class_2248[])new class_2248[]{(class_2248)WEATHER_MACHINE_BLOCK.get()}).method_11034(null));
    public static final RegistrySupplier<EntityDetectorBlock> ENTITY_DETECTOR_BLOCK = DuckyPeriphs.blockItem("entity_detector_block", () -> new EntityDetectorBlock(DuckyPeriphs.peripheralBlockSettings()));
    public static RegistrySupplier<class_2591<EntityDetectorTile>> ENTITY_DETECTOR_TILE = blockEntities.register(new class_2960("ducky-periphs", "entity_detector_tile"), () -> class_2591.class_2592.method_20528(EntityDetectorTile::new, (class_2248[])new class_2248[]{(class_2248)ENTITY_DETECTOR_BLOCK.get()}).method_11034(null));
    public static final RegistrySupplier<KeyboardBlock> KEYBOARD_BLOCK = DuckyPeriphs.blockNoItem("keyboard_block", () -> new KeyboardBlock(DuckyPeriphs.peripheralBlockSettings().method_36557(0.7f)));
    public static RegistrySupplier<class_2591<KeyboardTile>> KEYBOARD_TILE = blockEntities.register(new class_2960("ducky-periphs", "keyboard_tile"), () -> class_2591.class_2592.method_20528(KeyboardTile::new, (class_2248[])new class_2248[]{(class_2248)KEYBOARD_BLOCK.get()}).method_11034(null));
    public static final RegistrySupplier<KeyboardItem> KEYBOARD_ITEM = DuckyPeriphs.item("keyboard_block", () -> new KeyboardItem((class_2248)KEYBOARD_BLOCK.get(), new class_1792.class_1793().arch$tab(CC_PERIPHS_GROUP)));
    public static final class_3917<KeyboardScreenHandler> KEYBOARD_SCREEN_HANDLER = MenuRegistry.ofExtended(KeyboardScreenHandler::new);
    public static final class_2960 KEYBOARD_PRESS_PACKET_ID = new class_2960("ducky-periphs", "keyboard_press");
    public static final RegistrySupplier<DuckBlock> DUCK_BLOCK = DuckyPeriphs.blockNoItem("duck_block", () -> new DuckBlock(class_4970.class_2251.method_9637().method_36557(0.2f)));
    public static RegistrySupplier<class_2591<DuckBlockEntity>> DUCK_BLOCK_ENTITY = blockEntities.register(new class_2960("ducky-periphs", "duck_block_entity"), () -> class_2591.class_2592.method_20528(DuckBlockEntity::new, (class_2248[])new class_2248[]{(class_2248)DUCK_BLOCK.get()}).method_11034(null));
    public static final RegistrySupplier<DuckItem> DUCK_ITEM = DuckyPeriphs.item("duck_block", () -> new DuckItem((class_2248)DUCK_BLOCK.get(), DuckyPeriphs.dpItemSettings()));
    public static RegistrySupplier<class_3414> QUACK_SOUND_EVENT = DuckyPeriphs.soundEvent("quack");
    public static RegistrySupplier<class_5712> QUACK_GAME_EVENT = DuckyPeriphs.gameEvent("quack", 16);
    public static final RegistrySupplier<SculkophoneBlock> SCULKOPHONE_BLOCK = DuckyPeriphs.blockItem("sculkophone_block", () -> new SculkophoneBlock(DuckyPeriphs.peripheralBlockSettings().method_36557(0.7f)));
    public static RegistrySupplier<class_2591<SculkophoneBlockEntity>> SCULKOPHONE_BLOCK_ENTITY = blockEntities.register("sculkophone_block_entity", () -> class_2591.class_2592.method_20528(SculkophoneBlockEntity::new, (class_2248[])new class_2248[]{(class_2248)SCULKOPHONE_BLOCK.get()}).method_11034(null));
    public static RegistrySupplier<class_3414> SCULKOPHONE_CLICKING_EVENT = DuckyPeriphs.soundEvent("sculkophone_clicking");
    public static RegistrySupplier<class_3414> SCULKOPHONE_CLICKING_STOP_EVENT = DuckyPeriphs.soundEvent("sculkophone_clicking_stop");
    public static final RegistrySupplier<class_1745> DUCKY_PATTERN_ITEM = DuckyPeriphs.item("ducky_banner_pattern", () -> new class_1745(DuckyBanners.DUCKY_PATTERN_ITEM_KEY, new class_1792.class_1793().method_7889(1).arch$tab((class_1761)class_7923.field_44687.method_10223(new class_2960("ingredients")))));
    public static final class_2960 keyboardLootTable = new class_2960("ducky-periphs", "chests/keyboards");

    public static final void logPrint(String message) {
        if (Platform.isDevelopmentEnvironment()) {
            LOGGER.info(message);
        }
    }

    public static void onInitialize() {
        DuckyPeriphs.setupNetworkStuff();
        DuckyPeriphs.setupMisc();
        DPRecipeSerializer.init();
        if (Platform.isModLoaded((String)"hexcasting")) {
            DuckyCasting.init();
        } else {
            DummyNoHex.init();
        }
        blocks.register();
        blockItems.forEach((block, itemprops) -> items.register(block.getId(), () -> new class_1747((class_2248)block.get(), itemprops)));
        items.register();
        blockEntities.register();
        entities.register();
        sounds.register();
        gameEvents.register();
        screenHandlers.register();
        TABS.register();
        DuckyBanners.registerBannerPatterns();
    }

    private static void setupNetworkStuff() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)new class_2960(MOD_ID, "key_press_packet"), (buf, context) -> KeyboardUtils.keyPressHandler(buf, context));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)new class_2960(MOD_ID, "key_up_packet"), (buf, context) -> KeyboardUtils.keyUpHandler(buf, context));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)new class_2960(MOD_ID, "char_typed_packet"), (buf, context) -> KeyboardUtils.charTypedHandler(buf, context));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)new class_2960(MOD_ID, "event_sent_packet"), (buf, context) -> KeyboardUtils.eventShortcutHandler(buf, context));
    }

    private static void setupMisc() {
        screenHandlers.register(new class_2960(MOD_ID, "keyboard_screen_handler"), () -> KEYBOARD_SCREEN_HANDLER);
    }

    private static class_4970.class_2251 peripheralBlockSettings() {
        return class_4970.class_2251.method_9637().method_36557(1.3f);
    }

    private static class_1792.class_1793 dpItemSettings() {
        return new class_1792.class_1793().arch$tab(CC_PERIPHS_GROUP);
    }

    public static <T extends class_2248> RegistrySupplier<T> blockNoItem(String name, Supplier<T> block) {
        return blocks.register(new class_2960(MOD_ID, name), block);
    }

    public static <T extends class_1792> RegistrySupplier<T> item(String name, Supplier<T> item) {
        return items.register(new class_2960(MOD_ID, name), item);
    }

    public static <T extends class_2248> RegistrySupplier<T> blockItem(String name, Supplier<T> block) {
        return DuckyPeriphs.blockItem(name, block, DuckyPeriphs.dpItemSettings());
    }

    public static <T extends class_2248> RegistrySupplier<T> blockItem(String name, Supplier<T> block, class_1792.class_1793 props) {
        RegistrySupplier<T> blockRegistered = DuckyPeriphs.blockNoItem(name, block);
        blockItems.put(blockRegistered, props);
        return blockRegistered;
    }

    public static RegistrySupplier<class_3414> soundEvent(String id) {
        return sounds.register(new class_2960(MOD_ID, id), () -> class_3414.method_47908((class_2960)new class_2960(MOD_ID, id)));
    }

    public static RegistrySupplier<class_5712> gameEvent(String id, int range) {
        return gameEvents.register(new class_2960(MOD_ID, id), () -> new class_5712(new class_2960(MOD_ID, id).toString(), range));
    }

    public static boolean shouldAddKeyboards(class_2960 id, boolean builtin) {
        return builtin && (class_39.field_356.equals((Object)id) || class_39.field_472.equals((Object)id) || class_39.field_885.equals((Object)id) || class_39.field_484.equals((Object)id) || class_39.field_803.equals((Object)id));
    }
}

