/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.GeneralConfig;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.util.PointSources;

public class CategoryData {
    private final Set<String> unlockedSkills;
    private final Map<class_2960, Integer> points;
    private boolean unlocked;
    private int experience;

    private CategoryData(Set<String> unlockedSkills, Map<class_2960, Integer> points, boolean unlocked, int experience) {
        this.unlockedSkills = unlockedSkills;
        this.points = points;
        this.unlocked = unlocked;
        this.experience = experience;
    }

    public static CategoryData create(GeneralConfig general) {
        HashMap<class_2960, Integer> points = new HashMap<class_2960, Integer>();
        points.put(PointSources.STARTING, general.getStartingPoints());
        return new CategoryData(new HashSet<String>(), points, general.isUnlockedByDefault(), 0);
    }

    public static CategoryData read(class_2487 nbt) {
        boolean unlocked = nbt.method_10577("unlocked");
        int experience = nbt.method_10550("experience");
        HashSet<String> unlockedSkills = new HashSet<String>();
        class_2499 unlockedNbt = nbt.method_10554("unlocked_skills", 8);
        for (class_2520 elementNbt : unlockedNbt) {
            if (!(elementNbt instanceof class_2519)) continue;
            class_2519 stringNbt = (class_2519)elementNbt;
            unlockedSkills.add(stringNbt.method_10714());
        }
        HashMap<class_2960, Integer> points = new HashMap<class_2960, Integer>();
        class_2520 pointsNbt = nbt.method_10580("points");
        if (pointsNbt instanceof class_2497) {
            class_2497 pointsNbtInt = (class_2497)pointsNbt;
            points.put(PointSources.LEGACY, pointsNbtInt.method_10701());
        } else if (pointsNbt instanceof class_2487) {
            class_2487 pointsNbtCompound = (class_2487)pointsNbt;
            for (String key : pointsNbtCompound.method_10541()) {
                points.put(new class_2960(key), pointsNbtCompound.method_10550(key));
            }
        }
        return new CategoryData(unlockedSkills, points, unlocked, experience);
    }

    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10556("unlocked", this.unlocked);
        nbt.method_10569("experience", this.experience);
        class_2499 unlockedNbt = new class_2499();
        for (String skill : this.unlockedSkills) {
            unlockedNbt.add((Object)class_2519.method_23256((String)skill));
        }
        nbt.method_10566("unlocked_skills", (class_2520)unlockedNbt);
        class_2487 pointsNbt = new class_2487();
        for (Map.Entry<class_2960, Integer> entry : this.points.entrySet()) {
            if (entry.getValue() == 0) continue;
            pointsNbt.method_10569(entry.getKey().toString(), entry.getValue().intValue());
        }
        nbt.method_10566("points", (class_2520)pointsNbt);
        return nbt;
    }

    public Skill.State getSkillState(CategoryConfig category, SkillConfig skill, SkillDefinitionConfig definition) {
        if (this.unlockedSkills.contains(skill.getId())) {
            return Skill.State.UNLOCKED;
        }
        if (category.getConnections().getExclusive().getNeighborsFor(skill.getId()).map(neighbors -> neighbors.stream().filter(this.unlockedSkills::contains).count()).orElse(0L) >= (long)definition.getRequiredExclusions()) {
            return Skill.State.EXCLUDED;
        }
        if (category.getConnections().getNormal().getNeighborsFor(skill.getId()).map(neighbors -> neighbors.stream().filter(this.unlockedSkills::contains).count()).orElse(0L) >= (long)definition.getRequiredSkills()) {
            return this.canAfford(category, definition) ? Skill.State.AFFORDABLE : Skill.State.AVAILABLE;
        }
        if (skill.isRoot()) {
            if (category.getGeneral().isExclusiveRoot() && this.unlockedSkills.stream().flatMap(skillId -> category.getSkills().getById((String)skillId).stream()).anyMatch(SkillConfig::isRoot)) {
                return Skill.State.LOCKED;
            }
            return this.canAfford(category, definition) ? Skill.State.AFFORDABLE : Skill.State.AVAILABLE;
        }
        return Skill.State.LOCKED;
    }

    private boolean canAfford(CategoryConfig category, SkillDefinitionConfig definition) {
        return this.getPointsLeft(category) >= Math.max(definition.getRequiredPoints(), definition.getCost()) && this.getSpentPoints(category) >= definition.getRequiredSpentPoints();
    }

    public boolean canUnlockSkill(CategoryConfig category, SkillConfig skill) {
        String definitionId = skill.getDefinitionId();
        return category.getDefinitions().getById(definitionId).map(definition -> this.getSkillState(category, skill, (SkillDefinitionConfig)definition) == Skill.State.AFFORDABLE).orElse(false);
    }

    public int countUnlocked(CategoryConfig category, String definitionId) {
        return category.getDefinitions().getById(definitionId).map(definition -> category.getSkills().getAll().stream().filter(skill -> skill.getDefinitionId().equals(definitionId)).filter(skill -> this.getSkillState(category, (SkillConfig)skill, (SkillDefinitionConfig)definition) == Skill.State.UNLOCKED).count()).orElse(0L).intValue();
    }

    public void unlockSkill(String id) {
        this.unlockedSkills.add(id);
    }

    public void lockSkill(String id) {
        this.unlockedSkills.remove(id);
    }

    public void resetSkills() {
        this.unlockedSkills.clear();
    }

    public Set<String> getUnlockedSkillIds() {
        return this.unlockedSkills;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int earnedExperience) {
        this.experience = earnedExperience;
    }

    public int getSpentPoints(CategoryConfig category) {
        return this.unlockedSkills.stream().flatMap(skillId -> category.getSkills().getById((String)skillId).flatMap(skill -> category.getDefinitions().getById(skill.getDefinitionId())).stream()).mapToInt(SkillDefinitionConfig::getCost).sum();
    }

    public int getPointsTotal() {
        int total = 0;
        for (Integer count : this.points.values()) {
            total += count.intValue();
        }
        return total;
    }

    public int getPointsLeft(CategoryConfig category) {
        return Math.min(this.getPointsTotal(), category.getGeneral().getSpentPointsLimit()) - this.getSpentPoints(category);
    }

    public int getPoints(class_2960 source) {
        return this.points.getOrDefault(source, 0);
    }

    public void setPoints(class_2960 source, int points) {
        this.points.put(source, points);
    }

    public Stream<class_2960> getPointsSources() {
        return this.points.entrySet().stream().filter(e -> (Integer)e.getValue() != 0).map(Map.Entry::getKey);
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public void unlock() {
        this.unlocked = true;
    }

    public void lock() {
        this.unlocked = false;
    }
}

