/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.experience;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.experience.ExperiencePerLevelConfig;
import net.puffish.skillsmod.config.experience.ExperienceSourceConfig;
import net.puffish.skillsmod.experience.ExperienceCurve;
import net.puffish.skillsmod.util.DisposeContext;
import net.puffish.skillsmod.util.LegacyUtils;

public class ExperienceConfig {
    private final ExperienceCurve experienceCurve;
    private final List<ExperienceSourceConfig> experienceSources;

    private ExperienceConfig(ExperienceCurve experienceCurve, List<ExperienceSourceConfig> experienceSources) {
        this.experienceCurve = experienceCurve;
        this.experienceSources = experienceSources;
    }

    public static Result<Optional<ExperienceConfig>, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> ExperienceConfig.parse(rootObject, context), context));
    }

    public static Result<Optional<ExperienceConfig>, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Boolean enabled = LegacyUtils.deprecated(() -> rootObject.getBoolean("enabled"), 3, context).orElse(true);
        Integer levelLimit = rootObject.get("level_limit").getSuccess().flatMap(element -> element.getAsInt().ifFailure(problems::add).getSuccess()).orElse(Integer.MAX_VALUE);
        Optional optExperiencePerLevel = rootObject.get("experience_per_level").andThen(element -> ExperiencePerLevelConfig.parse(element, context)).ifFailure(problems::add).getSuccess();
        List experienceSources = rootObject.getArray("sources").andThen(array -> array.getAsList((i, element) -> ExperienceSourceConfig.parse(element, context)).mapFailure(Problem::combine)).ifFailure(problems::add).getSuccess().orElseGet(List::of);
        if (problems.isEmpty()) {
            if (enabled.booleanValue()) {
                return Result.success(Optional.of(new ExperienceConfig(ExperienceCurve.create(((ExperiencePerLevelConfig)optExperiencePerLevel.orElseThrow()).getFunction(), levelLimit), experienceSources)));
            }
            return Result.success(Optional.empty());
        }
        return Result.failure(Problem.combine(problems));
    }

    public void dispose(DisposeContext context) {
        for (ExperienceSourceConfig experienceSource : this.experienceSources) {
            experienceSource.dispose(context);
        }
    }

    public ExperienceCurve getCurve() {
        return this.experienceCurve;
    }

    public List<ExperienceSourceConfig> getExperienceSources() {
        return this.experienceSources;
    }
}

