/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.Config;
import net.puffish.skillsmod.util.LegacyUtils;

public class PackConfig
implements Config {
    private final int version;
    private final List<String> categories;

    private PackConfig(int version, List<String> categories) {
        this.version = version;
        this.categories = categories;
    }

    public static Result<PackConfig, Problem> parse(String name, JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnusedConfig(rootObject -> PackConfig.parse(name, rootObject, context), context));
    }

    private static Result<PackConfig, Problem> parse(String name, JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<Integer> optVersion = rootObject.getInt("version").ifFailure(problems::add).getSuccess();
        Optional optCategories = rootObject.getArray("categories").andThen(array -> array.getAsList((i, element) -> BuiltinJson.parseIdentifierPath(element)).mapFailure(Problem::combine)).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            int version = optVersion.orElseThrow();
            if (version < 1) {
                return Result.failure(Problem.message("Data pack `" + name + "` is outdated. Check out the mod's wiki to learn how to update the data pack."));
            }
            if (version > 3) {
                return Result.failure(Problem.message("Data pack `" + name + "` is for a newer version of the mod. Please update the mod."));
            }
            if (version < 3) {
                context.emitWarning(rootObject.getPath().getObject("version").createProblem("Data pack `" + name + "` uses outdated version. Please update the configuration version to 3").toString());
            }
            return Result.success(new PackConfig(version, (List)optCategories.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }
}

