/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.client.data.ClientCategoryData;
import net.puffish.skillsmod.client.event.ClientEventListener;
import net.puffish.skillsmod.client.event.ClientEventReceiver;
import net.puffish.skillsmod.client.gui.SimpleToast;
import net.puffish.skillsmod.client.gui.SkillsScreen;
import net.puffish.skillsmod.client.keybinding.KeyBindingReceiver;
import net.puffish.skillsmod.client.network.ClientPacketSender;
import net.puffish.skillsmod.client.network.packets.in.ExperienceUpdateInPacket;
import net.puffish.skillsmod.client.network.packets.in.HideCategoryInPacket;
import net.puffish.skillsmod.client.network.packets.in.NewPointInPacket;
import net.puffish.skillsmod.client.network.packets.in.OpenScreenInPacket;
import net.puffish.skillsmod.client.network.packets.in.PointsUpdateInPacket;
import net.puffish.skillsmod.client.network.packets.in.ShowCategoryInPacket;
import net.puffish.skillsmod.client.network.packets.in.ShowToastInPacket;
import net.puffish.skillsmod.client.network.packets.in.SkillUpdateInPacket;
import net.puffish.skillsmod.client.setup.ClientRegistrar;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.util.ToastType;

public class SkillsClientMod {
    public static final class_304 OPEN_KEY_BINDING = new class_304("key.puffish_skills.open", class_3675.class_307.field_1668, 75, "category.puffish_skills.skills");
    private static SkillsClientMod instance;
    private final Map<class_2960, ClientCategoryData> categories = new LinkedHashMap<class_2960, ClientCategoryData>();
    private final ClientPacketSender packetSender;

    private SkillsClientMod(ClientPacketSender packetSender) {
        this.packetSender = packetSender;
    }

    public static SkillsClientMod getInstance() {
        return instance;
    }

    public static void setup(ClientRegistrar registrar, ClientEventReceiver eventReceiver, KeyBindingReceiver keyBindingReceiver, ClientPacketSender packetSender) {
        instance = new SkillsClientMod(packetSender);
        keyBindingReceiver.registerKeyBinding(OPEN_KEY_BINDING, instance::onOpenKeyPress);
        registrar.registerInPacket(Packets.SHOW_CATEGORY, ShowCategoryInPacket::read, instance::onShowCategory);
        registrar.registerInPacket(Packets.HIDE_CATEGORY, HideCategoryInPacket::read, instance::onHideCategory);
        registrar.registerInPacket(Packets.SKILL_UPDATE, SkillUpdateInPacket::read, instance::onSkillUpdatePacket);
        registrar.registerInPacket(Packets.POINTS_UPDATE, PointsUpdateInPacket::read, instance::onPointsUpdatePacket);
        registrar.registerInPacket(Packets.EXPERIENCE_UPDATE, ExperienceUpdateInPacket::read, instance::onExperienceUpdatePacket);
        registrar.registerInPacket(Packets.SHOW_TOAST, ShowToastInPacket::read, instance::onShowToast);
        registrar.registerInPacket(Packets.OPEN_SCREEN, OpenScreenInPacket::read, instance::onOpenScreenPacket);
        registrar.registerInPacket(Packets.NEW_POINT, NewPointInPacket::read, instance::onNewPointPacket);
        registrar.registerOutPacket(Packets.SKILL_CLICK);
        eventReceiver.registerListener(instance.new EventListener());
    }

    private void onOpenKeyPress() {
        this.openScreen(Optional.empty());
    }

    private void onShowCategory(ShowCategoryInPacket packet) {
        ClientCategoryData category = packet.getCategory();
        this.categories.put(category.getConfig().id(), category);
    }

    private void onHideCategory(HideCategoryInPacket packet) {
        this.categories.remove(packet.getCategoryId());
    }

    private void onSkillUpdatePacket(SkillUpdateInPacket packet) {
        this.getCategoryById(packet.getCategoryId()).ifPresent(category -> {
            if (packet.isUnlocked()) {
                category.unlock(packet.getSkillId());
            } else {
                category.lock(packet.getSkillId());
            }
        });
    }

    private void onExperienceUpdatePacket(ExperienceUpdateInPacket packet) {
        this.getCategoryById(packet.getCategoryId()).ifPresent(category -> {
            category.setCurrentLevel(packet.getCurrentLevel());
            category.setCurrentExperience(packet.getCurrentExperience());
            category.setRequiredExperience(packet.getRequiredExperience());
        });
    }

    private void onPointsUpdatePacket(PointsUpdateInPacket packet) {
        this.getCategoryById(packet.getCategoryId()).ifPresent(category -> category.updatePoints(packet.getSpentPoints(), packet.getEarnedPoints()));
    }

    private void onNewPointPacket(NewPointInPacket packet) {
        this.getCategoryById(packet.getCategoryId()).ifPresent(category -> {
            if (category.hasAnySkillLeft()) {
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)SkillsMod.createTranslatable("chat", "new_point", OPEN_KEY_BINDING.method_16007()));
            }
        });
    }

    private void onOpenScreenPacket(OpenScreenInPacket packet) {
        this.openScreen(packet.getCategoryId());
    }

    private void onShowToast(ShowToastInPacket packet) {
        class_310 client = class_310.method_1551();
        class_374 class_3742 = client.method_1566();
        class_5250 class_52502 = class_2561.method_43470((String)"Pufferfish's Skills");
        class_3742.method_1999((class_368)SimpleToast.create(client, (class_2561)class_52502, (class_2561)SkillsMod.createTranslatable("toast", (switch (packet.getToastType()) {
            default -> throw new IncompatibleClassChangeError();
            case ToastType.INVALID_CONFIG -> "invalid_config";
            case ToastType.MISSING_CONFIG -> "missing_config";
        }) + ".description", new Object[0])));
    }

    public void openScreen(Optional<class_2960> categoryId) {
        class_310.method_1551().method_1507((class_437)new SkillsScreen(this.categories, categoryId));
    }

    private Optional<ClientCategoryData> getCategoryById(class_2960 categoryId) {
        return Optional.ofNullable(this.categories.get(categoryId));
    }

    public ClientPacketSender getPacketSender() {
        return this.packetSender;
    }

    private class EventListener
    implements ClientEventListener {
        private EventListener() {
        }

        @Override
        public void onPlayerJoin() {
            SkillsClientMod.this.categories.clear();
        }
    }
}

