/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.stacks.AEItemKey;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGATags;
import gripe._90.megacells.misc.CompressionChain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class CompressionService {
    public static final CompressionService INSTANCE = new CompressionService();
    private final Set<CompressionChain> compressionChains = new HashSet<CompressionChain>();
    private final Set<Override> overrides = new HashSet<Override>();

    private CompressionService() {
    }

    public Optional<CompressionChain> getChain(AEItemKey item) {
        return this.compressionChains.stream().filter(chain -> chain.containsVariant(item)).findFirst();
    }

    public void loadRecipes(class_1863 recipeManager, class_5455 access) {
        this.compressionChains.clear();
        this.overrides.clear();
        ArrayList<class_3955> compressed = new ArrayList<class_3955>();
        ArrayList<class_3955> decompressed = new ArrayList<class_3955>();
        for (class_3955 recipe2 : recipeManager.method_30027(class_3956.field_17545)) {
            if (this.isCompressionRecipe(recipe2, access)) {
                compressed.add(recipe2);
                continue;
            }
            if (!this.isDecompressionRecipe(recipe2, access)) continue;
            decompressed.add(recipe2);
        }
        compressed.removeIf(recipe -> this.isIrreversible((class_3955)recipe, (List<class_3955>)decompressed, access));
        decompressed.removeIf(recipe -> this.isIrreversible((class_3955)recipe, (List<class_3955>)compressed, access));
        Comparator<class_3955> ingredientSize = Comparator.comparingInt(r -> ((class_1856)r.method_8117().get(0)).method_8105().length);
        compressed.sort(ingredientSize);
        decompressed.sort(ingredientSize);
        Stream.concat(compressed.stream(), decompressed.stream()).forEach(recipe -> {
            class_1792 baseVariant = recipe.method_8110(access).method_7909();
            if (this.getChain(AEItemKey.of((class_1935)baseVariant)).isEmpty()) {
                this.compressionChains.add(this.generateChain(baseVariant, compressed, decompressed, access));
            }
        });
        if (!this.compressionChains.isEmpty()) {
            MEGACells.LOGGER.info("(Re-)initialised bulk cell compression.");
        }
    }

    private CompressionChain generateChain(class_1792 baseVariant, List<class_3955> compressed, List<class_3955> decompressed, class_5455 access) {
        LinkedList<class_1792> variants = new LinkedList<class_1792>();
        LinkedList<Byte> multipliers = new LinkedList<Byte>();
        variants.addFirst(baseVariant);
        Variant lower = this.getNextVariant(baseVariant, decompressed, false, access);
        while (lower != null) {
            class_1792 item = lower.item.getItem();
            if (variants.contains(item)) {
                MEGACells.LOGGER.warn("Duplicate lower compression variant detected: {}. Check any recipe involving this item for problems.", (Object)lower);
                break;
            }
            variants.addFirst(item);
            multipliers.addFirst(lower.factor());
            lower = this.getNextVariant(lower.item().getItem(), decompressed, false, access);
        }
        multipliers.addFirst((byte)1);
        CompressionChain chain = new CompressionChain();
        for (int i = 0; i < variants.size(); ++i) {
            chain.add(AEItemKey.of((class_1935)((class_1935)variants.get(i))), (Byte)multipliers.get(i));
        }
        Variant higher = this.getNextVariant(baseVariant, compressed, true, access);
        while (higher != null) {
            if (chain.contains(higher)) {
                MEGACells.LOGGER.warn("Duplicate higher compression variant detected: {}}. Check any recipe involving this item for problems.", (Object)higher);
                break;
            }
            chain.add(higher);
            higher = this.getNextVariant(higher.item().getItem(), compressed, true, access);
        }
        return chain;
    }

    private Variant getNextVariant(class_1792 item, List<class_3955> recipes, boolean compressed, class_5455 access) {
        for (Override override : this.overrides) {
            if (compressed && override.smaller.equals(item)) {
                return new Variant(override.larger, override.factor);
            }
            if (compressed || !override.larger.equals(item)) continue;
            return new Variant(override.smaller, override.factor);
        }
        for (class_3955 recipe : recipes) {
            for (class_1799 input : ((class_1856)recipe.method_8117().get(0)).method_8105()) {
                if (!input.method_7909().equals(item)) continue;
                return new Variant(recipe.method_8110(access).method_7909(), (byte)(compressed ? recipe.method_8117().size() : recipe.method_8110(access).method_7947()));
            }
        }
        return null;
    }

    private boolean isDecompressionRecipe(class_3955 recipe, class_5455 access) {
        return recipe.method_8117().stream().filter(i -> !i.method_8103()).count() == 1L && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(recipe.method_8110(access).method_7947());
    }

    private boolean isCompressionRecipe(class_3955 recipe, class_5455 access) {
        class_2371 ingredients = recipe.method_8117();
        return recipe.method_8110(access).method_7947() == 1 && ingredients.stream().noneMatch(class_1856::method_8103) && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(ingredients.size()) && this.sameIngredient(recipe);
    }

    private boolean sameIngredient(class_3955 recipe) {
        class_2371 ingredients = recipe.method_8117();
        if (recipe instanceof class_1869 && ingredients.stream().distinct().count() <= 1L) {
            return true;
        }
        class_1799[] first = ((class_1856)ingredients.get(0)).method_8105();
        for (class_1856 ingredient : ingredients) {
            class_1799[] stacks = ingredient.method_8105();
            if (stacks.length != first.length) {
                return false;
            }
            for (int i = 0; i < stacks.length; ++i) {
                if (class_1799.method_31577((class_1799)stacks[i], (class_1799)first[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isIrreversible(class_3955 recipe, List<class_3955> candidates, class_5455 access) {
        if (this.overrideRecipe(recipe, access)) {
            return false;
        }
        class_1799[] testInput = ((class_1856)recipe.method_8117().get(0)).method_8105();
        class_1792 testOutput = recipe.method_8110(access).method_7909();
        for (class_3955 candidate : candidates) {
            class_1799[] input = ((class_1856)candidate.method_8117().get(0)).method_8105();
            class_1792 output = candidate.method_8110(access).method_7909();
            boolean compressible = Arrays.stream(input).anyMatch(i -> i.method_31574(testOutput));
            boolean decompressible = Arrays.stream(testInput).anyMatch(i -> i.method_31574(output));
            if (!compressible || !decompressible) continue;
            return false;
        }
        return true;
    }

    private boolean overrideRecipe(class_3955 recipe, class_5455 access) {
        for (class_1799 input : ((class_1856)recipe.method_8117().get(0)).method_8105()) {
            if (!input.method_31573(MEGATags.COMPRESSION_OVERRIDES)) continue;
            boolean compressed = !this.isDecompressionRecipe(recipe, access);
            class_1799 output = recipe.method_8110(access);
            class_1792 smaller = compressed ? input.method_7909() : output.method_7909();
            class_1792 larger = compressed ? output.method_7909() : input.method_7909();
            byte factor = (byte)(compressed ? recipe.method_8117().size() : output.method_7947());
            this.overrides.add(new Override(smaller, larger, factor));
            return true;
        }
        return false;
    }

    public record Variant(AEItemKey item, byte factor) {
        private Variant(class_1792 item, byte factor) {
            this(AEItemKey.of((class_1935)item), factor);
        }
    }

    private record Override(class_1792 smaller, class_1792 larger, byte factor) {
    }
}

