/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.cell;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.AEConfig;
import appeng.core.localization.Tooltips;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.util.ConfigInventory;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGATranslations;
import gripe._90.megacells.item.cell.BulkCellInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulkCellItem
extends AEBaseItem
implements ICellWorkbenchItem {
    public static final Handler HANDLER = new Handler();

    public BulkCellItem(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    public ConfigInventory getConfigInventory(class_1799 is) {
        return CellConfig.create((AEKeyFilter)AEItemKey.filter(), (class_1799)is, (int)1);
    }

    public IUpgradeInventory getUpgrades(class_1799 is) {
        return UpgradeInventories.forItem((class_1799)is, (int)1);
    }

    public void method_7851(class_1799 is, class_1937 level, @NotNull List<class_2561> lines, @NotNull class_1836 adv) {
        BulkCellInventory inv = HANDLER.getCellInventory(is, null);
        if (inv != null) {
            AEItemKey storedItem = inv.getStoredItem();
            AEItemKey filterItem = inv.getFilterItem();
            if (storedItem != null) {
                lines.add((class_2561)Tooltips.of((class_2561)MEGATranslations.Contains.text(new Object[]{storedItem.getDisplayName()})));
                long quantity = inv.getStoredQuantity();
                lines.add((class_2561)Tooltips.of((class_2561)MEGATranslations.Quantity.text(new Object[]{quantity < Long.MAX_VALUE ? Tooltips.ofNumber((long)quantity) : MEGATranslations.ALot.text().method_27696(Tooltips.NUMBER_TEXT)})));
            } else {
                lines.add((class_2561)Tooltips.of((class_2561)MEGATranslations.Empty.text()));
            }
            if (filterItem != null) {
                if (storedItem == null) {
                    lines.add((class_2561)Tooltips.of((class_2561)MEGATranslations.PartitionedFor.text(new Object[]{filterItem.getDisplayName()})));
                } else if (!storedItem.equals((Object)filterItem)) {
                    lines.add((class_2561)MEGATranslations.MismatchedFilter.text().method_27692(class_124.field_1079));
                }
            } else {
                lines.add((class_2561)(storedItem != null ? MEGATranslations.MismatchedFilter.text().method_27692(class_124.field_1079) : Tooltips.of((class_2561)MEGATranslations.NotPartitioned.text())));
            }
            lines.add((class_2561)Tooltips.of((class_2561)MEGATranslations.Compression.text(new Object[]{inv.isCompressionEnabled() ? MEGATranslations.Enabled.text().method_27692(class_124.field_1060) : MEGATranslations.Disabled.text().method_27692(class_124.field_1061)})));
        }
    }

    @NotNull
    public Optional<class_5632> method_32346(class_1799 is) {
        BulkCellInventory inv = HANDLER.getCellInventory(is, null);
        if (inv == null) {
            return Optional.empty();
        }
        ArrayList<class_1799> upgrades = new ArrayList<class_1799>();
        if (AEConfig.instance().isTooltipShowCellUpgrades() && inv.isCompressionEnabled()) {
            upgrades.add(MEGAItems.COMPRESSION_CARD.stack());
        }
        ArrayList<GenericStack> content = new ArrayList<GenericStack>();
        if (AEConfig.instance().isTooltipShowCellContent()) {
            if (inv.getStoredItem() != null) {
                content.add(new GenericStack((AEKey)inv.getStoredItem(), inv.getStoredQuantity()));
            } else if (inv.getFilterItem() != null) {
                content.add(new GenericStack((AEKey)inv.getFilterItem(), 0L));
            }
        }
        return Optional.of(new StorageCellTooltipComponent(upgrades, content, false, true));
    }

    public FuzzyMode getFuzzyMode(class_1799 itemStack) {
        return null;
    }

    public void setFuzzyMode(class_1799 itemStack, FuzzyMode fuzzyMode) {
    }

    public static class Handler
    implements ICellHandler {
        private Handler() {
        }

        public boolean isCell(class_1799 is) {
            return is != null && is.method_7909() instanceof BulkCellItem;
        }

        @Nullable
        public BulkCellInventory getCellInventory(class_1799 is, @Nullable ISaveProvider host) {
            return this.isCell(is) ? new BulkCellInventory(is, host) : null;
        }
    }
}

