/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.integration.appbot;

import appbot.item.ManaCellItem;
import appbot.item.PortableManaCellItem;
import appeng.core.definitions.ItemDefinition;
import appeng.items.materials.MaterialItem;
import appeng.items.storage.StorageTier;
import appeng.items.tools.powered.AbstractPortableCell;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.integration.appbot.MEGAManaCellItem;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public final class AppBotItems {
    public static final ItemDefinition<MaterialItem> MEGA_MANA_CELL_HOUSING = MEGAItems.item("MEGA Mana Cell Housing", "mega_mana_cell_housing", MaterialItem::new);
    public static final ItemDefinition<ManaCellItem> MANA_CELL_1M = AppBotItems.cell(MEGAItems.TIER_1M);
    public static final ItemDefinition<ManaCellItem> MANA_CELL_4M = AppBotItems.cell(MEGAItems.TIER_4M);
    public static final ItemDefinition<ManaCellItem> MANA_CELL_16M = AppBotItems.cell(MEGAItems.TIER_16M);
    public static final ItemDefinition<ManaCellItem> MANA_CELL_64M = AppBotItems.cell(MEGAItems.TIER_64M);
    public static final ItemDefinition<ManaCellItem> MANA_CELL_256M = AppBotItems.cell(MEGAItems.TIER_256M);
    public static final ItemDefinition<PortableManaCellItem> PORTABLE_MANA_CELL_1M = AppBotItems.portable(MEGAItems.TIER_1M);
    public static final ItemDefinition<PortableManaCellItem> PORTABLE_MANA_CELL_4M = AppBotItems.portable(MEGAItems.TIER_4M);
    public static final ItemDefinition<PortableManaCellItem> PORTABLE_MANA_CELL_16M = AppBotItems.portable(MEGAItems.TIER_16M);
    public static final ItemDefinition<PortableManaCellItem> PORTABLE_MANA_CELL_64M = AppBotItems.portable(MEGAItems.TIER_64M);
    public static final ItemDefinition<PortableManaCellItem> PORTABLE_MANA_CELL_256M = AppBotItems.portable(MEGAItems.TIER_256M);

    public static void init() {
        MEGACells.LOGGER.info("Initialised Applied Botanics integration.");
    }

    public static List<ItemDefinition<?>> getCells() {
        return List.of(MANA_CELL_1M, MANA_CELL_4M, MANA_CELL_16M, MANA_CELL_64M, MANA_CELL_256M);
    }

    public static List<ItemDefinition<? extends AbstractPortableCell>> getPortables() {
        return List.of(PORTABLE_MANA_CELL_1M, PORTABLE_MANA_CELL_4M, PORTABLE_MANA_CELL_16M, PORTABLE_MANA_CELL_64M, PORTABLE_MANA_CELL_256M);
    }

    private static ItemDefinition<ManaCellItem> cell(StorageTier tier) {
        return MEGAItems.item(tier.namePrefix().toUpperCase() + " MEGA Mana Storage Cell", "mana_storage_cell_" + tier.namePrefix(), p -> new MEGAManaCellItem((class_1792.class_1793)p, tier));
    }

    private static ItemDefinition<PortableManaCellItem> portable(final StorageTier tier) {
        return MEGAItems.item(tier.namePrefix().toUpperCase() + " Portable Mana Cell", "portable_mana_cell_" + tier.namePrefix(), p -> new PortableManaCellItem((class_1792.class_1793)p, tier.bytes() / 1024, tier.idleDrain()){

            @NotNull
            public class_2960 getRecipeId() {
                return MEGACells.makeId("cells/portable/portable_mana_cell_" + tier.namePrefix());
            }
        });
    }
}

