/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.client.render;

import appeng.block.crafting.ICraftingUnitType;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.LightBakedModel;
import appeng.client.render.crafting.MonitorBakedModel;
import appeng.client.render.crafting.UnitBakedModel;
import appeng.core.AppEng;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.block.MEGACraftingUnitType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_4730;

@Environment(value=EnvType.CLIENT)
public class MEGACraftingUnitModelProvider
extends AbstractCraftingUnitModelProvider<MEGACraftingUnitType> {
    private static final List<class_4730> MATERIALS = new ArrayList<class_4730>();
    protected static final class_4730 RING_CORNER = MEGACraftingUnitModelProvider.texture("ring_corner");
    protected static final class_4730 RING_SIDE_HOR = MEGACraftingUnitModelProvider.texture("ring_side_hor");
    protected static final class_4730 RING_SIDE_VER = MEGACraftingUnitModelProvider.texture("ring_side_ver");
    protected static final class_4730 UNIT_BASE = MEGACraftingUnitModelProvider.texture("unit_base");
    protected static final class_4730 LIGHT_BASE = MEGACraftingUnitModelProvider.texture("light_base");
    protected static final class_4730 ACCELERATOR_LIGHT = MEGACraftingUnitModelProvider.texture("accelerator_light");
    protected static final class_4730 STORAGE_1M_LIGHT = MEGACraftingUnitModelProvider.texture("1m_storage_light");
    protected static final class_4730 STORAGE_4M_LIGHT = MEGACraftingUnitModelProvider.texture("4m_storage_light");
    protected static final class_4730 STORAGE_16M_LIGHT = MEGACraftingUnitModelProvider.texture("16m_storage_light");
    protected static final class_4730 STORAGE_64M_LIGHT = MEGACraftingUnitModelProvider.texture("64m_storage_light");
    protected static final class_4730 STORAGE_256M_LIGHT = MEGACraftingUnitModelProvider.texture("256m_storage_light");
    protected static final class_4730 MONITOR_BASE = MEGACraftingUnitModelProvider.texture("monitor_base");
    protected static final class_4730 MONITOR_LIGHT_DARK = MEGACraftingUnitModelProvider.monitorLight("dark");
    protected static final class_4730 MONITOR_LIGHT_MEDIUM = MEGACraftingUnitModelProvider.monitorLight("medium");
    protected static final class_4730 MONITOR_LIGHT_BRIGHT = MEGACraftingUnitModelProvider.monitorLight("bright");

    public MEGACraftingUnitModelProvider(MEGACraftingUnitType type) {
        super((ICraftingUnitType)type);
    }

    public List<class_4730> getMaterials() {
        return Collections.unmodifiableList(MATERIALS);
    }

    public class_1058 getLightMaterial(Function<class_4730, class_1058> textureGetter) {
        return switch ((MEGACraftingUnitType)this.type) {
            case MEGACraftingUnitType.ACCELERATOR -> textureGetter.apply(ACCELERATOR_LIGHT);
            case MEGACraftingUnitType.STORAGE_1M -> textureGetter.apply(STORAGE_1M_LIGHT);
            case MEGACraftingUnitType.STORAGE_4M -> textureGetter.apply(STORAGE_4M_LIGHT);
            case MEGACraftingUnitType.STORAGE_16M -> textureGetter.apply(STORAGE_16M_LIGHT);
            case MEGACraftingUnitType.STORAGE_64M -> textureGetter.apply(STORAGE_64M_LIGHT);
            case MEGACraftingUnitType.STORAGE_256M -> textureGetter.apply(STORAGE_256M_LIGHT);
            default -> throw new IllegalArgumentException("Crafting unit type " + String.valueOf(this.type) + " does not use a light texture.");
        };
    }

    public class_1087 getBakedModel(Function<class_4730, class_1058> spriteGetter) {
        class_1058 ringCorner = spriteGetter.apply(RING_CORNER);
        class_1058 ringSideHor = spriteGetter.apply(RING_SIDE_HOR);
        class_1058 ringSideVer = spriteGetter.apply(RING_SIDE_VER);
        return switch ((MEGACraftingUnitType)this.type) {
            default -> throw new IncompatibleClassChangeError();
            case MEGACraftingUnitType.UNIT -> new UnitBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(UNIT_BASE));
            case MEGACraftingUnitType.ACCELERATOR, MEGACraftingUnitType.STORAGE_1M, MEGACraftingUnitType.STORAGE_4M, MEGACraftingUnitType.STORAGE_16M, MEGACraftingUnitType.STORAGE_64M, MEGACraftingUnitType.STORAGE_256M -> new LightBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(LIGHT_BASE), this.getLightMaterial(spriteGetter));
            case MEGACraftingUnitType.MONITOR -> new MonitorBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(UNIT_BASE), spriteGetter.apply(MONITOR_BASE), spriteGetter.apply(MONITOR_LIGHT_DARK), spriteGetter.apply(MONITOR_LIGHT_MEDIUM), spriteGetter.apply(MONITOR_LIGHT_BRIGHT));
        };
    }

    private static class_4730 texture(String name) {
        class_4730 material = new class_4730(class_1723.field_21668, MEGACells.makeId("block/crafting/" + name));
        MATERIALS.add(material);
        return material;
    }

    private static class_4730 monitorLight(String suffix) {
        class_4730 material = new class_4730(class_1723.field_21668, AppEng.makeId((String)("block/crafting/monitor_light_" + suffix)));
        MATERIALS.add(material);
        return material;
    }
}

