/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.recipes.machines;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.steven.indrev.components.CraftingComponent;
import me.steven.indrev.components.FluidComponent;
import me.steven.indrev.recipes.machines.IRRecipe;
import me.steven.indrev.recipes.machines.entries.InputEntry;
import me.steven.indrev.recipes.machines.entries.OutputEntry;
import me.steven.indrev.utils.FluidutilsKt;
import me.steven.indrev.utils.IRFluidTank;
import me.steven.indrev.utils.UtilsKt;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u000e\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR$\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u00130\u00108&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0018\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u00130\u00108&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "Lme/steven/indrev/recipes/machines/IRRecipe;", "<init>", "()V", "Lme/steven/indrev/components/CraftingComponent;", "component", "", "canStart", "(Lme/steven/indrev/components/CraftingComponent;)Z", "", "Lnet/minecraft/class_1799;", "inv", "Lme/steven/indrev/utils/IRFluidTank;", "fluidVolume", "matches", "(Ljava/util/List;Ljava/util/List;)Z", "", "Lnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;", "Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "Lme/steven/indrev/utils/IRFluidAmount;", "getFluidInput", "()[Lnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;", "fluidInput", "getFluidOutput", "fluidOutput", "IRFluidRecipeSerializer", "indrev"})
@SourceDebugExtension(value={"SMAP\nIRFluidRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IRFluidRecipe.kt\nme/steven/indrev/recipes/machines/IRFluidRecipe\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1726#2,3:106\n1747#2,3:109\n*S KotlinDebug\n*F\n+ 1 IRFluidRecipe.kt\nme/steven/indrev/recipes/machines/IRFluidRecipe\n*L\n20#1:106,3\n30#1:109,3\n*E\n"})
public abstract class IRFluidRecipe
implements IRRecipe {
    @NotNull
    public abstract ResourceAmount<FluidVariant>[] getFluidInput();

    @NotNull
    public abstract ResourceAmount<FluidVariant>[] getFluidOutput();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(@NotNull List<class_1799> inv, @NotNull List<IRFluidTank> fluidVolume) {
        Intrinsics.checkNotNullParameter(inv, (String)"inv");
        Intrinsics.checkNotNullParameter(fluidVolume, (String)"fluidVolume");
        if (!(this.getFluidInput().length == 0)) {
            boolean bl;
            if (((Collection)fluidVolume).isEmpty()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            Iterable $this$all$iv = (Iterable)ArraysKt.getIndices((Object[])this.getFluidInput());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int index = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl3 = false;
                    IRFluidTank vol = fluidVolume.get(index);
                    if (!Intrinsics.areEqual((Object)vol.getResource(), (Object)this.getFluidInput()[index].resource())) return false;
                    if (vol.amount < this.getFluidInput()[index].amount()) return false;
                    boolean bl4 = true;
                    if (bl4) continue;
                    return false;
                }
                bl = true;
            }
            if (!bl) return false;
            if (!IRRecipe.DefaultImpls.matches((IRRecipe)this, inv, fluidVolume)) return false;
            return true;
        }
        boolean bl = IRRecipe.DefaultImpls.matches((IRRecipe)this, inv, fluidVolume);
        return bl;
    }

    @Override
    public boolean canStart(@NotNull CraftingComponent<?> component) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        FluidComponent fluidComponent2 = component.getFluidComponent();
        Intrinsics.checkNotNull((Object)((Object)fluidComponent2));
        FluidComponent fluidComponent3 = fluidComponent2;
        int[] outputTankVolume = fluidComponent3.getOutputTanks();
        if (!(this.getFluidOutput().length == 0)) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = (Iterable)ArraysKt.getIndices((Object[])this.getFluidOutput());
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int index = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl2 = false;
                        IRFluidTank vol = fluidComponent3.get(outputTankVolume[index]);
                        if (!(!vol.isEmpty() && (!Intrinsics.areEqual((Object)vol.getResource(), (Object)this.getFluidOutput()[index].resource()) || vol.amount + this.getFluidOutput()[index].amount() > fluidComponent3.getLimit()))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
        }
        return IRRecipe.DefaultImpls.canStart(this, component);
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(expression="matches(Inventory, FluidVolume?)", imports={}), level=DeprecationLevel.ERROR)
    public boolean method_8115(@Nullable class_1263 inv, @Nullable class_1937 world) {
        return IRRecipe.DefaultImpls.matches((IRRecipe)this, inv, world);
    }

    @Override
    public boolean matches(@NotNull class_1799 stack2, @NotNull List<IRFluidTank> fluidVolume) {
        return IRRecipe.DefaultImpls.matches((IRRecipe)this, stack2, fluidVolume);
    }

    @Override
    @NotNull
    public class_2960 method_8114() {
        return IRRecipe.DefaultImpls.getId(this);
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(expression="craft(Random)", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public class_1799 method_8116(@Nullable class_1263 inv, @Nullable class_5455 registryManager) {
        return IRRecipe.DefaultImpls.craft(this, inv, registryManager);
    }

    @Override
    @NotNull
    public List<class_1799> craft(@Nullable class_5819 random) {
        return IRRecipe.DefaultImpls.craft(this, random);
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(expression="output", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public class_1799 method_8110(@Nullable class_5455 registryManager) {
        return IRRecipe.DefaultImpls.getOutput(this, registryManager);
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(expression="input", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public class_2371<class_1856> method_8117() {
        return IRRecipe.DefaultImpls.getIngredients(this);
    }

    @Override
    public boolean method_31584() {
        return IRRecipe.DefaultImpls.isEmpty(this);
    }

    @Override
    public boolean method_8118() {
        return IRRecipe.DefaultImpls.isIgnoredInRecipeBook(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003Be\u0012\\\u0010\r\u001aX\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b0\u0006\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b0\u0006\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0017J\u001f\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bRj\u0010\r\u001aX\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b0\u0006\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b0\u0006\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lme/steven/indrev/recipes/machines/IRFluidRecipe$IRFluidRecipeSerializer;", "Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "T", "Lnet/minecraft/class_1865;", "Lkotlin/Function6;", "Lnet/minecraft/class_2960;", "", "Lme/steven/indrev/recipes/machines/entries/InputEntry;", "Lme/steven/indrev/recipes/machines/entries/OutputEntry;", "Lnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;", "Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "Lme/steven/indrev/utils/IRFluidAmount;", "", "factory", "<init>", "(Lkotlin/jvm/functions/Function6;)V", "id", "Lcom/google/gson/JsonObject;", "json", "read", "(Lnet/minecraft/class_2960;Lcom/google/gson/JsonObject;)Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "Lnet/minecraft/class_2540;", "buf", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_2540;)Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "recipe", "", "write", "(Lnet/minecraft/class_2540;Lme/steven/indrev/recipes/machines/IRFluidRecipe;)V", "Lkotlin/jvm/functions/Function6;", "indrev"})
    @SourceDebugExtension(value={"SMAP\nIRFluidRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IRFluidRecipe.kt\nme/steven/indrev/recipes/machines/IRFluidRecipe$IRFluidRecipeSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,105:1\n1855#2,2:106\n1855#2,2:108\n1855#2,2:110\n1855#2,2:112\n37#3,2:114\n26#4:116\n26#4:117\n13309#5,2:118\n13309#5,2:120\n13309#5,2:122\n13309#5,2:124\n*S KotlinDebug\n*F\n+ 1 IRFluidRecipe.kt\nme/steven/indrev/recipes/machines/IRFluidRecipe$IRFluidRecipeSerializer\n*L\n44#1:106,2\n50#1:108,2\n55#1:110,2\n62#1:112,2\n67#1:114,2\n75#1:116\n78#1:117\n86#1:118,2\n90#1:120,2\n94#1:122,2\n99#1:124,2\n*E\n"})
    public static class IRFluidRecipeSerializer<T extends IRFluidRecipe>
    implements class_1865<T> {
        @NotNull
        private final Function6<class_2960, InputEntry[], OutputEntry[], ResourceAmount<FluidVariant>[], ResourceAmount<FluidVariant>[], Integer, T> factory;

        public IRFluidRecipeSerializer(@NotNull Function6<? super class_2960, ? super InputEntry[], ? super OutputEntry[], ? super ResourceAmount<FluidVariant>[], ? super ResourceAmount<FluidVariant>[], ? super Integer, ? extends T> factory) {
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            this.factory = factory;
        }

        @NotNull
        public T read(@NotNull class_2960 id, @NotNull class_2540 buf) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int ticks = buf.readInt();
            int inputFluidsSize = buf.readInt();
            List inputFluids = new ArrayList();
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)inputFluidsSize);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                inputFluids.add(FluidutilsKt.fromPacket(buf));
            }
            int outputFluidsSize = buf.readInt();
            List outputFluids = new ArrayList();
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)outputFluidsSize);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                int element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                outputFluids.add(FluidutilsKt.fromPacket(buf));
            }
            int size = buf.readInt();
            List ingredients = new ArrayList();
            Iterable $this$forEach$iv3 = (Iterable)RangesKt.until((int)0, (int)size);
            boolean $i$f$forEach3 = false;
            Iterator iterator3 = $this$forEach$iv3.iterator();
            while (iterator3.hasNext()) {
                int element$iv = ((IntIterator)iterator3).nextInt();
                boolean bl = false;
                class_1856 ingredient = class_1856.method_8086((class_2540)buf);
                int count = buf.readInt();
                Intrinsics.checkNotNull((Object)ingredient);
                ingredients.add(new InputEntry(ingredient, count));
            }
            int outputSize = buf.readInt();
            List output2 = new ArrayList();
            Iterable $this$forEach$iv4 = (Iterable)RangesKt.until((int)0, (int)outputSize);
            boolean $i$f$forEach4 = false;
            Iterator iterator4 = $this$forEach$iv4.iterator();
            while (iterator4.hasNext()) {
                int element$iv = ((IntIterator)iterator4).nextInt();
                boolean bl = false;
                class_1799 stack2 = buf.method_10819();
                double chance = buf.readDouble();
                Intrinsics.checkNotNull((Object)stack2);
                output2.add(new OutputEntry(stack2, chance));
            }
            Collection $this$toTypedArray$iv = ingredients;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            InputEntry[] inputEntryArray = thisCollection$iv.toArray(new InputEntry[0]);
            $this$toTypedArray$iv = output2;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            OutputEntry[] outputEntryArray = thisCollection$iv.toArray(new OutputEntry[0]);
            $this$toTypedArray$iv = inputFluids;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            ResourceAmount[] resourceAmountArray = thisCollection$iv.toArray(new ResourceAmount[0]);
            $this$toTypedArray$iv = outputFluids;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            return (T)((IRFluidRecipe)this.factory.invoke((Object)id, (Object)inputEntryArray, (Object)outputEntryArray, (Object)resourceAmountArray, (Object)thisCollection$iv.toArray(new ResourceAmount[0]), (Object)ticks));
        }

        @NotNull
        public T read(@NotNull class_2960 id, @NotNull JsonObject json) {
            ResourceAmount<FluidVariant>[] resourceAmountArray;
            ResourceAmount<FluidVariant>[] resourceAmountArray2;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            InputEntry[] ingredients = IRRecipe.Companion.ingredientsFromElement(json.get("ingredients"));
            int ticks = json.get("processTime").getAsInt();
            OutputEntry[] output2 = IRRecipe.Companion.itemStacksFromElement(json.get("output"));
            JsonElement fluidInputJson = json.get("fluidInput");
            if (fluidInputJson == null) {
                boolean $i$f$emptyArray = false;
                resourceAmountArray2 = new ResourceAmount[]{};
            } else {
                resourceAmountArray2 = UtilsKt.getFluidFromJson(fluidInputJson);
            }
            ResourceAmount<FluidVariant>[] fluidInput = resourceAmountArray2;
            JsonElement fluidOutputJson = json.get("fluidOutput");
            if (fluidOutputJson == null) {
                boolean $i$f$emptyArray = false;
                resourceAmountArray = new ResourceAmount[]{};
            } else {
                resourceAmountArray = UtilsKt.getFluidFromJson(fluidOutputJson);
            }
            ResourceAmount<FluidVariant>[] fluidOutput = resourceAmountArray;
            return (T)((IRFluidRecipe)this.factory.invoke((Object)id, (Object)ingredients, (Object)output2, fluidInput, fluidOutput, (Object)ticks));
        }

        public void write(@NotNull class_2540 buf, @NotNull T recipe) {
            ResourceAmount<FluidVariant> resourceAmount;
            ResourceAmount<FluidVariant> element$iv;
            int n;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
            buf.writeInt(recipe.getTicks());
            buf.writeInt(((IRFluidRecipe)recipe).getFluidInput().length);
            Object[] $this$forEach$iv = ((IRFluidRecipe)recipe).getFluidInput();
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                ResourceAmount<FluidVariant> fluidInput = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                FluidutilsKt.toPacket(fluidInput, buf);
            }
            buf.writeInt(((IRFluidRecipe)recipe).getFluidOutput().length);
            $this$forEach$iv = ((IRFluidRecipe)recipe).getFluidOutput();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                ResourceAmount<FluidVariant> fluidOutput = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                FluidutilsKt.toPacket(fluidOutput, buf);
            }
            buf.writeInt(recipe.getInput().length);
            $this$forEach$iv = recipe.getInput();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                resourceAmount = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                class_1856 ingredient = resourceAmount.component1();
                int count = resourceAmount.component2();
                ingredient.method_8088(buf);
                buf.writeInt(count);
            }
            buf.writeInt(recipe.getOutputs().length);
            $this$forEach$iv = recipe.getOutputs();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                resourceAmount = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                class_1799 stack2 = resourceAmount.component1();
                double chance = resourceAmount.component2();
                buf.method_10793(stack2);
                buf.writeDouble(chance);
            }
        }
    }
}

