/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.networks.factory;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import me.steven.indrev.blocks.machine.pipes.CableBlock;
import me.steven.indrev.blocks.machine.pipes.FluidPipeBlock;
import me.steven.indrev.blocks.machine.pipes.ItemPipeBlock;
import me.steven.indrev.networks.Network;
import me.steven.indrev.networks.NetworkState;
import me.steven.indrev.networks.energy.EnergyNetwork;
import me.steven.indrev.networks.energy.EnergyNetworkState;
import me.steven.indrev.networks.factory.NetworkFactory;
import me.steven.indrev.networks.fluid.FluidNetwork;
import me.steven.indrev.networks.item.ItemNetwork;
import me.steven.indrev.utils.EnergyutilsKt;
import me.steven.indrev.utils.FluidutilsKt;
import me.steven.indrev.utils.ItemutilsKt;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u001d\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\u0005\"\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00008\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\u0005\u00a8\u0006\f"}, d2={"Lme/steven/indrev/networks/factory/NetworkFactory;", "Lme/steven/indrev/networks/energy/EnergyNetwork;", "ENERGY_NET_FACTORY", "Lme/steven/indrev/networks/factory/NetworkFactory;", "getENERGY_NET_FACTORY", "()Lme/steven/indrev/networks/factory/NetworkFactory;", "Lme/steven/indrev/networks/fluid/FluidNetwork;", "FLUID_NET_FACTORY", "getFLUID_NET_FACTORY", "Lme/steven/indrev/networks/item/ItemNetwork;", "ITEM_NET_FACTORY", "getITEM_NET_FACTORY", "indrev"})
public final class FactoriesKt {
    @NotNull
    private static final NetworkFactory<EnergyNetwork> ENERGY_NET_FACTORY = new NetworkFactory<EnergyNetwork>(){

        public boolean process(@NotNull EnergyNetwork network, @NotNull NetworkState<EnergyNetwork> state, @NotNull class_3218 world, @NotNull class_2338 pos, @NotNull class_2350 direction, @NotNull Function0<? extends class_2680> blockState2) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            Intrinsics.checkNotNullParameter(state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter(blockState2, (String)"blockState");
            if (((class_2680)blockState2.invoke()).method_26204() instanceof CableBlock) {
                class_2248 class_22482 = ((class_2680)blockState2.invoke()).method_26204();
                Intrinsics.checkNotNullExpressionValue((Object)class_22482, (String)"getBlock(...)");
                class_2338 class_23382 = pos.method_10062();
                Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"toImmutable(...)");
                network.appendPipe(class_22482, class_23382);
                if (((EnergyNetworkState)state).getSavedEnergy().containsKey(pos)) {
                    Long l = ((EnergyNetworkState)state).getSavedEnergy().remove(pos);
                    Intrinsics.checkNotNull((Object)l);
                    long energy2 = ((Number)l).longValue();
                    network.setEnergy(network.getEnergy() + energy2);
                }
                return true;
            }
            class_2350 class_23502 = direction.method_10153();
            Intrinsics.checkNotNullExpressionValue((Object)class_23502, (String)"getOpposite(...)");
            EnergyStorage energyOf = EnergyutilsKt.energyOf(world, pos, class_23502);
            if (energyOf != null) {
                class_2350 class_23503 = direction.method_10153();
                Intrinsics.checkNotNullExpressionValue((Object)class_23503, (String)"getOpposite(...)");
                network.appendContainer(pos, class_23503);
                if (energyOf.supportsInsertion()) {
                    network.getInsertables().add((Object)pos);
                }
            }
            return false;
        }

        public void deepScan(@NotNull LongOpenHashSet scanned, @NotNull Network.Type<EnergyNetwork> type, @NotNull NetworkState<EnergyNetwork> state, @NotNull EnergyNetwork network, @NotNull class_2791 chunk, @NotNull class_3218 world, @NotNull class_2338 blockPos, @NotNull class_2338 source, @NotNull class_2350 direction) {
            NetworkFactory.DefaultImpls.deepScan(this, scanned, type, state, (Network)network, chunk, world, blockPos, source, direction);
        }

        @NotNull
        public EnergyNetwork deepScan(@NotNull Network.Type<EnergyNetwork> type, @NotNull class_3218 world, @NotNull class_2338 source) {
            return NetworkFactory.DefaultImpls.deepScan(this, type, world, source);
        }
    };
    @NotNull
    private static final NetworkFactory<FluidNetwork> FLUID_NET_FACTORY = new NetworkFactory<FluidNetwork>(){

        public boolean process(@NotNull FluidNetwork network, @NotNull NetworkState<FluidNetwork> state, @NotNull class_3218 world, @NotNull class_2338 pos, @NotNull class_2350 direction, @NotNull Function0<? extends class_2680> blockState2) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            Intrinsics.checkNotNullParameter(state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter(blockState2, (String)"blockState");
            if (((class_2680)blockState2.invoke()).method_26204() instanceof FluidPipeBlock) {
                class_2248 class_22482 = ((class_2680)blockState2.invoke()).method_26204();
                Intrinsics.checkNotNullExpressionValue((Object)class_22482, (String)"getBlock(...)");
                class_2338 class_23382 = pos.method_10062();
                Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"toImmutable(...)");
                network.appendPipe(class_22482, class_23382);
                state.onSet(pos, (FluidNetwork)((Network)network));
                return true;
            }
            class_2350 class_23502 = direction.method_10153();
            Intrinsics.checkNotNullExpressionValue((Object)class_23502, (String)"getOpposite(...)");
            if (FluidutilsKt.fluidStorageOf(world, pos, class_23502) != null) {
                class_2350 class_23503 = direction.method_10153();
                Intrinsics.checkNotNullExpressionValue((Object)class_23503, (String)"getOpposite(...)");
                network.appendContainer(pos, class_23503);
            }
            return false;
        }

        public void deepScan(@NotNull LongOpenHashSet scanned, @NotNull Network.Type<FluidNetwork> type, @NotNull NetworkState<FluidNetwork> state, @NotNull FluidNetwork network, @NotNull class_2791 chunk, @NotNull class_3218 world, @NotNull class_2338 blockPos, @NotNull class_2338 source, @NotNull class_2350 direction) {
            NetworkFactory.DefaultImpls.deepScan(this, scanned, type, state, (Network)network, chunk, world, blockPos, source, direction);
        }

        @NotNull
        public FluidNetwork deepScan(@NotNull Network.Type<FluidNetwork> type, @NotNull class_3218 world, @NotNull class_2338 source) {
            return NetworkFactory.DefaultImpls.deepScan(this, type, world, source);
        }
    };
    @NotNull
    private static final NetworkFactory<ItemNetwork> ITEM_NET_FACTORY = new NetworkFactory<ItemNetwork>(){

        public boolean process(@NotNull ItemNetwork network, @NotNull NetworkState<ItemNetwork> state, @NotNull class_3218 world, @NotNull class_2338 pos, @NotNull class_2350 direction, @NotNull Function0<? extends class_2680> blockState2) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            Intrinsics.checkNotNullParameter(state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter(blockState2, (String)"blockState");
            if (((class_2680)blockState2.invoke()).method_26204() instanceof ItemPipeBlock) {
                class_2248 class_22482 = ((class_2680)blockState2.invoke()).method_26204();
                Intrinsics.checkNotNullExpressionValue((Object)class_22482, (String)"getBlock(...)");
                class_2338 class_23382 = pos.method_10062();
                Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"toImmutable(...)");
                network.appendPipe(class_22482, class_23382);
                state.onSet(pos, (ItemNetwork)((Network)network));
                return true;
            }
            class_2350 class_23502 = direction.method_10153();
            Intrinsics.checkNotNullExpressionValue((Object)class_23502, (String)"getOpposite(...)");
            if (ItemutilsKt.itemStorageOf(world, pos, class_23502) != null) {
                class_2350 class_23503 = direction.method_10153();
                Intrinsics.checkNotNullExpressionValue((Object)class_23503, (String)"getOpposite(...)");
                network.appendContainer(pos, class_23503);
            }
            return false;
        }

        public void deepScan(@NotNull LongOpenHashSet scanned, @NotNull Network.Type<ItemNetwork> type, @NotNull NetworkState<ItemNetwork> state, @NotNull ItemNetwork network, @NotNull class_2791 chunk, @NotNull class_3218 world, @NotNull class_2338 blockPos, @NotNull class_2338 source, @NotNull class_2350 direction) {
            NetworkFactory.DefaultImpls.deepScan(this, scanned, type, state, (Network)network, chunk, world, blockPos, source, direction);
        }

        @NotNull
        public ItemNetwork deepScan(@NotNull Network.Type<ItemNetwork> type, @NotNull class_3218 world, @NotNull class_2338 source) {
            return NetworkFactory.DefaultImpls.deepScan(this, type, world, source);
        }
    };

    @NotNull
    public static final NetworkFactory<EnergyNetwork> getENERGY_NET_FACTORY() {
        return ENERGY_NET_FACTORY;
    }

    @NotNull
    public static final NetworkFactory<FluidNetwork> getFLUID_NET_FACTORY() {
        return FLUID_NET_FACTORY;
    }

    @NotNull
    public static final NetworkFactory<ItemNetwork> getITEM_NET_FACTORY() {
        return ITEM_NET_FACTORY;
    }
}

