/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.networks.energy;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.steven.indrev.api.machines.Tier;
import me.steven.indrev.blocks.machine.pipes.CableBlock;
import me.steven.indrev.config.IRConfig;
import me.steven.indrev.networks.Network;
import me.steven.indrev.utils.EnergyutilsKt;
import me.steven.indrev.utils.HelperextensionsKt;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 92\u00020\u0001:\u00019B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u001b\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010 R\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R)\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\n\u0010&\u001a\u0004\b'\u0010(R\u0011\u0010*\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001aR\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020,0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\"\u00103\u001a\u0002028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108\u00a8\u0006:"}, d2={"Lme/steven/indrev/networks/energy/EnergyNetwork;", "Lme/steven/indrev/networks/Network;", "Lnet/minecraft/class_3218;", "world", "", "Lnet/minecraft/class_2338;", "cables", "", "Ljava/util/EnumSet;", "Lnet/minecraft/class_2350;", "machines", "<init>", "(Lnet/minecraft/class_3218;Ljava/util/Set;Ljava/util/Map;)V", "Lnet/minecraft/class_2248;", "block", "blockPos", "", "appendPipe", "(Lnet/minecraft/class_2248;Lnet/minecraft/class_2338;)V", "tick", "(Lnet/minecraft/class_3218;)V", "Ljava/util/Set;", "getCables", "()Ljava/util/Set;", "", "getCapacity", "()J", "capacity", "energy", "J", "getEnergy", "setEnergy", "(J)V", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "insertables", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "getInsertables", "()Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Ljava/util/Map;", "getMachines", "()Ljava/util/Map;", "getMaxCableTransfer", "maxCableTransfer", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "Lteam/reborn/energy/api/EnergyStorage;", "maxInputs", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "", "storages", "Ljava/util/List;", "Lme/steven/indrev/api/machines/Tier;", "tier", "Lme/steven/indrev/api/machines/Tier;", "getTier", "()Lme/steven/indrev/api/machines/Tier;", "setTier", "(Lme/steven/indrev/api/machines/Tier;)V", "Companion", "indrev"})
@SourceDebugExtension(value={"SMAP\nEnergyNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyNetwork.kt\nme/steven/indrev/networks/energy/EnergyNetwork\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 utils.kt\nme/steven/indrev/utils/UtilsKt\n*L\n1#1,102:1\n1855#2:103\n1855#2,2:104\n1856#2:106\n1855#2,2:109\n131#3:107\n131#3:108\n*S KotlinDebug\n*F\n+ 1 EnergyNetwork.kt\nme/steven/indrev/networks/energy/EnergyNetwork\n*L\n53#1:103\n55#1:104,2\n53#1:106\n75#1:109,2\n63#1:107\n74#1:108\n*E\n"})
public class EnergyNetwork
extends Network {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<class_2338> cables;
    @NotNull
    private final Map<class_2338, EnumSet<class_2350>> machines;
    @NotNull
    private Tier tier;
    @NotNull
    private final ObjectOpenHashSet<class_2338> insertables;
    private long energy;
    @NotNull
    private final Object2LongOpenHashMap<EnergyStorage> maxInputs;
    @NotNull
    private final List<EnergyStorage> storages;
    private static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFEL;

    public EnergyNetwork(@NotNull class_3218 world, @NotNull Set<class_2338> cables, @NotNull Map<class_2338, EnumSet<class_2350>> machines) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(cables, (String)"cables");
        Intrinsics.checkNotNullParameter(machines, (String)"machines");
        super(Network.Type.Companion.getENERGY(), world, cables, machines);
        this.cables = cables;
        this.machines = machines;
        this.tier = Tier.MK1;
        this.insertables = new ObjectOpenHashSet();
        this.maxInputs = new Object2LongOpenHashMap();
        this.storages = new ArrayList();
    }

    public /* synthetic */ EnergyNetwork(class_3218 class_32182, Set set, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = (Set)new ObjectOpenHashSet();
        }
        if ((n & 4) != 0) {
            map = (Map)new Object2ObjectOpenHashMap();
        }
        this(class_32182, set, map);
    }

    @NotNull
    public final Set<class_2338> getCables() {
        return this.cables;
    }

    @NotNull
    public final Map<class_2338, EnumSet<class_2350>> getMachines() {
        return this.machines;
    }

    @NotNull
    public final Tier getTier() {
        return this.tier;
    }

    public final void setTier(@NotNull Tier tier) {
        Intrinsics.checkNotNullParameter((Object)((Object)tier), (String)"<set-?>");
        this.tier = tier;
    }

    public final long getMaxCableTransfer() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.tier.ordinal()]) {
            case 1 -> IRConfig.INSTANCE.getCables().getCableMk1();
            case 2 -> IRConfig.INSTANCE.getCables().getCableMk2();
            case 3 -> IRConfig.INSTANCE.getCables().getCableMk3();
            default -> IRConfig.INSTANCE.getCables().getCableMk4();
        };
    }

    @NotNull
    public final ObjectOpenHashSet<class_2338> getInsertables() {
        return this.insertables;
    }

    public final long getEnergy() {
        return this.energy;
    }

    public final void setEnergy(long l) {
        this.energy = l;
    }

    public final long getCapacity() {
        return (long)this.getPipes().size() * this.getMaxCableTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void tick(@NotNull class_3218 world) {
        EnergyStorage storage;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (this.energy <= 0L) {
            return;
        }
        this.maxInputs.clear();
        this.storages.clear();
        Iterable $this$forEach$iv = (Iterable)this.insertables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2338 pos = (class_2338)element$iv;
            boolean bl = false;
            class_1937 class_19372 = (class_1937)world;
            Intrinsics.checkNotNull((Object)pos);
            if (!HelperextensionsKt.isLoaded(class_19372, pos)) continue;
            EnumSet<class_2350> enumSet = this.machines.get(pos);
            if (enumSet == null) continue;
            Iterable $this$forEach$iv2 = enumSet;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                class_2350 dir = (class_2350)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)dir);
                storage = EnergyutilsKt.energyOf(world, pos, dir);
                if (storage == null) continue;
                this.storages.add(storage);
            }
        }
        boolean $i$f$transaction = false;
        AutoCloseable autoCloseable = (AutoCloseable)Transaction.openOuter();
        Throwable throwable = null;
        try {
            Transaction tx22 = (Transaction)autoCloseable;
            boolean bl = false;
            Iterable $i$f$forEach2 = this.storages;
            long l = 0L;
            for (Object bl2 : $i$f$forEach2) {
                void energyStorage;
                storage = (EnergyStorage)bl2;
                long l2 = l;
                boolean bl3 = false;
                long maxInput = energyStorage.insert(0x7FFFFFFFFFFFFFFEL, (TransactionContext)tx22);
                if (maxInput > 0L) {
                    Long l3 = maxInput;
                    ((Map)this.maxInputs).put(energyStorage, l3);
                }
                long l4 = maxInput;
                l = l2 + l4;
            }
            double tx22 = l;
        }
        catch (Throwable tx22) {
            throwable = tx22;
            throw tx22;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        double totalInput = tx22;
        if (totalInput <= 0.0) {
            return;
        }
        $i$f$transaction = false;
        autoCloseable = (AutoCloseable)Transaction.openOuter();
        throwable = null;
        try {
            Transaction tx = (Transaction)autoCloseable;
            boolean bl = false;
            Iterable $this$forEach$iv3 = this.storages;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                EnergyStorage energyStorage = (EnergyStorage)element$iv;
                boolean bl4 = false;
                long maxInput = this.maxInputs.getLong((Object)energyStorage);
                if (maxInput <= 0L) continue;
                long toTransfer = RangesKt.coerceAtMost((long)RangesKt.coerceAtMost((long)((long)((double)maxInput / totalInput * (double)this.energy)), (long)this.getMaxCableTransfer()), (long)this.energy);
                this.energy -= energyStorage.insert(toTransfer, (TransactionContext)tx);
                if (this.energy > 0L) continue;
                tx.commit();
                return;
            }
            tx.commit();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void appendPipe(@NotNull class_2248 block, @NotNull class_2338 blockPos) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        CableBlock cableBlock = block instanceof CableBlock ? (CableBlock)block : null;
        if (cableBlock == null) {
            return;
        }
        CableBlock cable = cableBlock;
        this.tier = cable.getTier();
        super.appendPipe(block, blockPos);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/steven/indrev/networks/energy/EnergyNetwork$Companion;", "", "<init>", "()V", "", "MAX_VALUE", "J", "indrev"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Tier.values().length];
            try {
                nArray[Tier.MK1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.MK2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.MK3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

