/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.mixin.common;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import me.steven.indrev.api.IRServerPlayerEntityExtension;
import me.steven.indrev.items.armor.IRModularArmorItem;
import me.steven.indrev.items.energy.IRPortableChargerItem;
import me.steven.indrev.packets.client.SyncAppliedModulesPacket;
import me.steven.indrev.tools.modular.ArmorModule;
import me.steven.indrev.utils.AccessorextensionsKt;
import me.steven.indrev.utils.EnergyutilsKt;
import me.steven.indrev.utils.HelperextensionsKt;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4174;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class MixinServerPlayerEntity
extends class_1657
implements IRServerPlayerEntityExtension {
    private int ticks = 0;
    private int lastDamageTick = 0;
    private float lastDmg = 0.0f;
    private double lastShield = 0.0;
    private final Object2IntMap<ArmorModule> oldAppliedModules = new Object2IntOpenHashMap();

    public MixinServerPlayerEntity(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Shadow
    public abstract boolean method_5679(class_1282 var1);

    @Shadow
    public abstract void method_17356(class_3414 var1, class_3419 var2, float var3, float var4);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void indrev_applyEffects(CallbackInfo ci) {
        ++this.ticks;
        if (this.ticks % 15 == 0) {
            this.applyArmorEffects();
        }
        this.indrev_tickMagnet();
        this.setShieldDurability(Math.min(this.getShieldDurability(), this.getMaxShieldDurability()));
    }

    @ModifyVariable(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private float indrev_absorbDamage(float amount2, class_1282 source) {
        float initial = amount2;
        if (this.method_5679(source)) {
            return amount2;
        }
        if (this.lastDamageTick + 10 > this.ticks) {
            if (amount2 <= this.lastDmg) {
                return 0.0f;
            }
            amount2 -= this.lastDmg;
        }
        this.lastDamageTick = this.ticks;
        this.lastDmg = initial;
        if (this.shouldApplyToShield(source)) {
            float leftover = (float)this.applyDamageToShield(amount2);
            if (amount2 > leftover) {
                this.method_37908().method_43129(null, (class_1297)this, class_3417.field_24065, class_3419.field_15248, 1.0f, 1.0E-4f);
            }
            return leftover;
        }
        return amount2;
    }

    @Inject(method={"worldChanged"}, at={@At(value="TAIL")})
    private void indrev_syncOnDimChange(class_3218 origin, CallbackInfo ci) {
        this.indrev_sync();
        AccessorextensionsKt.getFluidNetworkState(origin).onDimChange(this);
        AccessorextensionsKt.getItemNetworkState(origin).onDimChange(this);
    }

    private boolean shouldApplyToShield(class_1282 source) {
        if (source.method_48789(class_8103.field_42250)) {
            return this.isApplied(ArmorModule.FEATHER_FALLING);
        }
        if (source.method_48789(class_8103.field_42246)) {
            return this.isApplied(ArmorModule.FIRE_RESISTANCE);
        }
        return !source.method_49708(class_8111.field_42343) && !source.method_48789(class_8103.field_42251);
    }

    private void applyArmorEffects() {
        class_3222 player = (class_3222)this;
        class_1661 inventory2 = player.method_31548();
        this.getAppliedModules().clear();
        for (int i = 0; i < inventory2.field_7548.size(); ++i) {
            int cSlot = 36 + i;
            class_1799 itemStack = inventory2.method_5438(cSlot);
            if (!(itemStack.method_7909() instanceof IRModularArmorItem)) continue;
            List<ArmorModule> modules = ((IRModularArmorItem)itemStack.method_7909()).getInstalled(itemStack);
            block8: for (ArmorModule module : modules) {
                int level = module.getLevel(itemStack);
                if (level <= 0) continue;
                block0 : switch (module) {
                    case SPEED: 
                    case BREATHING: 
                    case JUMP_BOOST: 
                    case NIGHT_VISION: 
                    case FIRE_RESISTANCE: 
                    case PIGLIN_TRICKER: 
                    case FEATHER_FALLING: 
                    case WATER_AFFINITY: {
                        if (!EnergyutilsKt.extract((class_1263)inventory2, cSlot, 20L)) break;
                        this.applyModule(module, level);
                        break;
                    }
                    case AUTO_FEEDER: {
                        class_1702 hunger = player.method_7344();
                        if (!hunger.method_7587()) break;
                        for (int slot = 0; slot <= inventory2.method_5439(); ++slot) {
                            class_1799 stack2 = inventory2.method_5438(slot);
                            class_4174 food = stack2.method_7909().method_19264();
                            if (food != null && !food.method_19233() && !HelperextensionsKt.hasNegativeEffects(food) && food.method_19230() <= 20 - hunger.method_7586() && EnergyutilsKt.extract((class_1263)inventory2, cSlot, 30L)) {
                                stack2.method_7910(this.method_37908(), (class_1309)player);
                                player.method_18866(this.method_37908(), stack2);
                            }
                            if (!this.field_7493.method_7587()) break block0;
                        }
                        continue block8;
                    }
                    case CHARGER: {
                        IRPortableChargerItem.Companion.chargeItemsInInv(cSlot, (class_1263)player.method_31548());
                        break;
                    }
                    case SOLAR_PANEL: {
                        if (!this.method_37908().method_8530() || !this.method_37908().method_8311(player.method_24515().method_10086(2))) break;
                        for (int x = 0; x < 4; ++x) {
                            EnergyutilsKt.insert((class_1263)inventory2, cSlot - x, 75L * (long)level);
                        }
                        continue block8;
                    }
                    case PROTECTION: {
                        if (this.ticks - 120 <= this.lastDamageTick || !(this.getShieldDurability() < this.getMaxShieldDurability()) || !EnergyutilsKt.extract((class_1263)inventory2, cSlot, 30L)) break;
                        this.regenerateShield();
                        break;
                    }
                }
            }
        }
    }

    private void indrev_tickMagnet() {
        class_3222 player = (class_3222)this;
        class_1661 inventory2 = player.method_31548();
        for (class_1799 itemStack : inventory2.field_7548) {
            int level;
            if (!(itemStack.method_7909() instanceof IRModularArmorItem) || (level = ArmorModule.MAGNET.getLevel(itemStack)) <= 0) continue;
            class_2382 offset = new class_2382(8, 8, 8);
            class_238 area = new class_238(this.method_24515().method_10059(offset), this.method_24515().method_10081(offset));
            class_243 blockCenter = HelperextensionsKt.toVec3d(this.method_24515()).method_1031(0.5, 0.5, 0.5);
            this.method_37908().method_8333((class_1297)this, area, entity -> entity instanceof class_1542 || entity instanceof class_1303).forEach(entity -> {
                block3: {
                    block2: {
                        class_1542 itemEntity;
                        if (entity instanceof class_1542 && !(itemEntity = (class_1542)entity).method_6977()) break block2;
                        if (!(entity instanceof class_1303)) break block3;
                        class_1303 xpEntity = (class_1303)entity;
                        if (xpEntity.field_6012 <= 40) break block3;
                    }
                    class_243 v = entity.method_19538().method_1035(blockCenter).method_1029().method_1021(0.2);
                    entity.method_5762(v.field_1352, v.field_1351, v.field_1350);
                }
            });
            return;
        }
    }

    private void regenerateShield() {
        this.setShieldDurability(Math.min(this.getShieldDurability() + 0.5, this.getMaxShieldDurability()));
    }

    private double applyDamageToShield(double damage) {
        double absorbed = Math.min(damage, this.getShieldDurability());
        this.setShieldDurability(this.getShieldDurability() - absorbed);
        return damage - absorbed;
    }

    @Override
    public boolean indrev_shouldSync() {
        return !this.oldAppliedModules.equals((Object)this.getAppliedModules()) || this.lastShield != this.getShieldDurability();
    }

    @Override
    public void indrev_sync() {
        this.lastShield = this.getShieldDurability();
        this.oldAppliedModules.clear();
        this.oldAppliedModules.putAll(this.getAppliedModules());
        class_2540 buf = new class_2540(Unpooled.buffer());
        Map appliedModules = this.getAppliedModules();
        buf.writeInt(appliedModules.size());
        appliedModules.forEach((module, level) -> {
            buf.writeInt(module.ordinal());
            buf.writeInt(level.intValue());
        });
        buf.writeDouble(this.getShieldDurability());
        buf.writeBoolean(this.ticks - 120 > this.lastDamageTick);
        ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)SyncAppliedModulesPacket.INSTANCE.getSYNC_MODULE_PACKET(), (class_2540)buf);
    }

    @Override
    public boolean isRegenerating() {
        return this.ticks - 120 > this.lastDamageTick;
    }
}

