/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.components;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import me.steven.indrev.blockentities.BaseBlockEntity;
import me.steven.indrev.blockentities.MachineBlockEntity;
import me.steven.indrev.blockentities.crafters.CraftingMachineBlockEntity;
import me.steven.indrev.components.CraftingComponent;
import me.steven.indrev.components.GuiSyncableComponentKt;
import me.steven.indrev.components.InventoryComponent;
import me.steven.indrev.inventories.IRInventory;
import me.steven.indrev.registry.IRItemRegistry;
import me.steven.indrev.utils.HelperextensionsKt;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001a\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\"\u0010\u001a\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u000e\"\u0004\b\u001d\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010$R\"\u0010%\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u001e\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010\u001f\u00a8\u0006+"}, d2={"Lme/steven/indrev/components/TemperatureComponent;", "", "Lme/steven/indrev/blockentities/BaseBlockEntity;", "blockEntity", "", "heatingSpeed", "Lkotlin/ranges/IntRange;", "optimalRange", "", "limit", "<init>", "(Lme/steven/indrev/blockentities/BaseBlockEntity;DLkotlin/ranges/IntRange;I)V", "", "isFullEfficiency", "()Z", "Lnet/minecraft/class_2487;", "tag", "", "readNbt", "(Lnet/minecraft/class_2487;)V", "shouldHeatUp", "tick", "(Z)V", "writeNbt", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "Lme/steven/indrev/blockentities/BaseBlockEntity;", "cooling", "Z", "getCooling", "setCooling", "D", "I", "getLimit", "()I", "Lkotlin/ranges/IntRange;", "getOptimalRange", "()Lkotlin/ranges/IntRange;", "temperature", "getTemperature", "()D", "setTemperature", "(D)V", "ticks", "indrev"})
public final class TemperatureComponent {
    @NotNull
    private final BaseBlockEntity blockEntity;
    private final double heatingSpeed;
    @NotNull
    private final IntRange optimalRange;
    private final int limit;
    private boolean cooling;
    private double temperature;
    private int ticks;

    public TemperatureComponent(@NotNull BaseBlockEntity blockEntity, double heatingSpeed, @NotNull IntRange optimalRange, int limit) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)optimalRange, (String)"optimalRange");
        this.blockEntity = blockEntity;
        this.heatingSpeed = heatingSpeed;
        this.optimalRange = optimalRange;
        this.limit = limit;
        this.cooling = true;
        this.temperature = 25.0;
        GuiSyncableComponentKt.trackInt(this.blockEntity, 2, (Function0<Integer>)((Function0)new Function0<Integer>(){

            @NotNull
            public final Integer invoke() {
                return (int)this.getTemperature();
            }
        }));
        GuiSyncableComponentKt.trackInt(this.blockEntity, 3, (Function0<Integer>)((Function0)new Function0<Integer>(){

            @NotNull
            public final Integer invoke() {
                return this.getLimit();
            }
        }));
    }

    @NotNull
    public final IntRange getOptimalRange() {
        return this.optimalRange;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final boolean getCooling() {
        return this.cooling;
    }

    public final void setCooling(boolean bl) {
        this.cooling = bl;
    }

    public final double getTemperature() {
        return this.temperature;
    }

    public final void setTemperature(double d) {
        this.temperature = d;
    }

    public final void readNbt(@Nullable class_2487 tag) {
        class_2487 class_24872 = tag;
        this.temperature = class_24872 != null ? class_24872.method_10574("Temperature") : 0.0;
        class_2487 class_24873 = tag;
        this.cooling = class_24873 != null ? class_24873.method_10577("Cooling") : false;
    }

    @NotNull
    public final class_2487 writeNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.method_10549("Temperature", this.temperature);
        tag.method_10556("Cooling", this.cooling);
        return tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFullEfficiency() {
        InventoryComponent inventoryComponent;
        MachineBlockEntity machine;
        BaseBlockEntity baseBlockEntity = this.blockEntity;
        MachineBlockEntity machineBlockEntity = machine = baseBlockEntity instanceof MachineBlockEntity ? (MachineBlockEntity)baseBlockEntity : null;
        InventoryComponent inventoryComponent2 = inventoryComponent = machineBlockEntity != null ? machineBlockEntity.getInventoryComponent() : null;
        if (this.cooling) {
            boolean bl;
            Object object = inventoryComponent;
            if (object != null && (object = ((InventoryComponent)object).getInventory()) != null && (object = ((IRInventory)((Object)object)).getCoolerStack()) != null) {
                if (object.method_7960()) {
                    return false;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return false;
        }
        IntRange intRange = this.optimalRange;
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        int n3 = (int)this.temperature;
        if (n > n3) return false;
        if (n3 > n2) return false;
        return true;
    }

    public final void tick(boolean shouldHeatUp) {
        boolean isHeatingUp;
        int n = this.ticks;
        this.ticks = n + 1;
        BaseBlockEntity baseBlockEntity = this.blockEntity;
        MachineBlockEntity machine = baseBlockEntity instanceof MachineBlockEntity ? (MachineBlockEntity)baseBlockEntity : null;
        class_1937 class_19372 = this.blockEntity.method_10997();
        Intrinsics.checkNotNull((Object)class_19372);
        class_5819 random = class_19372.field_9229;
        Object object = machine;
        IRInventory inv = object != null && (object = ((MachineBlockEntity)object).getInventoryComponent()) != null ? ((InventoryComponent)object).getInventory() : null;
        IRInventory iRInventory = inv;
        if (iRInventory == null || (iRInventory = iRInventory.getCoolerStack()) == null) {
            iRInventory = class_1799.field_8037;
        }
        IRInventory iRInventory2 = iRInventory;
        Intrinsics.checkNotNull((Object)((Object)iRInventory2));
        class_1799 coolerStack = HelperextensionsKt.component1((class_1799)iRInventory2);
        class_1792 coolerItem = HelperextensionsKt.component2((class_1799)iRInventory2);
        boolean bl = isHeatingUp = shouldHeatUp || machine != null && Intrinsics.areEqual((Object)coolerItem, (Object)IRItemRegistry.INSTANCE.getHEAT_COIL()) && machine.use(16L);
        if (this.cooling) {
            BaseBlockEntity baseBlockEntity2 = this.blockEntity;
            CraftingComponent<T>[] craftingComponentArray = baseBlockEntity2 instanceof CraftingMachineBlockEntity ? (CraftingComponent<T>[])baseBlockEntity2 : null;
            int modifier = craftingComponentArray != null && (craftingComponentArray = craftingComponentArray.getCraftingComponents()) != null ? craftingComponentArray.length : 0;
            this.temperature -= this.heatingSpeed / (double)(isHeatingUp ? 3 + modifier : 1);
            if (coolerStack.method_7963() && this.ticks % 120 == 0) {
                coolerStack.method_7970(1, random, null);
            }
            if (coolerStack.method_7919() >= coolerStack.method_7936()) {
                coolerStack.method_7934(1);
            }
            if (this.temperature <= (double)((float)this.optimalRange.getFirst() + ((float)2 * random.method_43057() - 1.0f) * (float)10)) {
                this.cooling = false;
            }
        } else if (isHeatingUp) {
            this.temperature += this.heatingSpeed;
            double n2 = (double)(this.optimalRange.getLast() + this.optimalRange.getFirst()) / 2.0;
            if (this.temperature >= n2 + (double)(((float)2 * random.method_43057() - 1.0f) * (float)15)) {
                this.cooling = true;
            }
        } else if (this.temperature > 35.0) {
            this.temperature -= this.heatingSpeed / 1.5;
        } else if (this.ticks % 15 == 0) {
            this.temperature = RangesKt.coerceIn((double)(this.temperature + (double)(((float)2 * random.method_43057() - 1.0f) / (float)2)), (double)20.0, (double)35.0);
        }
    }
}

