/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcda.config;

import chronosacaria.mcda.items.ArmorSets;
import chronosacaria.mcda.items.itemhelpers.ItemSettingsHelper;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="mcda_loot_tables")
public class McdaLootTablesConfig
implements ConfigData {
    @Comment(value="Choose whether to use tiered loot system. Default = false")
    public LinkedHashMap<ItemSettingsHelper, Boolean> enableTieredLootTables = new LinkedHashMap();
    @Comment(value="Chance to get an armor piece from chests. Default = 0.10f")
    public Float findArmorChance = Float.valueOf(0.1f);
    @Comment(value="Higher Number makes Luck give you potential for extra MCDA loot. Default = 1.2f")
    public Float bonusRollsWithLuck = Float.valueOf(1.2f);
    @Comment(value="Default, non-tiered armour spawn rates.")
    public EnumMap<ArmorSets, Integer> armorSpawnRates = new EnumMap(ArmorSets.class);
    @Comment(value="Chests for tiered spawning.")
    public LinkedHashMap<ItemSettingsHelper, String[]> commonLootTables = new LinkedHashMap();
    public LinkedHashMap<ItemSettingsHelper, String[]> uncommonLootTables = new LinkedHashMap();
    public LinkedHashMap<ItemSettingsHelper, String[]> rareLootTables = new LinkedHashMap();
    public LinkedHashMap<ItemSettingsHelper, String[]> epicLootTables = new LinkedHashMap();
    @Comment(value="Tiered armour spawn rates.")
    public LinkedHashMap<ArmorSets, Integer> armorLootTableSpawnRates = new LinkedHashMap();

    public McdaLootTablesConfig() {
        this.armorSpawnRates.put(ArmorSets.GHOSTLY, 5);
        this.armorSpawnRates.put(ArmorSets.GHOST_KINDLER, 1);
        this.armorSpawnRates.put(ArmorSets.GRIM, 5);
        this.armorSpawnRates.put(ArmorSets.DARK, 10);
        this.armorSpawnRates.put(ArmorSets.ROYAL, 5);
        this.armorSpawnRates.put(ArmorSets.TITAN, 3);
        this.armorSpawnRates.put(ArmorSets.THIEF, 10);
        this.armorSpawnRates.put(ArmorSets.PLATE, 5);
        this.armorSpawnRates.put(ArmorSets.FULL_METAL, 1);
        this.armorSpawnRates.put(ArmorSets.SNOW, 3);
        this.armorSpawnRates.put(ArmorSets.WOLF, 5);
        this.armorSpawnRates.put(ArmorSets.FOX, 1);
        this.armorSpawnRates.put(ArmorSets.REINFORCED_MAIL, 5);
        this.armorSpawnRates.put(ArmorSets.STALWART_MAIL, 1);
        this.armorSpawnRates.put(ArmorSets.SCALE_MAIL, 5);
        this.armorSpawnRates.put(ArmorSets.MERCENARY, 5);
        this.armorSpawnRates.put(ArmorSets.SPELUNKER, 5);
        this.armorSpawnRates.put(ArmorSets.CAVE_CRAWLER, 1);
        this.armorSpawnRates.put(ArmorSets.HERO, 10);
        this.armorSpawnRates.put(ArmorSets.GILDED, 10);
        this.armorSpawnRates.put(ArmorSets.TELEPORTATION, 10);
        this.armorSpawnRates.put(ArmorSets.UNSTABLE, 1);
        this.armorSpawnRates.put(ArmorSets.MYSTERY, 5);
        this.armorSpawnRates.put(ArmorSets.GREEN_MYSTERY, 5);
        this.armorSpawnRates.put(ArmorSets.BLUE_MYSTERY, 5);
        this.armorSpawnRates.put(ArmorSets.PURPLE_MYSTERY, 5);
        this.armorSpawnRates.put(ArmorSets.RED_MYSTERY, 5);
        this.armorSpawnRates.put(ArmorSets.VANGUARD, 5);
        this.enableTieredLootTables.put(ItemSettingsHelper.ENABLE_TIERED_LOOT_TABLES, false);
        this.commonLootTables.put(ItemSettingsHelper.COMMON_LOOT_TABLES, new String[]{"minecraft:chests/abandoned_mineshaft", "minecraft:chests/shipwreck_supply", "minecraft:chests/shipwreck_treasure", "minecraft:chests/desert_pyramid", "minecraft:chests/village/village_weaponsmith"});
        this.uncommonLootTables.put(ItemSettingsHelper.UNCOMMON_LOOT_TABLES, new String[]{"minecraft:chests/jungle_temple", "minecraft:chests/nether_bridge", "minecraft:chests/bastion_bridge", "minecraft:chests/bastion_other", "minecraft:chests/bastion_treasure", "minecraft:chests/ruined_portal"});
        this.rareLootTables.put(ItemSettingsHelper.RARE_LOOT_TABLES, new String[]{"minecraft:chests/underwater_ruin_small", "minecraft:chests/underwater_ruin_big", "minecraft:chests/simple_dungeon", "minecraft:chests/igloo_chest", "minecraft:chests/pillager_outpost"});
        this.epicLootTables.put(ItemSettingsHelper.EPIC_LOOT_TABLES, new String[]{"minecraft:chests/stronghold_corridor", "minecraft:chests/stronghold_crossing", "minecraft:chests/stronghold_library", "minecraft:chests/end_city_treasure"});
        for (ArmorSets armorSets : ArmorSets.values()) {
            this.armorLootTableSpawnRates.put(armorSets, 10);
        }
        this.armorLootTableSpawnRates.replace(ArmorSets.SPLENDID, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.BEEHIVE, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.HERO, 1);
        this.armorLootTableSpawnRates.replace(ArmorSets.RUGGED_CLIMBING_GEAR, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.TITAN, 1);
        this.armorLootTableSpawnRates.replace(ArmorSets.ROYAL, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.OPULENT, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.GILDED, 1);
        this.armorLootTableSpawnRates.replace(ArmorSets.TROUBADOUR, 0);
        this.armorLootTableSpawnRates.replace(ArmorSets.EMBER, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.VERDANT, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.GHOST_KINDLER, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.WITHER, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.GOURDIAN, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.CURIOUS, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.ARCHER, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.RENEGADE, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.HUNGRY_HORROR, 1);
        this.armorLootTableSpawnRates.replace(ArmorSets.RED_MYSTERY, 0);
        this.armorLootTableSpawnRates.replace(ArmorSets.MYSTERY, 0);
        this.armorLootTableSpawnRates.replace(ArmorSets.GREEN_MYSTERY, 0);
        this.armorLootTableSpawnRates.replace(ArmorSets.BLUE_MYSTERY, 0);
        this.armorLootTableSpawnRates.replace(ArmorSets.PURPLE_MYSTERY, 0);
        this.armorLootTableSpawnRates.replace(ArmorSets.SHADOW_WALKER, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.FROST_BITE, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.GOLDEN_PIGLIN, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.FULL_METAL, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.CAULDRON, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.STALWART_MAIL, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.HIGHLAND, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.STURDY_SHULKER, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.FROST, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.SOULDANCER, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.CAVE_CRAWLER, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.GLOW_SQUID, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.UNSTABLE, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.SPIDER, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.NIMBLE_TURTLE, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.BLACK_WOLF, 5);
        this.armorLootTableSpawnRates.replace(ArmorSets.FOX, 1);
        this.armorLootTableSpawnRates.replace(ArmorSets.ARCTIC_FOX, 1);
    }
}

