/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.utils.value.IntValue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import pro.mikey.justhammers.Config;
import pro.mikey.justhammers.HammerItems;
import pro.mikey.justhammers.HammerTags;
import pro.mikey.justhammers.HammersPlatform;

public class HammerItem
extends class_1810 {
    private final int depth;
    private final int radius;
    private class_6862<class_2248> blocks = class_3481.field_33715;

    public HammerItem(class_1832 tier, int radius, int depth, int level) {
        super(tier, 1, -2.8f, tier == class_1834.field_22033 ? HammerItems.DEFAULT_PROPERTIES.method_7895(HammerItem.computeDurability(tier, level)).method_24359() : HammerItems.DEFAULT_PROPERTIES.method_7895(HammerItem.computeDurability(tier, level)));
        this.depth = depth;
        this.radius = radius;
    }

    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> list, class_1836 tooltipFlag) {
        list.add((class_2561)class_2561.method_43469((String)"justhammers.tooltip.size", (Object[])new Object[]{this.radius, this.radius, this.depth}).method_27692(class_124.field_1080));
        if (Config.INSTANCE.config.disableFancyDurability()) {
            return;
        }
        int damage = Math.max(0, itemStack.method_7919());
        int maxDamage = itemStack.method_7936();
        int durabilityPercentage = (int)((float)(maxDamage - damage) / (float)maxDamage * 100.0f);
        class_124 color = class_124.field_1060;
        if (durabilityPercentage <= 50) {
            color = durabilityPercentage <= 25 ? class_124.field_1061 : class_124.field_1054;
        }
        int remaining = Math.max(0, durabilityPercentage / 20);
        class_5250 percentComponent = class_2561.method_43470((String)(HammerItem.prettyDurability(damage) + "/" + HammerItem.prettyDurability(maxDamage) + " ")).method_10852((class_2561)class_2561.method_43470((String)"*".repeat(remaining)).method_27692(color)).method_10852((class_2561)class_2561.method_43470((String)"*".repeat(5 - remaining)).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(" (" + durabilityPercentage + "%)")).method_27692(class_124.field_1080));
        list.add((class_2561)percentComponent);
    }

    private static String prettyDurability(int durability) {
        String output;
        int unitIndex;
        String[] units = new String[]{"", "k", "m"};
        double displayDurability = durability;
        int n = unitIndex = durability > 0 ? (int)(Math.log10(durability) / 3.0) : 0;
        if (unitIndex >= units.length) {
            unitIndex = units.length - 1;
        }
        if ((output = String.format("%.2f", displayDurability /= Math.pow(1000.0, unitIndex))).endsWith(".00")) {
            output = output.substring(0, output.length() - 3);
        }
        return output + units[unitIndex];
    }

    private static int computeDurability(class_1832 tier, int level) {
        int baseModified = 0;
        if (level > 1) {
            baseModified = class_1834.field_22033.method_8025();
        }
        return baseModified + ((int)((float)tier.method_8025() * 2.5f) + 200 * level) * level;
    }

    public float method_7865(class_1799 itemStack, class_2680 blockState) {
        if (Config.INSTANCE.config.allowBreaking()) {
            return super.method_7865(itemStack, blockState);
        }
        if (itemStack.method_7936() - itemStack.method_7919() <= 1) {
            return -1.0f;
        }
        return super.method_7865(itemStack, blockState);
    }

    public boolean method_7856(class_2680 blockState) {
        return this.actualIsCorrectToolForDrops(blockState);
    }

    public boolean isCorrectToolForDrops(class_1799 stack, class_2680 state) {
        return this.actualIsCorrectToolForDrops(state);
    }

    public boolean actualIsCorrectToolForDrops(class_2680 state) {
        int i = this.method_8022().method_8024();
        if (i < 3 && state.method_26164(class_3481.field_33717)) {
            return false;
        }
        if (i < 2 && state.method_26164(class_3481.field_33718)) {
            return false;
        }
        return (i >= 1 || !state.method_26164(class_3481.field_33719)) && state.method_26164(this.blocks);
    }

    public void causeAoe(class_1937 level, class_2338 pos, class_2680 state, class_1799 hammer, class_1309 livingEntity) {
        if (!(livingEntity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)livingEntity;
        if (level.field_9236 || state.method_26214((class_1922)level, pos) == 0.0f) {
            return;
        }
        if (livingEntity.method_18276()) {
            return;
        }
        class_239 pick = livingEntity.method_5745(20.0, 0.0f, false);
        if (!(pick instanceof class_3965)) {
            return;
        }
        class_3965 blockHitResult = (class_3965)pick;
        this.findAndBreakNearBlocks(blockHitResult, pos, hammer, level, livingEntity);
        if ((double)hammer.method_7919() >= (double)hammer.method_7936() * 0.95) {
            if (!hammer.method_7948().method_10545("has_been_warned")) {
                player.method_43502((class_2561)class_2561.method_43471((String)"justhammers.tooltip.durability_warning").method_27692(class_124.field_1061), true);
                hammer.method_7948().method_10556("has_been_warned", true);
            }
        } else if (hammer.method_7948().method_10545("has_been_warned")) {
            hammer.method_7948().method_10551("has_been_warned");
        }
    }

    public void findAndBreakNearBlocks(class_3965 pick, class_2338 blockPos, class_1799 hammerStack, class_1937 level, class_1309 livingEntity) {
        if (!(livingEntity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)livingEntity;
        class_2350 direction = pick.method_17780();
        class_3341 boundingBox = HammerItem.getAreaOfEffect(blockPos, direction, this.radius, this.depth);
        if (!player.method_7337() && hammerStack.method_7919() >= hammerStack.method_7936() - 1) {
            return;
        }
        int damage = 0;
        Iterator iterator = class_2338.method_23627((class_3341)boundingBox).iterator();
        HashSet<class_2338> removedPos = new HashSet<class_2338>();
        while (iterator.hasNext()) {
            boolean correctToolForDrops;
            boolean isBroken;
            class_2338 pos = (class_2338)iterator.next();
            boolean bl = isBroken = hammerStack.method_7919() + (damage + 1) >= hammerStack.method_7936() - 1;
            if (Config.INSTANCE.config.allowBreaking()) {
                boolean bl2 = isBroken = hammerStack.method_7919() + (damage + 1) >= hammerStack.method_7936();
            }
            if (!player.method_7337() && isBroken) break;
            class_2680 targetState = level.method_8320(pos);
            if (pos == blockPos || removedPos.contains(pos) || !this.canDestroy(targetState, level, pos) || !this.actualIsCorrectToolForDrops(targetState)) continue;
            int silkTouchLevel = class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)hammerStack);
            int fortuneLevel = class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)hammerStack);
            final int[] xp = new int[]{HammersPlatform.getBlockXpAmount(pos, targetState, level, fortuneLevel, silkTouchLevel)};
            EventResult eventResult = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock(level, pos, targetState, (class_3222)livingEntity, xp[0] == -1 ? null : new IntValue(){

                public void accept(int value) {
                    xp[0] = value;
                }

                public int getAsInt() {
                    return xp[0];
                }
            });
            if (eventResult.isFalse()) continue;
            int outputXpLevel = xp[0];
            if (!player.method_7337() && (correctToolForDrops = hammerStack.method_7951(targetState))) {
                targetState.method_26180((class_3218)level, pos, hammerStack, true);
                List drops = class_2248.method_9609((class_2680)targetState, (class_3218)((class_3218)level), (class_2338)pos, (class_2586)level.method_8321(pos), (class_1297)livingEntity, (class_1799)hammerStack);
                drops.forEach(e -> class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)pick.method_17780(), (class_1799)e));
                if (outputXpLevel != -1 && level.method_8450().method_8355(class_1928.field_19392)) {
                    class_1303.method_31493((class_3218)((class_3218)level), (class_243)class_243.method_24953((class_2382)blockPos), (int)outputXpLevel);
                }
            }
            removedPos.add(pos);
            targetState.method_26204().method_9585((class_1936)level, pos, targetState);
            class_2680 newState = class_2246.field_10124.method_9564();
            boolean setResult = level.method_8652(pos, newState, 3);
            if (setResult) {
                level.method_43276(class_5712.field_28165, blockPos, class_5712.class_7397.method_43286((class_1297)livingEntity, (class_2680)newState));
            }
            ++damage;
        }
        if (damage != 0 && !player.method_7337()) {
            hammerStack.method_7956(damage, livingEntity, livingEntityx -> {});
        }
    }

    public static class_3341 getAreaOfEffect(class_2338 blockPos, class_2350 direction, int radius, int depth) {
        int size = radius / 2;
        int offset = size - 1;
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11036 -> new class_3341(blockPos.method_10263() - size, blockPos.method_10264() - (direction == class_2350.field_11036 ? depth - 1 : 0), blockPos.method_10260() - size, blockPos.method_10263() + size, blockPos.method_10264() + (direction == class_2350.field_11033 ? depth - 1 : 0), blockPos.method_10260() + size);
            case class_2350.field_11043, class_2350.field_11035 -> new class_3341(blockPos.method_10263() - size, blockPos.method_10264() - size + offset, blockPos.method_10260() - (direction == class_2350.field_11035 ? depth - 1 : 0), blockPos.method_10263() + size, blockPos.method_10264() + size + offset, blockPos.method_10260() + (direction == class_2350.field_11043 ? depth - 1 : 0));
            case class_2350.field_11039, class_2350.field_11034 -> new class_3341(blockPos.method_10263() - (direction == class_2350.field_11034 ? depth - 1 : 0), blockPos.method_10264() - size + offset, blockPos.method_10260() - size, blockPos.method_10263() + (direction == class_2350.field_11039 ? depth - 1 : 0), blockPos.method_10264() + size + offset, blockPos.method_10260() + size);
        };
    }

    private boolean canDestroy(class_2680 targetState, class_1937 level, class_2338 pos) {
        if (targetState.method_26214((class_1922)level, pos) <= 0.0f) {
            return false;
        }
        if (targetState.method_26164(HammerTags.HAMMER_NO_SMASHY)) {
            return false;
        }
        return level.method_8321(pos) == null;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getRadius() {
        return this.radius;
    }
}

