/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.mikey.justhammers.HammersPlatform;

public enum Config {
    INSTANCE;

    private static final Logger LOGGER;
    public ConfigData config = new ConfigData(false, false);

    public void load() {
        Path configPath = HammersPlatform.getConfigDirectory().resolve("justhammers.json");
        if (Files.notExists(configPath, new LinkOption[0])) {
            try {
                String jsonData = new GsonBuilder().setPrettyPrinting().create().toJson((Object)this.config);
                Files.writeString(configPath, (CharSequence)jsonData, new OpenOption[0]);
            }
            catch (Exception e) {
                LOGGER.error("Failed to create default config file", (Throwable)e);
            }
            return;
        }
        try {
            String jsonData = Files.readString(configPath);
            this.config = (ConfigData)new Gson().fromJson(jsonData, ConfigData.class);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read config file", (Throwable)e);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(Config.class);
    }

    public static final class ConfigData {
        private final boolean allowBreaking;
        private final boolean disableFancyDurability;

        public ConfigData(boolean allowBreaking, boolean disableFancyDurability) {
            this.allowBreaking = allowBreaking;
            this.disableFancyDurability = disableFancyDurability;
        }

        public boolean allowBreaking() {
            return this.allowBreaking;
        }

        public boolean disableFancyDurability() {
            return this.disableFancyDurability;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ConfigData that = (ConfigData)obj;
            return this.allowBreaking == that.allowBreaking && this.disableFancyDurability == that.disableFancyDurability;
        }

        public int hashCode() {
            return Objects.hash(this.allowBreaking, this.disableFancyDurability);
        }

        public String toString() {
            return "ConfigData[allowBreaking=" + this.allowBreaking + ", disableFancyDurability=" + this.disableFancyDurability + "]";
        }
    }
}

