/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.block.entity;

import java.util.ArrayList;
import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.api.block.entity.UsesAltarPower;
import moriyashiine.bewitchment.common.BWConfig;
import moriyashiine.bewitchment.common.block.entity.WitchAltarBlockEntity;
import moriyashiine.bewitchment.common.item.TaglockItem;
import moriyashiine.bewitchment.common.misc.BWUtil;
import moriyashiine.bewitchment.common.recipe.CauldronBrewingRecipe;
import moriyashiine.bewitchment.common.recipe.OilRecipe;
import moriyashiine.bewitchment.common.registry.BWBlockEntityTypes;
import moriyashiine.bewitchment.common.registry.BWMaterials;
import moriyashiine.bewitchment.common.registry.BWObjects;
import moriyashiine.bewitchment.common.registry.BWProperties;
import moriyashiine.bewitchment.common.registry.BWRecipeTypes;
import moriyashiine.bewitchment.common.registry.BWStatusEffects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class WitchCauldronBlockEntity
extends class_2586
implements class_1263,
UsesAltarPower {
    private class_238 box;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private class_2338 altarPos = null;
    public OilRecipe oilRecipe = null;
    public Mode mode = Mode.NORMAL;
    public String name;
    public int color = 4159204;
    public int heatTimer = 0;
    private boolean loaded = false;

    public WitchCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super(BWBlockEntityTypes.WITCH_CAULDRON, pos, state);
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        this.method_11007(nbt);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("AltarPos")) {
            this.setAltarPos(class_2338.method_10092((long)nbt.method_10537("AltarPos")));
        }
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.mode = Mode.valueOf(nbt.method_10558("Mode"));
        if (nbt.method_10545("Name")) {
            this.name = nbt.method_10558("Name");
        }
        if (nbt.method_10545("Color")) {
            this.color = nbt.method_10550("Color");
        }
        this.heatTimer = nbt.method_10550("HeatTimer");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (this.getAltarPos() != null) {
            nbt.method_10544("AltarPos", this.getAltarPos().method_10063());
        }
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10582("Mode", this.mode.name);
        if (this.name != null) {
            nbt.method_10582("Name", this.name);
        }
        nbt.method_10569("Color", this.color);
        nbt.method_10569("HeatTimer", this.heatTimer);
    }

    public void sync() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    @Override
    public class_2338 getAltarPos() {
        return this.altarPos;
    }

    @Override
    public void setAltarPos(class_2338 pos) {
        this.altarPos = pos;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, WitchCauldronBlockEntity blockEntity) {
        if (world != null) {
            if (!blockEntity.loaded) {
                blockEntity.method_5431();
                blockEntity.box = new class_238(pos).method_1011(0.75);
                blockEntity.oilRecipe = world.method_8433().method_30027(BWRecipeTypes.OIL_RECIPE_TYPE).stream().filter(recipe -> recipe.method_8115(blockEntity, world)).findFirst().orElse(null);
                blockEntity.loaded = true;
            }
            blockEntity.heatTimer = class_3532.method_15340((int)(blockEntity.heatTimer + ((Boolean)state.method_11654((class_2769)class_2741.field_12548) != false && (Integer)state.method_11654((class_2769)BWProperties.LEVEL) > 0 ? 1 : -1)), (int)0, (int)160);
            if (!world.field_9236 && blockEntity.heatTimer >= 60 && (Integer)state.method_11654((class_2769)BWProperties.LEVEL) > 0) {
                if (world.field_9229.method_43057() <= 0.075f) {
                    world.method_8396(null, pos, class_3417.field_15161, class_3419.field_15245, 0.33333334f, blockEntity.mode == Mode.FAILED ? 0.5f : 1.0f);
                }
                if (world.method_8510() % 5L == 0L) {
                    world.method_18023((class_5575)class_1299.field_6052, blockEntity.box, entity -> true).forEach(itemEntity -> {
                        if (itemEntity.method_6983().method_7909() == BWObjects.WOOD_ASH || (Integer)state.method_11654((class_2769)BWProperties.LEVEL) == 3) {
                            world.method_8396(null, pos, class_3417.field_14737, class_3419.field_15245, 0.33333334f, 1.0f);
                            class_1799 stack = itemEntity.method_6983();
                            if (stack.method_7909().method_7857()) {
                                class_1542 remainder = new class_1542(world, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, new class_1799((class_1935)stack.method_7909().method_7858()));
                                remainder.method_18799(class_243.field_1353);
                                remainder.method_5875(true);
                                world.method_8649((class_1297)remainder);
                            }
                            blockEntity.mode = blockEntity.insertStack(stack.method_7971(1));
                            blockEntity.method_5431();
                            blockEntity.syncCauldron();
                        }
                    });
                }
            }
        }
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public boolean method_5443(class_1657 player) {
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) < 16.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public void syncCauldron() {
        this.sync();
    }

    public void setColor(int color) {
        if (this.field_11863 != null) {
            this.color = color;
        }
    }

    public Mode reset() {
        if (this.field_11863 != null) {
            this.setColor(4159204);
            this.method_5448();
            this.oilRecipe = null;
            this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)BWProperties.LEVEL, (Comparable)Integer.valueOf(0)));
        }
        return Mode.NORMAL;
    }

    public Mode fail() {
        this.setColor(7029795);
        return Mode.FAILED;
    }

    private int getFirstEmptySlot() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    private Mode insertStack(class_1799 stack) {
        if (this.field_11863 != null) {
            int firstEmpty;
            if (stack.method_7909() == BWObjects.WOOD_ASH) {
                Mode reset = this.reset();
                this.syncCauldron();
                return reset;
            }
            if (this.mode != Mode.FAILED && this.mode != Mode.TELEPORTATION && (firstEmpty = this.getFirstEmptySlot()) != -1) {
                this.method_5447(firstEmpty, stack);
                if (this.mode == Mode.NORMAL && stack.method_7909() == BWObjects.MANDRAKE_ROOT) {
                    this.method_5448();
                    return Mode.BREWING;
                }
                if (this.mode == Mode.BREWING) {
                    class_2338 altarPos;
                    CauldronBrewingRecipe cauldronBrewingRecipe = this.field_11863.method_8433().method_30027(BWRecipeTypes.CAULDRON_BREWING_RECIPE_TYPE).stream().filter(recipe -> recipe.input.method_8093(stack)).findFirst().orElse(null);
                    if ((this.isRecipeValid(cauldronBrewingRecipe) || stack.method_7909() == class_1802.field_8725 || stack.method_7909() == class_1802.field_8601) && (altarPos = this.getAltarPos()) != null && ((WitchAltarBlockEntity)this.field_11863.method_8321(altarPos)).drain(this.getBrewCost(), true)) {
                        this.setColor(class_1844.method_8064((class_1799)this.getPotion(null)));
                        return Mode.BREWING;
                    }
                } else {
                    this.oilRecipe = this.field_11863.method_8433().method_30027(BWRecipeTypes.OIL_RECIPE_TYPE).stream().filter(recipe -> recipe.method_8115(this, this.field_11863)).findFirst().orElse(null);
                    if (this.oilRecipe != null) {
                        this.setColor(this.oilRecipe.color);
                        return Mode.OIL_CRAFTING;
                    }
                    if (firstEmpty == 0 && stack.method_7909() == class_1802.field_8634) {
                        this.method_5448();
                        this.setColor(3250825);
                        return Mode.TELEPORTATION;
                    }
                    this.setColor(0xFC00FC);
                    return Mode.OIL_CRAFTING;
                }
            }
        }
        return this.fail();
    }

    public class_1799 getPotion(class_1309 creator) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8574);
        if (this.field_11863 != null) {
            int i;
            class_1657 player;
            ArrayList<class_1293> effects = new ArrayList<class_1293>();
            int durationBoost = creator != null && BWUtil.getArmorPieces(creator, armorStack -> {
                class_1738 armorItem;
                class_1792 patt0$temp = armorStack.method_7909();
                return patt0$temp instanceof class_1738 && (armorItem = (class_1738)patt0$temp).method_7686() == BWMaterials.ALCHEMIST_ARMOR;
            }) >= 3 ? 1 : 0;
            int amplifierBoost = 0;
            boolean leonard = creator instanceof class_1657 && BewitchmentAPI.isPledged(player = (class_1657)creator, "pledge.bewitchment.leonard");
            for (i = 0; i < this.method_5439(); ++i) {
                CauldronBrewingRecipe cauldronBrewingRecipe;
                class_1799 stackInSlot = this.method_5438(i);
                if (stackInSlot.method_7909() instanceof TaglockItem && TaglockItem.isTaglockFromPlayer(stackInSlot)) {
                    stack.method_7948().method_25927("PolymorphUUID", TaglockItem.getTaglockUUID(stackInSlot));
                    stack.method_7948().method_10582("PolymorphName", TaglockItem.getTaglockName(stackInSlot));
                }
                if ((cauldronBrewingRecipe = (CauldronBrewingRecipe)this.field_11863.method_8433().method_30027(BWRecipeTypes.CAULDRON_BREWING_RECIPE_TYPE).stream().filter(recipe -> recipe.input.method_8093(stackInSlot)).findFirst().orElse(null)) != null && effects.stream().noneMatch(effect -> effect.method_5579() == cauldronBrewingRecipe.output)) {
                    effects.add(new class_1293(cauldronBrewingRecipe.output, cauldronBrewingRecipe.time));
                    continue;
                }
                if (stackInSlot.method_7909() == class_1802.field_8725) {
                    ++durationBoost;
                    continue;
                }
                if (stackInSlot.method_7909() != class_1802.field_8601) continue;
                ++amplifierBoost;
            }
            for (i = 0; i < effects.size(); ++i) {
                int duration;
                class_1291 type;
                int j;
                for (j = 0; j < durationBoost; ++j) {
                    type = ((class_1293)effects.get(i)).method_5579();
                    duration = ((class_1293)effects.get(i)).method_5584();
                    effects.set(i, new class_1293(type, type.method_5561() ? duration : duration * 2));
                }
                for (j = 0; j < amplifierBoost && j < 2 && (j != 1 || leonard); ++j) {
                    type = ((class_1293)effects.get(i)).method_5579();
                    duration = ((class_1293)effects.get(i)).method_5584();
                    effects.set(i, new class_1293(type, type.method_5561() ? duration : duration / 2, ((class_1293)effects.get(i)).method_5578() + 1));
                }
            }
            ArrayList<class_1293> finalEffects = new ArrayList<class_1293>();
            for (int i2 = effects.size() - 1; i2 >= 0; --i2) {
                if (((class_1293)effects.get(i2)).method_5579() == BWStatusEffects.CORRUPTION) {
                    finalEffects.add((class_1293)effects.remove(i2));
                    continue;
                }
                if (((class_1293)effects.get(i2)).method_5579() != BWStatusEffects.POLYMORPH) continue;
                class_1293 removed = (class_1293)effects.remove(i2);
                finalEffects.add(new class_1293(removed.method_5579(), removed.method_5584(), removed.method_5578(), removed.method_5591(), false, removed.method_5592()));
            }
            finalEffects.addAll(effects);
            class_1844.method_8056((class_1799)stack, finalEffects);
            stack.method_7948().method_10569("CustomPotionColor", class_1844.method_8055(finalEffects));
            stack.method_7948().method_10556("BewitchmentBrew", true);
        }
        return stack;
    }

    public int getBrewCost() {
        int cost = 0;
        for (int i = 0; i < this.method_5439(); ++i) {
            if (this.method_5438(i).method_7960()) continue;
            cost += 150;
        }
        return cost;
    }

    public int getTargetLevel(class_1799 stack) {
        class_1792 item = stack.method_7909();
        int level = (Integer)this.method_11010().method_11654((class_2769)BWProperties.LEVEL);
        if (this.mode == Mode.NORMAL) {
            if (item == class_1802.field_8550 && level == 3) {
                return 0;
            }
            if (item == class_1802.field_8705 && level == 0) {
                return 3;
            }
            if (item == class_1802.field_8469) {
                return level - 1;
            }
            if (item == class_1802.field_8574 && level < 3 && class_1844.method_8063((class_1799)stack) == class_1847.field_8991) {
                return level + 1;
            }
        } else if (this.mode == Mode.OIL_CRAFTING ? this.oilRecipe != null && item == class_1802.field_8469 : this.mode == Mode.BREWING && item == class_1802.field_8469) {
            return level - 1;
        }
        return -1;
    }

    private boolean isRecipeValid(CauldronBrewingRecipe cauldronBrewingRecipe) {
        if (cauldronBrewingRecipe == null) {
            return false;
        }
        return BWConfig.enablePolymorph || cauldronBrewingRecipe.output != BWStatusEffects.POLYMORPH;
    }

    public static enum Mode {
        NORMAL("NORMAL"),
        OIL_CRAFTING("OIL_CRAFTING"),
        BREWING("BREWING"),
        TELEPORTATION("TELEPORTATION"),
        FAILED("FAILED");

        public final String name;

        private Mode(String name) {
            this.name = name;
        }
    }
}

