/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.api;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import moriyashiine.bewitchment.api.component.MagicComponent;
import moriyashiine.bewitchment.api.component.PledgeComponent;
import moriyashiine.bewitchment.api.component.TransformationComponent;
import moriyashiine.bewitchment.api.item.PoppetItem;
import moriyashiine.bewitchment.api.misc.PoppetData;
import moriyashiine.bewitchment.api.registry.AltarMapEntry;
import moriyashiine.bewitchment.common.BWConfig;
import moriyashiine.bewitchment.common.block.entity.PoppetShelfBlockEntity;
import moriyashiine.bewitchment.common.component.entity.AdditionalWerewolfDataComponent;
import moriyashiine.bewitchment.common.entity.living.VampireEntity;
import moriyashiine.bewitchment.common.entity.living.WerewolfEntity;
import moriyashiine.bewitchment.common.entity.living.util.BWHostileEntity;
import moriyashiine.bewitchment.common.entity.projectile.SilverArrowEntity;
import moriyashiine.bewitchment.common.item.AthameItem;
import moriyashiine.bewitchment.common.item.TaglockItem;
import moriyashiine.bewitchment.common.registry.BWComponents;
import moriyashiine.bewitchment.common.registry.BWEntityTypes;
import moriyashiine.bewitchment.common.registry.BWObjects;
import moriyashiine.bewitchment.common.registry.BWStatusEffects;
import moriyashiine.bewitchment.common.registry.BWTags;
import moriyashiine.bewitchment.common.registry.BWTransformations;
import moriyashiine.bewitchment.common.world.BWUniversalWorldState;
import moriyashiine.bewitchment.common.world.BWWorldState;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1420;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_2586;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3545;
import net.minecraft.class_7923;

public class BewitchmentAPI {
    public static final Set<AltarMapEntry> ALTAR_MAP_ENTRIES = new HashSet<AltarMapEntry>();
    public static final class_1310 DEMON = new class_1310();
    public static class_3222 fakePlayer = null;

    public static class_1309 getTaglockOwner(class_1937 world, class_1799 taglock) {
        if (world instanceof class_3218 && (taglock.method_7909() instanceof TaglockItem || taglock.method_7909() instanceof PoppetItem) && TaglockItem.hasTaglock(taglock)) {
            UUID ownerUUID = TaglockItem.getTaglockUUID(taglock);
            for (class_3218 serverWorld : world.method_8503().method_3738()) {
                class_1309 livingEntity;
                class_1297 class_12972 = serverWorld.method_14190(ownerUUID);
                if (!(class_12972 instanceof class_1309) || !(livingEntity = (class_1309)class_12972).method_5805()) continue;
                return livingEntity;
            }
        }
        return null;
    }

    public static PoppetData getPoppetFromInventory(class_1937 world, PoppetItem item, class_1297 owner, List<class_1799> inventory) {
        if (inventory == null) {
            return PoppetData.EMPTY;
        }
        for (int i = 0; i < inventory.size(); ++i) {
            class_1799 stack = inventory.get(i);
            if (BWConfig.disabledPoppets.contains(class_7923.field_41178.method_10221((Object)stack.method_7909()).toString()) || stack.method_7909() != item || !TaglockItem.hasTaglock(stack)) continue;
            UUID uuid = null;
            if (owner != null) {
                uuid = owner.method_5667();
            } else {
                class_1309 taglockOwner = BewitchmentAPI.getTaglockOwner(world, stack);
                if (taglockOwner != null) {
                    uuid = taglockOwner.method_5667();
                }
            }
            if (!TaglockItem.getTaglockUUID(stack).equals(uuid)) continue;
            return new PoppetData(stack, null, i);
        }
        return PoppetData.EMPTY;
    }

    public static PoppetData getPoppet(class_1937 world, PoppetItem item, class_1297 owner) {
        if (world.field_9236) {
            return PoppetData.EMPTY;
        }
        class_3218 serverWorld = (class_3218)world;
        if (item.worksInShelf) {
            for (class_3218 foundWorld : serverWorld.method_8503().method_3738()) {
                for (Map.Entry<Long, class_2371<class_1799>> entry : BWWorldState.get((class_1937)foundWorld).poppetShelves.entrySet()) {
                    class_2586 class_25862;
                    PoppetData result = BewitchmentAPI.getPoppetFromInventory((class_1937)foundWorld, item, owner, (List)entry.getValue());
                    if (result == PoppetData.EMPTY) continue;
                    class_2338 pos = class_2338.method_10092((long)entry.getKey());
                    if (foundWorld.method_22340(pos) && (class_25862 = foundWorld.method_8321(pos)) instanceof PoppetShelfBlockEntity) {
                        PoppetShelfBlockEntity poppetShelf = (PoppetShelfBlockEntity)class_25862;
                        poppetShelf.sync();
                    }
                    return new PoppetData(result.stack(), entry.getKey(), result.index());
                }
            }
        }
        for (class_1657 player : serverWorld.method_8503().method_3760().method_14571()) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>((Collection<class_1799>)player.method_31548().field_7547);
            stacks.add(player.method_6079());
            PoppetData result = BewitchmentAPI.getPoppetFromInventory(player.method_37908(), item, owner, stacks);
            if (result == PoppetData.EMPTY) continue;
            return result;
        }
        return PoppetData.EMPTY;
    }

    public static class_3222 getFakePlayer(class_1937 world) {
        if (!world.field_9236) {
            if (fakePlayer == null) {
                fakePlayer = new class_3222(world.method_8503(), (class_3218)world, new GameProfile(UUID.randomUUID(), "FAKE_PLAYER"));
                BewitchmentAPI.fakePlayer.field_13987 = new class_3244(world.method_8503(), new class_2535(class_2598.field_11941), fakePlayer);
                class_1799 axe = new class_1799((class_1935)class_1802.field_8406);
                axe.method_7948().method_10556("Unbreakable", true);
                fakePlayer.method_6122(class_1268.field_5808, axe);
            }
            return fakePlayer;
        }
        return null;
    }

    public static class_1309 getTransformedPlayerEntity(class_1657 player) {
        if (BewitchmentAPI.isVampire((class_1297)player, false)) {
            class_1420 entity = (class_1420)class_1299.field_6108.method_5883(player.method_37908());
            entity.method_6449(false);
            return entity;
        }
        if (BewitchmentAPI.isWerewolf((class_1297)player, false)) {
            WerewolfEntity entity = (WerewolfEntity)BWEntityTypes.WEREWOLF.method_5883(player.method_37908());
            entity.method_5841().method_12778(BWHostileEntity.VARIANT, (Object)((AdditionalWerewolfDataComponent)BWComponents.ADDITIONAL_WEREWOLF_DATA_COMPONENT.get((Object)player)).getVariant());
            return entity;
        }
        return null;
    }

    public static class_1299<?> getFamiliar(class_1657 player) {
        if (!player.method_37908().field_9236) {
            BWUniversalWorldState universalWorldState = BWUniversalWorldState.get(player.method_37908());
            for (class_3545<UUID, class_2487> pair : universalWorldState.familiars) {
                if (!player.method_5667().equals(pair.method_15442())) continue;
                return (class_1299)class_7923.field_41177.method_10223(new class_2960(((class_2487)pair.method_15441()).method_10558("id")));
            }
        }
        return null;
    }

    public static boolean fillMagic(class_1657 player, int amount, boolean simulate) {
        if (player.method_37908().field_9236) {
            return false;
        }
        return ((MagicComponent)BWComponents.MAGIC_COMPONENT.get((Object)player)).fillMagic(amount, simulate);
    }

    public static boolean drainMagic(class_1657 player, int amount, boolean simulate) {
        if (player.method_37908().field_9236) {
            return false;
        }
        if (player.method_7337()) {
            return true;
        }
        if (player.method_6059(BWStatusEffects.INHIBITED)) {
            return false;
        }
        return ((MagicComponent)BWComponents.MAGIC_COMPONENT.get((Object)player)).drainMagic(amount, simulate);
    }

    public static boolean isVampire(class_1297 entity, boolean includeHumanForm) {
        class_1657 player;
        TransformationComponent transformationComponent;
        if (entity instanceof class_1657 && (transformationComponent = (TransformationComponent)BWComponents.TRANSFORMATION_COMPONENT.get((Object)(player = (class_1657)entity))).getTransformation() == BWTransformations.VAMPIRE) {
            return includeHumanForm || transformationComponent.isAlternateForm();
        }
        return entity instanceof VampireEntity;
    }

    public static boolean isWerewolf(class_1297 entity, boolean includeHumanForm) {
        class_1657 player;
        TransformationComponent transformationComponent;
        if (entity instanceof class_1657 && (transformationComponent = (TransformationComponent)BWComponents.TRANSFORMATION_COMPONENT.get((Object)(player = (class_1657)entity))).getTransformation() == BWTransformations.WEREWOLF) {
            return includeHumanForm || transformationComponent.isAlternateForm();
        }
        return entity instanceof WerewolfEntity;
    }

    public static boolean isSourceFromSilver(class_1282 source) {
        class_1309 livingEntity;
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_6047().method_7909() instanceof AthameItem) {
            return true;
        }
        return source.method_5526() instanceof SilverArrowEntity;
    }

    public static boolean isWeakToSilver(class_1309 livingEntity) {
        if (livingEntity.method_5864().method_20210(BWTags.IMMUNE_TO_SILVER)) {
            return false;
        }
        return livingEntity.method_5999() || livingEntity.method_6046() == DEMON || livingEntity.method_5864().method_20210(BWTags.VULNERABLE_TO_SILVER);
    }

    public static boolean isPledged(class_1657 player, String pledge) {
        PledgeComponent pledgeComponent = (PledgeComponent)BWComponents.PLEDGE_COMPONENT.get((Object)player);
        if (!player.method_37908().field_9236) {
            BWUniversalWorldState universalWorldState = BWUniversalWorldState.get(player.method_5770());
            for (int i = universalWorldState.pledgesToRemove.size() - 1; i >= 0; --i) {
                if (!universalWorldState.pledgesToRemove.get(i).equals(player.method_5667())) continue;
                pledgeComponent.setPledgeNextTick("pledge.none");
                universalWorldState.pledgesToRemove.remove(i);
                return false;
            }
        }
        return pledgeComponent.getPledge().equals(pledge);
    }

    public static boolean hasVoodooProtection(class_1309 living, int damage) {
        PoppetData poppetData = BewitchmentAPI.getPoppet(living.method_37908(), BWObjects.VOODOO_PROTECTION_POPPET, (class_1297)living);
        if (!poppetData.stack().method_7960()) {
            boolean sync = false;
            if (poppetData.stack().method_7970(damage, living.method_6051(), null) && poppetData.stack().method_7919() >= poppetData.stack().method_7936()) {
                poppetData.stack().method_7934(1);
                sync = true;
            }
            poppetData.update(living.method_37908(), sync);
            return true;
        }
        return false;
    }

    public static void unpledge(class_1657 player) {
        ((PledgeComponent)BWComponents.PLEDGE_COMPONENT.get((Object)player)).setPledge("pledge.none");
    }

    public static int getMoonPhase(class_1936 world) {
        return world.method_8597().method_28531(world.method_30271());
    }

    public static void registerAltarMapEntries(class_2248[] ... altarArray) {
        for (class_2248[] altars : altarArray) {
            ALTAR_MAP_ENTRIES.add(new AltarMapEntry(altars[0], altars[1], class_2246.field_28680.method_8389()));
        }
        for (int i = 0; i < 16; ++i) {
            class_1792 carpet = switch (class_1767.method_7791((int)i)) {
                default -> throw new IncompatibleClassChangeError();
                case class_1767.field_7952 -> class_1802.field_8850;
                case class_1767.field_7946 -> class_1802.field_8683;
                case class_1767.field_7958 -> class_1802.field_8384;
                case class_1767.field_7951 -> class_1802.field_8078;
                case class_1767.field_7947 -> class_1802.field_8142;
                case class_1767.field_7961 -> class_1802.field_8253;
                case class_1767.field_7954 -> class_1802.field_8580;
                case class_1767.field_7944 -> class_1802.field_8875;
                case class_1767.field_7967 -> class_1802.field_8654;
                case class_1767.field_7955 -> class_1802.field_8290;
                case class_1767.field_7945 -> class_1802.field_8098;
                case class_1767.field_7966 -> class_1802.field_8115;
                case class_1767.field_7957 -> class_1802.field_8294;
                case class_1767.field_7942 -> class_1802.field_8664;
                case class_1767.field_7964 -> class_1802.field_8482;
                case class_1767.field_7963 -> class_1802.field_8611;
            };
            for (class_2248[] altars : altarArray) {
                ALTAR_MAP_ENTRIES.add(new AltarMapEntry(altars[0], altars[i + 2], carpet));
            }
        }
        for (class_2248[] altars : altarArray) {
            ALTAR_MAP_ENTRIES.add(new AltarMapEntry(altars[0], altars[18], BWObjects.HEDGEWITCH_CARPET.method_8389()));
            ALTAR_MAP_ENTRIES.add(new AltarMapEntry(altars[0], altars[19], BWObjects.ALCHEMIST_CARPET.method_8389()));
            ALTAR_MAP_ENTRIES.add(new AltarMapEntry(altars[0], altars[20], BWObjects.BESMIRCHED_CARPET.method_8389()));
        }
    }
}

