/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.capability.v2;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.capability.v2.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v2.data.CapabilityKey;
import fuzs.puzzleslib.api.capability.v2.data.PlayerCapabilityKey;
import fuzs.puzzleslib.api.capability.v2.data.PlayerRespawnCopyStrategy;
import fuzs.puzzleslib.api.capability.v2.data.SyncStrategy;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

public interface CapabilityController {
    @ApiStatus.Internal
    public static final Map<class_2960, CapabilityKey<?>> CAPABILITY_KEY_REGISTRY = Maps.newConcurrentMap();
    @ApiStatus.Internal
    public static final Set<Class<?>> VALID_CAPABILITY_TYPES = Set.of(class_1297.class, class_2586.class, class_2818.class, class_1937.class);

    @ApiStatus.Internal
    public static <T extends CapabilityComponent> void submit(CapabilityKey<T> capabilityKey) {
        if (CAPABILITY_KEY_REGISTRY.put(capabilityKey.getId(), capabilityKey) != null) {
            throw new IllegalStateException("Duplicate capability %s".formatted(capabilityKey.getId()));
        }
    }

    @ApiStatus.Internal
    public static CapabilityKey<?> retrieve(class_2960 id) {
        CapabilityKey<?> capabilityKey = CAPABILITY_KEY_REGISTRY.get(id);
        if (capabilityKey != null) {
            return capabilityKey;
        }
        throw new IllegalStateException("No capability registered for id %s".formatted(id));
    }

    public static CapabilityController from(String modId) {
        return ModContext.get(modId).getCapabilityControllerV2();
    }

    public <T extends class_1297, C extends CapabilityComponent> CapabilityKey<C> registerEntityCapability(String var1, Class<C> var2, Function<T, C> var3, Class<T> var4);

    public <C extends CapabilityComponent> PlayerCapabilityKey<C> registerPlayerCapability(String var1, Class<C> var2, Function<class_1657, C> var3, PlayerRespawnCopyStrategy var4);

    public <C extends CapabilityComponent> PlayerCapabilityKey<C> registerPlayerCapability(String var1, Class<C> var2, Function<class_1657, C> var3, PlayerRespawnCopyStrategy var4, SyncStrategy var5);

    public <T extends class_2586, C extends CapabilityComponent> CapabilityKey<C> registerBlockEntityCapability(String var1, Class<C> var2, Function<T, C> var3, Class<T> var4);

    public <C extends CapabilityComponent> CapabilityKey<C> registerLevelChunkCapability(String var1, Class<C> var2, Function<class_2791, C> var3);

    public <C extends CapabilityComponent> CapabilityKey<C> registerLevelCapability(String var1, Class<C> var2, Function<class_1937, C> var3);
}

