/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5365;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.ironchests.api.chesttype.ChestBlockType;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.client.IronChestsClient;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlock;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;
import tech.thatgravyboat.ironchests.common.blocks.LockState;

public class ChestRenderer<T extends GenericChestBlockEntity>
implements class_827<T> {
    private class_1087 lid;
    private class_1087 base;
    private static class_1087 lockUnlocked;
    private static class_1087 lockLocked;
    private final ChestType type;

    public ChestRenderer(ChestType type) {
        this.type = type;
    }

    public void render(@NotNull T chest, float f, @NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, int i, int j) {
        class_3695 profiler = class_310.method_1551().method_16011();
        profiler.method_15396("ironchestRenderer");
        class_776 blockRenderer = class_310.method_1551().method_1541();
        this.initModels(blockRenderer);
        if (!(chest.method_11010().method_26204() instanceof GenericChestBlock)) {
            return;
        }
        poseStack.method_22903();
        RenderSystem.enableDepthTest();
        poseStack.method_22904(0.5, 1.0, 0.5);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-((class_2350)chest.method_11010().method_11654(GenericChestBlock.getFacingProperty(this.type))).method_10144()));
        poseStack.method_22904(-0.5, -1.0, -0.5);
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.63, 0.065);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(-((GenericChestBlockEntity)chest).getOpenness(f)));
        poseStack.method_22904(0.0, -0.63, -0.065);
        if (this.type.blockType() == ChestBlockType.CHEST) {
            class_1921 renderType = this.type.transparent() ? class_4722.method_24076() : class_4722.method_24074();
            ChestRenderer.renderBlock(poseStack, multiBufferSource, renderType, this.lid, i);
            poseStack.method_22909();
            ChestRenderer.renderBlock(poseStack, multiBufferSource, renderType, this.base, i);
            if (((LockState)((Object)chest.method_11010().method_11654(GenericChestBlock.LOCK))).equals((Object)LockState.LOCKED)) {
                ChestRenderer.renderBlock(poseStack, multiBufferSource, class_4722.method_24074(), lockLocked, i);
            } else if (((LockState)((Object)chest.method_11010().method_11654(GenericChestBlock.LOCK))).equals((Object)LockState.UNLOCKED)) {
                ChestRenderer.renderBlock(poseStack, multiBufferSource, class_4722.method_24074(), lockUnlocked, i);
            }
        } else {
            poseStack.method_22909();
        }
        profiler.method_15396("renderItems");
        if (this.type.renderItems() && (((class_5365)class_310.method_1551().field_1690.method_42534().method_41753()).equals((Object)class_5365.field_25429) || ((GenericChestBlockEntity)chest).getOpenness(f) > 0.0f || this.type.blockType() != ChestBlockType.CHEST)) {
            this.renderItems(poseStack, (GenericChestBlockEntity)chest, f, multiBufferSource, i);
        }
        profiler.method_15407();
        poseStack.method_22909();
        profiler.method_15407();
    }

    private static void renderBlock(class_4587 poseStack, class_4597 multiBufferSource, class_1921 renderType, class_1087 model, int i) {
        class_310.method_1551().method_1541().method_3350().method_3367(poseStack.method_23760(), multiBufferSource.getBuffer(renderType), null, model, 1.0f, 1.0f, 1.0f, i, class_4608.field_21444);
    }

    private void initModels(class_776 dispatcher) {
        if (this.base == null) {
            this.base = IronChestsClient.loadModel(dispatcher, new class_2960("ironchests", "block/chests/" + this.type.name().toLowerCase(Locale.ROOT) + "_chest_base"));
        }
        if (this.lid == null) {
            this.lid = IronChestsClient.loadModel(dispatcher, new class_2960("ironchests", "block/chests/" + this.type.name().toLowerCase(Locale.ROOT) + "_chest_lid"));
        }
        ChestRenderer.checkAndUpdateLocks(dispatcher);
    }

    private static void checkAndUpdateLocks(class_776 dispatcher) {
        if (lockUnlocked == null) {
            lockUnlocked = IronChestsClient.loadModel(dispatcher, new class_2960("ironchests", "block/unlocked"));
        }
        if (lockLocked == null) {
            lockLocked = IronChestsClient.loadModel(dispatcher, new class_2960("ironchests", "block/locked"));
        }
    }

    private void renderItems(class_4587 poseStack, GenericChestBlockEntity blockEntity, float tickDelta, class_4597 vertexConsumers, int light) {
        class_2371<class_1799> inv = blockEntity.method_11282();
        poseStack.method_22904(0.26, 0.2, 0.26);
        if (blockEntity.method_10997() == null) {
            return;
        }
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (((class_1799)inv.get(index)).method_7909() != class_1802.field_8162) {
                    this.renderItem(0.24 * (double)i, 0.0, 0.24 * (double)j, (class_1799)inv.get(index), poseStack, (float)blockEntity.method_10997().method_8510() + tickDelta, vertexConsumers, light);
                }
                if (((class_1799)inv.get(++index)).method_7909() != class_1802.field_8162) {
                    this.renderItem(0.24 * (double)i, 0.2f, 0.24 * (double)j, (class_1799)inv.get(index), poseStack, (float)blockEntity.method_10997().method_8510() + tickDelta, vertexConsumers, light);
                }
                ++index;
            }
        }
    }

    private void renderItem(double x, double y, double z, class_1799 stack, class_4587 matrices, float rotation, class_4597 vertexConsumers, int light) {
        class_918 renderer = class_310.method_1551().method_1480();
        matrices.method_22903();
        matrices.method_22904(x, y, z);
        matrices.method_22905(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotation));
        renderer.method_23178(stack, class_811.field_4318, light, class_4608.field_21444, matrices, vertexConsumers, (class_1937)class_310.method_1551().field_1687, 0);
        matrices.method_22909();
    }
}

