/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import fuzs.mutantmonsters.client.MutantMonstersClient;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.client.renderer.entity.AlternateMobRenderer;
import fuzs.mutantmonsters.client.renderer.entity.layers.EndersoulLayer;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4048;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_566;
import net.minecraft.class_583;
import net.minecraft.class_776;
import net.minecraft.class_7833;

public class MutantEndermanRenderer
extends AlternateMobRenderer<MutantEnderman, class_583<MutantEnderman>> {
    private static final class_2960 TEXTURE = MutantMonstersClient.entityTexture("mutant_enderman/mutant_enderman");
    private static final class_2960 DEATH_TEXTURE = MutantMonstersClient.entityTexture("mutant_enderman/death");
    private static final class_1921 EYES_RENDER_TYPE = MutantRenderTypes.eyes(MutantMonstersClient.entityTexture("mutant_enderman/eyes"));
    private static final class_1921 DEATH_RENDER_TYPE = class_1921.method_23586((class_2960)TEXTURE);
    private final MutantEndermanModel endermanModel;
    private final class_566<MutantEnderman> cloneModel;
    private boolean teleportAttack;

    public MutantEndermanRenderer(class_5617.class_5618 context) {
        super(context, new MutantEndermanModel(context.method_32167(ClientModRegistry.MUTANT_ENDERMAN)), 0.8f);
        this.endermanModel = (MutantEndermanModel)this.field_4737;
        this.cloneModel = new class_566(context.method_32167(ClientModRegistry.ENDERMAN_CLONE));
        this.method_4046(new EyesLayer((class_3883<MutantEnderman, class_583<MutantEnderman>>)this));
        this.method_4046(new SoulLayer((class_3883<MutantEnderman, class_583<MutantEnderman>>)this));
        this.method_4046(new HeldBlocksLayer((class_3883<MutantEnderman, class_583<MutantEnderman>>)this, context.method_43337()));
    }

    private static float getDeathProgress(MutantEnderman mutantEnderman) {
        return (float)(mutantEnderman.field_6213 - 80) / (float)(MutantEnderman.DEATH_ANIMATION.duration() - 80);
    }

    public boolean shouldRender(MutantEnderman livingEntityIn, class_4604 camera, double camX, double camY, double camZ) {
        if (super.method_4068((class_1308)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
            return livingEntityIn.getTeleportPosition().map(class_243::method_24955).map(arg_0 -> ((class_4048)livingEntityIn.method_5864().method_18386()).method_30757(arg_0)).filter(arg_0 -> ((class_4604)camera).method_23093(arg_0)).isPresent();
        }
        return false;
    }

    public void render(MutantEnderman entityIn, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        if (entityIn.isClone()) {
            this.field_4737 = this.cloneModel;
            this.cloneModel.field_3370 = entityIn.method_6510();
            this.field_4673 = 0.5f;
            this.field_4672 = 0.5f;
        } else {
            this.field_4737 = this.endermanModel;
            this.field_4673 = 0.8f;
            this.field_4672 = entityIn.field_6213 > 80 ? 1.0f - MutantEndermanRenderer.getDeathProgress(entityIn) : 1.0f;
        }
        this.teleportAttack = false;
        super.method_4072(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (entityIn.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
            this.teleportAttack = true;
            entityIn.getTeleportPosition().ifPresent(pos -> {
                matrixStackIn.method_22903();
                double d0 = class_3532.method_16436((double)partialTicks, (double)entityIn.field_6038, (double)entityIn.method_23317());
                double d1 = class_3532.method_16436((double)partialTicks, (double)entityIn.field_5971, (double)entityIn.method_23318());
                double d2 = class_3532.method_16436((double)partialTicks, (double)entityIn.field_5989, (double)entityIn.method_23321());
                matrixStackIn.method_22904((double)pos.method_10263() + 0.5 - d0, (double)pos.method_10264() - d1, (double)pos.method_10260() + 0.5 - d2);
                super.method_4072(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.method_22909();
            });
        }
    }

    @Override
    protected boolean hasAlternateRender(MutantEnderman mob, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        if (mob.field_6213 > 80) {
            class_4588 ivertexbuilder = bufferIn.getBuffer(class_1921.method_23573((class_2960)DEATH_TEXTURE));
            this.field_4737.method_2828(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, MutantEndermanRenderer.getDeathProgress(mob));
            class_4588 ivertexbuilder1 = bufferIn.getBuffer(DEATH_RENDER_TYPE);
            this.field_4737.method_2828(matrixStackIn, ivertexbuilder1, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public class_243 getRenderOffset(MutantEnderman entityIn, float partialTicks) {
        boolean death;
        boolean stare = entityIn.getAnimation() == MutantEnderman.STARE_ANIMATION;
        boolean scream = entityIn.getAnimation() == MutantEnderman.SCREAM_ANIMATION;
        boolean clone = entityIn.isClone() && entityIn.method_6510();
        boolean telesmash = entityIn.getAnimation() == MutantEnderman.TELESMASH_ANIMATION && entityIn.getAnimationTick() < 18;
        boolean bl = death = entityIn.getAnimation() == MutantEnderman.DEATH_ANIMATION;
        if (!(stare || scream || clone || telesmash || death)) {
            return super.method_23169((class_1297)entityIn, partialTicks);
        }
        double shake = 0.03;
        if (clone) {
            shake = 0.02;
        } else if (death) {
            shake = entityIn.getAnimationTick() < 80 ? 0.02 : 0.05;
        } else if (entityIn.getAnimationTick() >= 40) {
            shake *= 0.5;
        }
        return new class_243(entityIn.method_6051().method_43059() * shake, 0.0, entityIn.method_6051().method_43059() * shake);
    }

    protected float getFlipDegrees(MutantEnderman livingEntity) {
        return 0.0f;
    }

    protected class_1921 getRenderType(MutantEnderman livingEntity, boolean isVisible, boolean visibleToSpectator, boolean isGlowing) {
        return livingEntity.isClone() ? null : super.method_24302((class_1309)livingEntity, isVisible, visibleToSpectator, isGlowing);
    }

    public class_2960 getTextureLocation(MutantEnderman entity) {
        return TEXTURE;
    }

    static class EyesLayer
    extends class_3887<MutantEnderman, class_583<MutantEnderman>> {
        public EyesLayer(class_3883<MutantEnderman, class_583<MutantEnderman>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, MutantEnderman entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.isClone()) {
                class_4588 ivertexbuilder = bufferIn.getBuffer(EYES_RENDER_TYPE);
                this.method_17165().method_2828(matrixStackIn, ivertexbuilder, 0xF00000, class_4608.field_21444, 1.0f, 1.0f, 1.0f, entity.field_6213 > 80 ? 1.0f - MutantEndermanRenderer.getDeathProgress(entity) : 1.0f);
            }
        }
    }

    class SoulLayer
    extends EndersoulLayer<MutantEnderman, class_583<MutantEnderman>> {
        public SoulLayer(class_3883<MutantEnderman, class_583<MutantEnderman>> entityRendererIn) {
            super(entityRendererIn);
        }

        @Override
        public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, MutantEnderman entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean teleport = entity.getAnimation() == MutantEnderman.TELEPORT_ANIMATION && entity.getAnimationTick() < 10;
            boolean scream = entity.getAnimation() == MutantEnderman.SCREAM_ANIMATION;
            boolean clone = entity.isClone();
            if (teleport || scream || clone) {
                float scale = 0.0f;
                if (teleport) {
                    scale = 1.2f + ((float)entity.getAnimationTick() + partialTicks) / 10.0f;
                    if (MutantEndermanRenderer.this.teleportAttack) {
                        scale = 2.2f - ((float)entity.getAnimationTick() + partialTicks) / 10.0f;
                    }
                }
                if (scream) {
                    scale = entity.getAnimationTick() < 40 ? 1.2f + ((float)entity.getAnimationTick() + partialTicks) / 40.0f : (entity.getAnimationTick() < 160 ? 2.2f : Math.max(0.0f, 2.2f - ((float)entity.getAnimationTick() + partialTicks) / 10.0f));
                }
                matrixStackIn.method_22903();
                if (!clone) {
                    matrixStackIn.method_22905(scale, scale * 0.8f, scale);
                }
                super.render(matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                matrixStackIn.method_22909();
            }
        }

        @Override
        protected float getAlpha(MutantEnderman entity, float partialTicks) {
            float alpha = 1.0f;
            if (entity.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
                if (!MutantEndermanRenderer.this.teleportAttack && entity.getAnimationTick() >= 8) {
                    alpha -= ((float)entity.getAnimationTick() - 8.0f + partialTicks) / 2.0f;
                }
                if (MutantEndermanRenderer.this.teleportAttack && entity.getAnimationTick() < 2) {
                    alpha = ((float)entity.getAnimationTick() + partialTicks) / 2.0f;
                }
            }
            if (entity.getAnimation() == MutantEnderman.SCREAM_ANIMATION) {
                if (entity.getAnimationTick() < 40) {
                    alpha = ((float)entity.getAnimationTick() + partialTicks) / 40.0f;
                } else if (entity.getAnimationTick() >= 160) {
                    alpha = 1.0f - ((float)entity.getAnimationTick() + partialTicks) / 40.0f;
                }
            }
            return alpha;
        }
    }

    static class HeldBlocksLayer
    extends class_3887<MutantEnderman, class_583<MutantEnderman>> {
        private final class_776 blockRenderer;

        public HeldBlocksLayer(class_3883<MutantEnderman, class_583<MutantEnderman>> entityRendererIn, class_776 blockRenderer) {
            super(entityRendererIn);
            this.blockRenderer = blockRenderer;
        }

        public void render(class_4587 poseStack, class_4597 bufferIn, int packedLightIn, MutantEnderman entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            class_583 class_5832;
            if (entity.getAnimation() != MutantEnderman.CLONE_ANIMATION && (class_5832 = this.method_17165()) instanceof MutantEndermanModel) {
                MutantEndermanModel model = (MutantEndermanModel)class_5832;
                for (int i = 0; i < 4; ++i) {
                    if (entity.getHeldBlock(i) <= 0) continue;
                    poseStack.method_22903();
                    model.translateRotateArm(poseStack, i);
                    poseStack.method_22904(0.0, 1.2, 0.0);
                    float tick = (float)entity.field_6012 + (float)(i + 1) * 2.0f * (float)Math.PI + partialTicks;
                    poseStack.method_22907(class_7833.field_40714.rotationDegrees(tick * 10.0f));
                    poseStack.method_22907(class_7833.field_40716.rotationDegrees(tick * 8.0f));
                    poseStack.method_22907(class_7833.field_40718.rotationDegrees(tick * 6.0f));
                    poseStack.method_22905(-0.75f, -0.75f, 0.75f);
                    poseStack.method_22904(-0.5, -0.5, 0.5);
                    poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                    this.blockRenderer.method_3353(class_2248.method_9531((int)entity.getHeldBlock(i)), poseStack, bufferIn, packedLightIn, class_4608.field_21444);
                    poseStack.method_22909();
                }
            }
        }
    }
}

