/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.lyof.sortilege.attribute.ModAttributes;
import net.lyof.sortilege.config.ModConfig;
import net.lyof.sortilege.enchant.ModEnchants;
import net.lyof.sortilege.enchant.staff.ElementalStaffEnchantment;
import net.lyof.sortilege.particle.ModParticles;
import net.lyof.sortilege.util.ItemHelper;
import net.lyof.sortilege.util.MathHelper;
import net.lyof.sortilege.util.XPHelper;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaffItem
extends class_1831 {
    @Nullable
    public ModConfig.StaffInfo rawInfos;
    public float damage;
    public int pierce;
    public int range;
    public int cooldown;
    public int charge;
    public int xp_cost;
    private final Multimap<class_1320, class_1322> attributeModifiers;
    @Nullable
    public class_1268 handSave;

    public StaffItem(ModConfig.StaffInfo stats, FabricItemSettings settings) {
        this(stats.tier, stats.damage, stats.pierce, stats.range, stats.durability, stats.cooldown, stats.charge_time, stats.xp_cost, stats.fireRes ? settings.fireproof() : settings);
        this.rawInfos = stats;
    }

    public StaffItem(class_1832 tier, int damage, int targets, int range, int dura, int cooldown, int charge, int xp_cost, FabricItemSettings settings) {
        super(tier, (class_1792.class_1793)settings.maxDamage(dura));
        this.damage = damage;
        this.pierce = targets;
        this.range = range;
        this.cooldown = cooldown;
        this.charge = charge;
        this.xp_cost = xp_cost;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)ModAttributes.STAFF_DAMAGE, (Object)new class_1322(ModAttributes.STAFF_DAMAGE.getUUID(), "Weapon modifier", (double)damage, class_1322.class_1323.field_6328));
        builder.put((Object)ModAttributes.STAFF_PIERCE, (Object)new class_1322(ModAttributes.STAFF_PIERCE.getUUID(), "Weapon modifier", (double)targets, class_1322.class_1323.field_6328));
        builder.put((Object)ModAttributes.STAFF_RANGE, (Object)new class_1322(ModAttributes.STAFF_RANGE.getUUID(), "Weapon modifier", (double)range, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public int getXPCost(class_1799 itemstack) {
        return Math.max(this.xp_cost + ItemHelper.getEnchantLevel(ModEnchants.IGNORANCE_CURSE, itemstack) - ItemHelper.getEnchantLevel(ModEnchants.WISDOM, itemstack), 0);
    }

    public float getAttackDamage(class_1799 stack) {
        return this.damage + (float)ItemHelper.getEnchantLevel(ModEnchants.POTENCY, stack);
    }

    public int getAttackRange(class_1799 stack) {
        return this.range + ItemHelper.getEnchantLevel(ModEnchants.STABILITY, stack) * 2;
    }

    public int getPierce(class_1799 stack) {
        return this.pierce + ItemHelper.getEnchantLevel(ModEnchants.CHAINING, stack);
    }

    public boolean method_7878(class_1799 staff, class_1799 stack) {
        if (this.rawInfos != null) {
            return this.rawInfos.repair.get().method_8093(stack);
        }
        return super.method_7878(staff, stack);
    }

    public int method_7837() {
        if (this.rawInfos != null) {
            return this.rawInfos.enchantability;
        }
        return super.method_7837();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        if (slot == class_1304.field_6173) {
            return this.attributeModifiers;
        }
        return super.method_7844(slot);
    }

    public void method_7851(class_1799 itemstack, @Nullable class_1937 level, List<class_2561> list, class_1836 flag) {
        super.method_7851(itemstack, level, list, flag);
        if (this.getXPCost(itemstack) > 0) {
            list.add((class_2561)class_2561.method_43471((String)"sortilege.staff.cost").method_27693(" " + this.getXPCost(itemstack) + " ").method_10852((class_2561)class_2561.method_43471((String)"sortilege.experience")).method_27692(class_124.field_1060));
            list.add((class_2561)class_2561.method_43470((String)""));
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 world, class_1657 player, @NotNull class_1268 hand) {
        class_1799 staff = player.method_5998(hand);
        if (!player.method_7337() && !XPHelper.hasXP(player, this.getXPCost(staff))) {
            return super.method_7836(world, player, hand);
        }
        this.handSave = hand;
        player.method_6019(hand);
        return super.method_7836(world, player, hand);
    }

    public class_1799 method_7861(class_1799 staff, class_1937 world, class_1309 entity) {
        if (!(entity instanceof class_1657)) {
            return staff;
        }
        class_1657 player = (class_1657)entity;
        ElementalStaffEnchantment element = null;
        if (ItemHelper.hasEnchant(ModEnchants.BRAZIER, staff)) {
            element = (ElementalStaffEnchantment)ModEnchants.BRAZIER;
        } else if (ItemHelper.hasEnchant(ModEnchants.BLIZZARD, staff)) {
            element = (ElementalStaffEnchantment)ModEnchants.BLIZZARD;
        } else if (ItemHelper.hasEnchant(ModEnchants.BLAST, staff)) {
            element = (ElementalStaffEnchantment)ModEnchants.BLAST;
        } else if (ItemHelper.hasEnchant(ModEnchants.BLITZ, staff)) {
            element = (ElementalStaffEnchantment)ModEnchants.BLITZ;
        }
        int element_level = ItemHelper.getEnchantLevel(element, staff);
        int cost = this.getXPCost(staff);
        float damage = this.getAttackDamage(staff);
        int range = this.getAttackRange(staff);
        int targetsLeft = this.getPierce(staff);
        float kinesis = ItemHelper.getEnchantLevel(ModEnchants.PUSH, staff) - ItemHelper.getEnchantLevel(ModEnchants.PULL, staff);
        if (cost > 0 && !player.method_7337()) {
            if (!XPHelper.hasXP(player, cost)) {
                return staff;
            }
            player.method_7255(-cost);
        }
        if (this.handSave != null) {
            player.method_23667(this.handSave, true);
        }
        world.method_8396(player, player.method_24515(), class_3417.field_26982, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7357().method_7906(staff.method_7909(), this.cooldown);
        staff.method_7956(1, (class_1309)player, e -> e.method_20236(this.handSave));
        class_243 look = MathHelper.getLookVector(player);
        ArrayList<String> targetsHit = new ArrayList<String>();
        float x = (float)player.method_23317();
        float y = (float)player.method_23318();
        float z = (float)player.method_23321();
        if (world instanceof class_3218) {
            class_3218 server = (class_3218)world;
            if (this.rawInfos != null) {
                server.method_8503().method_3734().method_44252(new class_2168((class_2165)player, new class_243((double)x, (double)y, (double)z), class_241.field_1340, server, 4, "", (class_2561)class_2561.method_43470((String)""), server.method_8503(), (class_1297)player).method_36321(class_2165.field_17395), this.rawInfos.on_shoot);
            }
        }
        class_1282 damagetype = player.method_48923().method_48815((class_1297)player, (class_1297)player);
        List<Triple<Float, Float, Float>> colors = new ArrayList<Triple<Float, Float, Float>>(element == null ? List.of(new MutableTriple((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f))) : element.colors);
        if (staff.method_7942()) {
            colors.add((Triple<Float, Float, Float>)new MutableTriple((Object)Float.valueOf(0.7f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f)));
        }
        if (this.rawInfos != null && this.rawInfos.colors.size() > 0) {
            colors = this.rawInfos.colors;
        }
        int step = 5;
        for (int i = 1; i < range * step; ++i) {
            x = (float)(player.method_23317() + look.field_1352 * (double)i / (double)step);
            y = (float)(player.method_23318() + look.field_1351 * (double)i / (double)step + (double)player.method_18381(player.method_18376()) - 0.2);
            z = (float)(player.method_23321() + look.field_1350 * (double)i / (double)step);
            if (world.method_8608()) {
                ModParticles.spawnWisps(world, x, y, z, 1, MathHelper.randi(colors));
            }
            if (i * 2 % step != 0) continue;
            class_2338 pos = new class_2338((int)Math.round((double)x - 0.5), (int)Math.round((double)y - 0.5), (int)Math.round((double)z - 0.5));
            List entities = player.method_37908().method_8335((class_1297)player, new class_238(pos).method_1014(0.1));
            if (targetsLeft <= 0 || world.method_8320(pos).method_51367()) break;
            for (int index = 0; !entities.isEmpty() && entities.size() > index && targetsLeft > 0; ++index) {
                class_1309 target;
                Object e2 = entities.get(index);
                if (!(e2 instanceof class_1309) || targetsHit.contains((target = (class_1309)e2).method_5845())) continue;
                target.method_5643(damagetype, damage);
                if (world instanceof class_3218) {
                    class_3218 server = (class_3218)world;
                    if (this.rawInfos != null) {
                        server.method_8503().method_3734().method_44252(new class_2168((class_2165)player, new class_243((double)x, (double)y, (double)z), class_241.field_1340, server, 4, "", (class_2561)class_2561.method_43470((String)""), server.method_8503(), (class_1297)player).method_36321(class_2165.field_17395), this.rawInfos.on_hit_self);
                        server.method_8503().method_3734().method_44252(new class_2168((class_2165)player, new class_243((double)x, (double)y, (double)z), class_241.field_1340, server, 4, "", (class_2561)class_2561.method_43470((String)""), server.method_8503(), (class_1297)target).method_36321(class_2165.field_17395), this.rawInfos.on_hit_target);
                    }
                }
                if (element != null) {
                    element.triggerAttack(target, ItemHelper.getEnchantLevel(element, staff));
                }
                if (element == ModEnchants.BLAST && element_level > 1) {
                    world.method_8437((class_1297)player, (double)x, (double)y, (double)z, 1.0f, class_1937.class_7867.field_40888);
                }
                if (kinesis != 0.0f) {
                    target.method_18799(look.method_1021((double)kinesis).method_1031(0.0, 0.4, 0.0));
                }
                targetsHit.add(target.method_5845());
                --targetsLeft;
            }
        }
        if (element == ModEnchants.BLAST) {
            world.method_8437((class_1297)player, (double)x, (double)y, (double)z, 1.0f, class_1937.class_7867.field_40888);
        }
        return staff;
    }

    public int method_7881(class_1799 stack) {
        return this.charge;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }
}

