/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.crafting;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public abstract class RecipeLock {
    public static RecipeLock NONE = new RecipeLock(){

        @Override
        public boolean matches(class_3222 player) {
            return false;
        }

        @Override
        public class_5250 getFailMessage(class_3222 player) {
            return class_2561.method_43473();
        }
    };
    protected static Map<String, RecipeLock> RECIPE_LOCKS = new HashMap<String, RecipeLock>();

    public abstract boolean matches(class_3222 var1);

    public abstract class_5250 getFailMessage(class_3222 var1);

    public static void clear() {
        RECIPE_LOCKS.clear();
    }

    public static void register(String recipe, RecipeLock lock) {
        RECIPE_LOCKS.putIfAbsent(recipe, lock);
    }

    public static RecipeLock get(String recipe) {
        return RECIPE_LOCKS.getOrDefault(recipe, NONE);
    }

    public static Map<String, RecipeLock> getAll() {
        return RECIPE_LOCKS;
    }

    public static class AdvancementLock
    extends RecipeLock {
        public String id;

        public AdvancementLock(String id) {
            this.id = id;
        }

        @Override
        public boolean matches(class_3222 player) {
            class_161 advc = Objects.requireNonNull(player.method_5682()).method_3851().method_12896(new class_2960(this.id));
            return advc != null && !player.method_14236().method_12882(advc).method_740();
        }

        @Override
        public class_5250 getFailMessage(class_3222 player) {
            class_161 advc = Objects.requireNonNull(player.method_5682()).method_3851().method_12896(new class_2960(this.id));
            if (advc == null) {
                return class_2561.method_43473();
            }
            return class_2561.method_43469((String)"sortilege.crafting.requires_advancement", (Object[])new Object[]{advc.method_684()});
        }

        public String toString() {
            return "AdvancementLock{id='" + this.id + "'}";
        }
    }

    public static class LevelLock
    extends RecipeLock {
        public int lvl;

        public LevelLock(int lvl) {
            this.lvl = lvl;
        }

        @Override
        public boolean matches(class_3222 player) {
            return player.field_7520 < this.lvl;
        }

        @Override
        public class_5250 getFailMessage(class_3222 player) {
            return class_2561.method_43469((String)"sortilege.crafting.requires_level", (Object[])new Object[]{this.lvl});
        }

        public String toString() {
            return "LevelLock{lvl=" + this.lvl + "}";
        }
    }
}

