/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.config;

import com.google.gson.Gson;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.lyof.sortilege.Sortilege;
import net.lyof.sortilege.config.ConfigEntries;
import net.lyof.sortilege.config.ConfigEntry;
import net.lyof.sortilege.util.MathHelper;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class ModConfig {
    public static final ConfigEntry<Double> VERSION = new ConfigEntry<Double>("TECHNICAL.VERSION_DO_NOT_EDIT", 0.0);
    public static final ConfigEntry<Boolean> RELOAD = new ConfigEntry<Boolean>("TECHNICAL.FORCE_RESET", false);
    public static Map CONFIG = new TreeMap();
    public static List<Pair<String, StaffInfo>> STAFFS = new ArrayList<Pair<String, StaffInfo>>();
    public static final String DEFAULT_CONFIG = "{\n  \"TECHNICAL\": {\n    \"VERSION_DO_NOT_EDIT\": 1.7,\n    \"FORCE_RESET\": false\n  },\n\n  // This config file uses a custom defined parser. That's why there are comments here, they wouldn't be valid in any other .json file.\n  //    To add a comment yourself, just start a line with // like I did here\n  //    (although their main use is explaining you what the entries do)\n\n  // CATEGORY: ENCHANTING\n  \"enchantments\": {\n    \"enchant_limiter\": {\n      // Limits how many enchantments can be added to an item. Set it to -1 to disable the limiter,\n      //    and to 0 to disable enchanting as a whole\n      \"default\": 3,\n      // Should curses add enchantment slots instead of using them\n      \"curses_add_slots\": true,\n      // Override modes include \"relative\" and \"absolute\".\n      //    If set to \"relative\", the overrides defined below will be added onto the default limit.\n      //    If set to \"absolute\", they'll replace the default limits.\n      \"override_mode\": \"relative\",\n      // Overrides to the amount of enchantments an item can have. Must be of the form \"modid:itemid\": value\n      \"overrides\": {\n        \"minecraft:golden_shovel\": 2,\n        \"minecraft:golden_pickaxe\": 2,\n        \"minecraft:golden_axe\": 2,\n        \"minecraft:golden_hoe\": 2,\n        \"minecraft:golden_sword\": 2,\n        \"minecraft:golden_helmet\": 2,\n        \"minecraft:golden_chestplate\": 2,\n        \"minecraft:golden_leggings\": 2,\n        \"minecraft:golden_boots\": 2,\n        \"sortilege:golden_staff\": 2,\n\n        \"miningmaster:ultima_sword\": 1,\n        \"miningmaster:ultima_pickaxe\": 1\n      },\n      // Should an item's maximum enchantments be displayed even when it is not enchanted\n      \"always_show_limit\": true,\n      \"limitite\": {\n        // Should Limitite have an enchantment glint\n        \"is_foil\": true,\n        // 1 in X chance for Limitite to spawn as loot in chests. Set to 0 or lower to disable it\n        \"loot_weight\": 24,\n        // How many Limitites can be applied to a single item\n        \"max_limit_break\": 3\n      }\n    },\n\n    \"enchant_catalyst\": {\n      // Should Enchanted Books be usable as catalysts to increase the odds of getting their enchantments\n      // If this is set to false and no catalyst is loaded from datapacks, the module will be disabled\n      \"allow_books\": true,\n      // Chance (0 - 1) for non book catalysts to activate for each option in the enchanting table\n      \"catalyst_activation_chance\": 0.5,\n\n      // Should items usable as catalysts display it in their tooltip\n      \"show_in_tooltip\": true\n    },\n\n    // Allow using Enchanted Books on items in inventory\n    \"allow_inventory_enchanting\": false,\n\n    // Should the Magic Protection enchantment be compatible with vanilla Protection enchantments\n    \"magic_protection_protection_compatibility\": false,\n    // Feather Falling at this level completely negates fall damage (should be set to the maximum if enabled, or higher if disabled)\n    \"better_feather_falling\": 4,\n    // Unbreaking at this level makes an item completely unbreakable (should be set to the maximum if enabled, or higher if disabled)\n    \"better_unbreaking\": 3,\n    // Should Magic Protection also give a level*5 chance to dodge any attack\n    \"better_magic_protection\": true,\n    // Should Fire Protection at this level on every armor slot at once grant fire immunity\n    \"better_fire_protection\": 4,\n    // Should Bane of Arthropods apply a 0.5*(level + 1) seconds of slowness on hit\n    \"better_bane_of_arthropods\": true,\n\n    // Set these to false to disable the corresponding enchantment from appearing in game (it won't be registered)\n    \"enabled_enchants\": {\n      \"potency\": true,\n      \"stability\": true,\n      \"chaining\": true,\n      \"wisdom\": true,\n      \"push\": true,\n      \"pull\": true,\n      \"brazier\": true,\n      \"blizzard\": true,\n      \"blast\": true,\n      \"blitz\": true,\n      \"ignorance_curse\": true,\n\n      \"magic_protection\": true,\n      \"arcane\": true,\n      \"soulbound\": true\n    }\n  },\n\n  // CATEGORY: EXPERIENCE\n  \"experience\": {\n    \"witch_hat\": {\n      // Should the Witch Hat be registered as an item\n      \"enable\": true,\n      // Chance for the Witch Hat to drop when killing a Witch. Set to 0 to disable the drop\n      \"drop_chance\": 0.1,\n      // How many extra experience points should drop when killing a monster with the Witch Hat equipped\n      \"xp_bonus\": 3\n    },\n    // Should enchanting in an enchanting table cost more xp than the default 1 2 3 levels\n    \"increased_enchant_costs\": true,\n    // If the above is true, defines the new costs to replace 1 2 3\n    \"costs\": [1, 3, 7],\n    // If increased_enchant_costs is true, defines the required xp levels to enchants\n    \"needed\": [5, 10, 15],\n    // Should Anvils never cost experience\n    \"no_xp_anvil\": true,\n    // Maximum experience level a player can have before it can't increase anymore. Set to -1 to disable the limit,\n    //    and to 0 to disable experience\n    \"level_cap\": 100,\n    // How much xp points are needed to level up, in place of the exponential formula vanilla has.\n    //    Set to 0 or lower to use vanilla's formula\n    \"linear_xp_requirement\": 50,\n    // Should monsters have a chance to give a bunch of extra experience points when killed\n    \"xp_bounty\": {\n      // Should the sortilege:bounties tag act as a whitelist instead of a blacklist. It defines which mobs can drop bounties\n      \"tag_is_whitelist\": false,\n      // Amount of xp points bounties drop\n      \"value\": 20,\n      // Chance for a bounty to happen\n      \"chance\": 0.05\n    },\n\n    // Locks certain recipes behind experience levels or advancements.\n    //    Each entry must be of the form \"modid:recipeid\": minimalxplevel or \"modid:recipeid\": \"advancementid\"\n    //    The default config locks the crafting of Ender Eyes behind level 30 and the Beacon behind summoning the Wither, as an example\n    \"recipe_locks\": {\n      \"minecraft:ender_eye\": 30,\n      \"minecraft:beacon\": \"minecraft:nether/summon_wither\"\n    }\n  },\n\n  // CATEGORY: DEATH\n  \"death\": {\n    // Enable a balanced keepInventory only for experience\n    \"xp_keeping\": {\n      \"enable\": true,\n      // Should players killed by players drop their xp or give it to their assassin directly\n      \"allow_stealing_from_players\": true,\n      // Ratio of xp kept on death\n      \"self_ratio\": 0.3,\n      // Ratio of xp stolen by the attacker, and dropped back when it's killed\n      \"attacker_ratio\": 0.6,\n      // Ratio of xp dropped on the ground on death\n      \"drop_ratio\": 0.1,\n      // Entity data id to use to store stolen xp. Only change this if the default is causing conflicts\n      \"stolen_xp_data\": 41\n    },\n    // Keep equipped items (armor and hotbar) on death\n    \"keep_equipped\": false,\n    // Should the Soulbound enchantment be removed on use\n    \"consume_soulbound\": false,\n    // Display death coordinates instead of the score from vanilla on the death screen\n    \"show_coordinates_on_death\": true,\n    // Should the mob that killed you be made glowing\n    \"glowing_killer\": true\n  },\n\n  // CATEGORY: BREWING\n  \"brewing\": {\n    // Should Antidotes be registered as items\n    \"enable\": true,\n    // A list of potion effects for which Antidotes don't get registered\n    \"antidote_blacklist\": [\n    ],\n    \"antidote_stack_size\": 4\n  },\n\n  // CATEGORY: STAFFS\n  \"staffs\": {\n    // Amount of xp points needed to use a staff, if not set\n    \"default_xp_cost\": 0,\n    // Time staffs need to be held down (in ticks) before shooting, if not set\n    \"default_charge_time\": 1,\n    \"entries\": [\n      {\n        // Example entry, not loaded in game as it's only for demonstration purposes\n        \"example_staff\": {\n          // Sets the repair material and the durability if not set\n          \"tier\": \"GOLD\",\n          // Staff's enchantability on the Enchanting Table. Defaults to the tier's\n          \"enchantability\": 22,\n          // Half hearts of damage the staff deals\n          \"damage\": 5,\n          // Maximal number of targets the staff can pierce through\n          \"pierce\": 2,\n          // Range of the staff, in half blocks\n          \"range\": 10,\n          // Durability of the staff. Defaults to tier's\n          \"durability\": 512,\n          // Item to be used to repair the staff. Defaults to the tier's\n          \"repair_item\": \"minecraft:obsidian\",\n          // Amount of ticks to wait for between each shots\n          \"cooldown\": 20,\n          // Amount of ticks of casting to shoot. Defaults to default_charge_time above\n          \"charge_time\": 1,\n          // Amount of xp points needed to shoot. Defaults to default_xp_cost above\n          \"xp_cost\": 0,\n          // Custom RGB colors to be used for the staff's beam. If unset, the beam will be white unless the staff has enchantments\n          \"beam_color\": [\n            [0.5, 0, 0],\n            [0, 0.5, 0],\n            [0, 0, 0.5]\n          ],\n          // Whether the staff is resistant to fire like Netherite items. Defaults to false\n          \"fire_res\": true,\n          // Mod needed to be loaded for the staff to appear in game. Defaults to minecraft\n          \"dependency\": \"nah\",\n          // Commands to be run when using the staff\n          \"on_shoot\": \"/give @s minecraft:lapis_lazuli\",\n          \"on_hit_self\": \"/effect give @s minecraft:regeneration\",\n          \"on_hit_target\": \"/tp @s ~ ~2 ~\"\n        }\n      },\n      // Actual staffs\n      {\n        \"wooden_staff\": {\n          \"tier\": \"WOOD\",\n          \"damage\": 3,\n          \"pierce\": 1,\n          \"range\": 6,\n          \"cooldown\": 15\n        }\n      },\n      {\n        \"stone_staff\": {\n          \"tier\": \"STONE\",\n          \"damage\": 4,\n          \"pierce\": 1,\n          \"range\": 8,\n          \"cooldown\": 20\n        }\n      },\n      {\n        \"iron_staff\": {\n          \"tier\": \"IRON\",\n          \"damage\": 5,\n          \"pierce\": 1,\n          \"range\": 10,\n          \"cooldown\": 15\n        }\n      },\n      {\n        \"golden_staff\": {\n          \"tier\": \"GOLD\",\n          \"damage\": 3,\n          \"pierce\": 2,\n          \"range\": 14,\n          \"cooldown\": 10\n        }\n      },\n      {\n        \"diamond_staff\": {\n          \"tier\": \"DIAMOND\",\n          \"damage\": 5,\n          \"pierce\": 2,\n          \"range\": 12,\n          \"cooldown\": 15\n        }\n      },\n      {\n        \"netherite_staff\": {\n          \"tier\": \"NETHERITE\",\n          \"damage\": 6,\n          \"pierce\": 3,\n          \"range\": 16,\n          \"fire_resistant\": true,\n          \"cooldown\": 20\n        }\n      }\n    ]\n  }\n}";

    public static <T> T get(String path, T fallback) {
        return new ConfigEntry<T>(path, fallback).get();
    }

    public static void register() {
        ModConfig.register(false);
    }

    public static void register(boolean force) {
        boolean create;
        String path = FabricLoader.getInstance().getConfigDir().resolve("sortilege.json").toString();
        Sortilege.log("Loading Configs for Sortilege");
        File config = new File(path);
        boolean bl = create = !config.isFile();
        if (create || force) {
            try {
                config.delete();
                config.createNewFile();
                FileWriter writer = new FileWriter(path);
                writer.write(DEFAULT_CONFIG);
                writer.close();
                Sortilege.log("Sortilege Config file created");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String configContent = DEFAULT_CONFIG;
        try {
            configContent = FileUtils.readFileToString((File)config, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CONFIG = (Map)new Gson().fromJson(ModConfig.parseJson(configContent), Map.class);
        ConfigEntries.reload();
        if (!force && RELOAD.get().booleanValue()) {
            ModConfig.register(true);
            return;
        }
        if (ModConfig.getVersion() > VERSION.get()) {
            Sortilege.log("Your Sortilege configs are outdated! Consider deleting them so they can refresh");
        }
        ArrayList<Pair<String, StaffInfo>> result = new ArrayList<Pair<String, StaffInfo>>();
        for (Map<String, Map<String, Object>> staff : ConfigEntries.staffEntries) {
            String id = String.valueOf(List.of(staff.keySet().toArray()).get(0));
            result.add((Pair<String, StaffInfo>)new Pair((Object)id, (Object)new StaffInfo(staff.get(id))));
        }
        STAFFS = result;
    }

    public static String parseJson(String text) {
        StringBuilder result = new StringBuilder();
        for (String line : text.split("\n")) {
            if (line.strip().startsWith("//")) continue;
            result.append("\n").append(line);
        }
        return result.toString();
    }

    public static double getVersion() {
        String text = DEFAULT_CONFIG;
        int start = 0;
        while (!List.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('.')).contains(Character.valueOf(text.charAt(start)))) {
            ++start;
        }
        int end = start + 1;
        while (List.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('.')).contains(Character.valueOf(text.charAt(end)))) {
            ++end;
        }
        return Double.parseDouble(text.substring(start, end));
    }

    public static class StaffInfo {
        public class_1832 tier;
        public int enchantability;
        public int damage;
        public int pierce;
        public int range;
        public int durability;
        public Supplier<class_1856> repair;
        public int cooldown;
        public int charge_time;
        public int xp_cost;
        public List<Triple<Float, Float, Float>> colors = new ArrayList<Triple<Float, Float, Float>>();
        public boolean fireRes;
        public String dependency;
        public String on_shoot;
        public String on_hit_self;
        public String on_hit_target;

        public StaffInfo(Map<String, Object> dict) {
            this((String)dict.getOrDefault("tier", "WOOD"), MathHelper.toInt(dict.getOrDefault("enchantability", -1)), MathHelper.toInt(dict.getOrDefault("damage", 2)), MathHelper.toInt(dict.getOrDefault("pierce", 1)), MathHelper.toInt(dict.getOrDefault("range", 8)), MathHelper.toInt(dict.getOrDefault("durability", -1)), (String)dict.getOrDefault("repair_item", ""), MathHelper.toInt(dict.getOrDefault("cooldown", 15)), MathHelper.toInt(dict.getOrDefault("charge_time", ConfigEntries.staffsDefaultCharge)), MathHelper.toInt(dict.getOrDefault("xp_cost", ConfigEntries.staffsDefaultCost)), dict.getOrDefault("beam_color", new ArrayList()), dict.containsKey("fire_resistant") && (Boolean)dict.get("fire_resistant") != false, (String)dict.getOrDefault("dependency", "minecraft"), (String)dict.getOrDefault("on_shoot", ""), (String)dict.getOrDefault("on_hit_self", ""), (String)dict.getOrDefault("on_hit_target", ""));
        }

        public StaffInfo(String tier, int enchant, int dmg, int pierce, int range, int dura, String repair, int cooldown, int charge_time, int xp_cost, List<List<Double>> colors, boolean fire_res, String dependency, String on_shoot, String on_hit_self, String on_hit_target) {
            try {
                this.tier = class_1834.valueOf((String)tier);
            }
            catch (IllegalArgumentException e) {
                this.tier = class_1834.field_8922;
            }
            this.enchantability = enchant == -1 ? this.tier.method_8026() : enchant;
            this.damage = dmg;
            this.pierce = pierce;
            this.range = range;
            this.durability = dura == -1 ? this.tier.method_8025() : dura;
            this.repair = repair.equals("") ? () -> this.tier.method_8023() : () -> class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)class_7923.field_41178.method_10223(new class_2960(repair))});
            this.cooldown = Math.max(cooldown, 0);
            this.charge_time = Math.max(charge_time, 1);
            this.xp_cost = xp_cost;
            try {
                for (List<Double> triple : colors) {
                    this.colors.add((Triple<Float, Float, Float>)new MutableTriple((Object)Float.valueOf(triple.get(0).floatValue()), (Object)Float.valueOf(triple.get(1).floatValue()), (Object)Float.valueOf(triple.get(2).floatValue())));
                }
            }
            catch (Exception e) {
                Sortilege.log("Encountered an error while parsing a Staff's beam color");
            }
            this.fireRes = fire_res;
            this.dependency = dependency;
            this.on_shoot = on_shoot;
            this.on_hit_self = on_hit_self;
            this.on_hit_target = on_hit_target;
        }

        public String toString() {
            return "StaffInfo{tier=" + this.tier + ", enchantability=" + this.enchantability + ", damage=" + this.damage + ", pierce=" + this.pierce + ", range=" + this.range + ", durability=" + this.durability + ", repair=" + Arrays.toString(this.repair.get().method_8105()) + ", cooldown=" + this.cooldown + ", charge_time=" + this.charge_time + ", xp_cost=" + this.xp_cost + ", color=" + this.colors + ", fire_res=" + this.fireRes + ", dependency='" + this.dependency + "', on_shoot='" + this.on_shoot + "', on_hit_self='" + this.on_hit_self + "', on_hit_target='" + this.on_hit_target + "'}";
        }
    }
}

